/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.S3CatalogTarget;
import java.util.List;

@SdkInternalApi
public class S3CatalogTargetMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKeys").build();
    private static final MarshallingInfo<String> TABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<StructuredPojo> SCHEMACHANGEPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaChangePolicy").build();
    private static final S3CatalogTargetMarshaller instance = new S3CatalogTargetMarshaller();

    public static S3CatalogTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3CatalogTarget s3CatalogTarget, ProtocolMarshaller protocolMarshaller) {
        if (s3CatalogTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3CatalogTarget.getName(), NAME_BINDING);
            protocolMarshaller.marshall(s3CatalogTarget.getInputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(s3CatalogTarget.getPartitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall(s3CatalogTarget.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall(s3CatalogTarget.getDatabase(), DATABASE_BINDING);
            protocolMarshaller.marshall(s3CatalogTarget.getSchemaChangePolicy(), SCHEMACHANGEPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

