/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.FilterValue;
import java.util.List;

@SdkInternalApi
public class FilterValueMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<List> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final FilterValueMarshaller instance = new FilterValueMarshaller();

    public static FilterValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(FilterValue filterValue, ProtocolMarshaller protocolMarshaller) {
        if (filterValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(filterValue.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(filterValue.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

