/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.transform.JoinColumnMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JoinColumn
implements Serializable,
Cloneable,
StructuredPojo {
    private String from;
    private List<List<String>> keys;

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public JoinColumn withFrom(String from) {
        this.setFrom(from);
        return this;
    }

    public List<List<String>> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<List<String>> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<List<String>>(keys);
    }

    public JoinColumn withKeys(List<String> ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<List<String>>(keys.length));
        }
        for (List<String> ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public JoinColumn withKeys(Collection<List<String>> keys) {
        this.setKeys(keys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrom() != null) {
            sb.append("From: ").append(this.getFrom()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinColumn)) {
            return false;
        }
        JoinColumn other = (JoinColumn)obj;
        if (other.getFrom() == null ^ this.getFrom() == null) {
            return false;
        }
        if (other.getFrom() != null && !other.getFrom().equals(this.getFrom())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        return other.getKeys() == null || other.getKeys().equals(this.getKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrom() == null ? 0 : this.getFrom().hashCode());
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        return hashCode;
    }

    public JoinColumn clone() {
        try {
            return (JoinColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JoinColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

