/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.AggregateOperation;
import com.simba.athena.amazonaws.services.glue.model.transform.AggregateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Aggregate
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private List<List<String>> groups;
    private List<AggregateOperation> aggs;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Aggregate withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public Aggregate withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public Aggregate withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<List<String>> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<List<String>> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<List<String>>(groups);
    }

    public Aggregate withGroups(List<String> ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<List<String>>(groups.length));
        }
        for (List<String> ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public Aggregate withGroups(Collection<List<String>> groups) {
        this.setGroups(groups);
        return this;
    }

    public List<AggregateOperation> getAggs() {
        return this.aggs;
    }

    public void setAggs(Collection<AggregateOperation> aggs) {
        if (aggs == null) {
            this.aggs = null;
            return;
        }
        this.aggs = new ArrayList<AggregateOperation>(aggs);
    }

    public Aggregate withAggs(AggregateOperation ... aggs) {
        if (this.aggs == null) {
            this.setAggs(new ArrayList<AggregateOperation>(aggs.length));
        }
        for (AggregateOperation ele : aggs) {
            this.aggs.add(ele);
        }
        return this;
    }

    public Aggregate withAggs(Collection<AggregateOperation> aggs) {
        this.setAggs(aggs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getAggs() != null) {
            sb.append("Aggs: ").append(this.getAggs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregate)) {
            return false;
        }
        Aggregate other = (Aggregate)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getAggs() == null ^ this.getAggs() == null) {
            return false;
        }
        return other.getAggs() == null || other.getAggs().equals(this.getAggs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAggs() == null ? 0 : this.getAggs().hashCode());
        return hashCode;
    }

    public Aggregate clone() {
        try {
            return (Aggregate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

