/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.RelopExpression;

class SQLNullIfFunction
extends Expression {
    Expression expression1;
    Expression expression2;

    public SQLNullIfFunction(Expression expression1, Expression expression2) {
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Comparable value2;
        Comparable value1 = (Comparable)this.expression1.eval(env);
        Integer compared = RelopExpression.compare(value1, value2 = (Comparable)this.expression2.eval(env), env);
        Comparable retval = compared != null && compared == 0 ? null : value1;
        return retval;
    }

    public String toString() {
        return "NULLIF(" + this.expression1 + "," + this.expression2 + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression1.usedColumns(availableColumns));
        result.addAll(this.expression2.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression1.aggregateFunctions());
        result.addAll(this.expression2.aggregateFunctions());
        return result;
    }
}

