/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.StringConverter;

class RelopExpression
extends LogicalExpression {
    String op;
    Expression left;
    Expression right;
    boolean isValid;

    public RelopExpression(String op, Expression left, Expression right) {
        this.isValid = !(left instanceof LogicalExpression) && !(right instanceof LogicalExpression);
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public Boolean isTrue(Map<String, Object> env) throws SQLException {
        Comparable rightValue;
        Boolean result = null;
        Comparable leftValue = (Comparable)this.left.eval(env);
        Integer leftComparedToRightObj = RelopExpression.compare(leftValue, rightValue = (Comparable)this.right.eval(env), env);
        if (leftComparedToRightObj != null) {
            int leftComparedToRight = leftComparedToRightObj;
            if (leftValue != null && rightValue != null) {
                if (this.op.equals("=")) {
                    result = leftComparedToRight == 0;
                } else if (this.op.equals("<>") || this.op.equals("!=")) {
                    result = leftComparedToRight != 0;
                } else if (this.op.equals(">")) {
                    result = leftComparedToRight > 0;
                } else if (this.op.equals("<")) {
                    result = leftComparedToRight < 0;
                } else if (this.op.equals("<=") || this.op.equals("=<")) {
                    result = leftComparedToRight <= 0;
                } else if (this.op.equals(">=") || this.op.equals("=>")) {
                    result = leftComparedToRight >= 0;
                }
            }
        }
        return result;
    }

    public static Integer compare(Comparable leftValue, Comparable rightValue, Map<String, Object> env) throws SQLException {
        Integer leftComparedToRightObj = null;
        try {
            if (leftValue != null && rightValue != null) {
                leftComparedToRightObj = new Integer(leftValue.compareTo(rightValue));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            if (leftComparedToRightObj == null && leftValue != null && rightValue != null) {
                if (leftValue instanceof Date) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Date date = sc.parseDate(rightValue.toString());
                    if (date != null) {
                        leftComparedToRightObj = new Integer(leftValue.compareTo(date));
                    }
                } else if (rightValue instanceof Date) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Date date = sc.parseDate(leftValue.toString());
                    if (date != null) {
                        leftComparedToRightObj = new Integer(date.compareTo((Date)rightValue));
                    }
                } else if (leftValue instanceof Time) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Time time = sc.parseTime(rightValue.toString());
                    if (time != null) {
                        leftComparedToRightObj = new Integer(leftValue.compareTo(time));
                    }
                } else if (rightValue instanceof Time) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Time time = sc.parseTime(leftValue.toString());
                    if (time != null) {
                        leftComparedToRightObj = new Integer(time.compareTo((Time)rightValue));
                    }
                } else if (leftValue instanceof Timestamp) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Timestamp timestamp = sc.parseTimestamp(rightValue.toString());
                    if (timestamp != null) {
                        leftComparedToRightObj = new Integer(leftValue.compareTo(timestamp));
                    }
                } else if (rightValue instanceof Timestamp) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Timestamp timestamp = sc.parseTimestamp(leftValue.toString());
                    if (timestamp != null) {
                        leftComparedToRightObj = new Integer(timestamp.compareTo((Timestamp)rightValue));
                    }
                } else if (leftValue instanceof Boolean) {
                    Boolean leftBoolean = (Boolean)leftValue;
                    Boolean rightBoolean = Boolean.valueOf(rightValue.toString());
                    leftComparedToRightObj = leftBoolean.equals(rightBoolean) ? Integer.valueOf(0) : (!leftBoolean.booleanValue() ? Integer.valueOf(-1) : Integer.valueOf(1));
                } else {
                    Double leftDouble = new Double(((Number)((Object)leftValue)).toString());
                    Double rightDouble = new Double(((Number)((Object)rightValue)).toString());
                    leftComparedToRightObj = new Integer(leftDouble.compareTo(rightDouble));
                }
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return leftComparedToRightObj;
    }

    public String toString() {
        return this.op + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.left.usedColumns(availableColumns));
        result.addAll(this.right.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

