/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;

class AndExpression
extends LogicalExpression {
    LogicalExpression left;
    LogicalExpression right;
    boolean isValid;

    public AndExpression(Expression left, Expression right) {
        boolean bl = this.isValid = left instanceof LogicalExpression && right instanceof LogicalExpression;
        if (this.isValid) {
            this.left = (LogicalExpression)left;
            this.right = (LogicalExpression)right;
            this.isValid = left.isValid() && right.isValid();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public Boolean isTrue(Map<String, Object> env) throws SQLException {
        Boolean leftIsTrue = this.left.isTrue(env);
        if (leftIsTrue == null) {
            return null;
        }
        if (leftIsTrue.booleanValue()) {
            Boolean rightIsTrue = this.right.isTrue(env);
            if (rightIsTrue == null) {
                return null;
            }
            if (rightIsTrue.booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "AND " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.left.usedColumns(availableColumns));
        result.addAll(this.right.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }
}

