/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.TextViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ContentInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.ContentValueManager;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class StringValueManager
extends ContentValueManager {
    private static final long PLAIN_STRING_MAX_LENGTH = 32L;

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        DBPDataKind dataKind = controller.getValueType().getDataKind();
        switch (controller.getEditType()) {
            case INLINE: {
                Object value = controller.getValue();
                if (dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.BOOLEAN || dataKind == DBPDataKind.OBJECT) {
                    return new StringInlineEditor(controller);
                }
                if (value instanceof DBDContentCached && ContentUtils.isTextValue((Object)((DBDContentCached)value).getCachedValue())) {
                    return new ContentInlineEditor(controller);
                }
                return null;
            }
            case PANEL: {
                long maxLength = controller.getValueType().getMaxLength();
                if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.BOOLEAN || maxLength > 0L && maxLength < 32L) {
                    return new StringInlineEditor(controller);
                }
                return new ContentPanelEditor(controller);
            }
            case EDITOR: {
                if (controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.string.use.content.editor")) {
                    return ContentEditor.openEditor(controller);
                }
                return new TextViewDialog(controller);
            }
        }
        return null;
    }
}

