/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.MongoDBMessages;
import com.dbeaver.db.mongodb.MongoUIActivator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class MongoDBConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final ImageDescriptor MONGODB_LOGO = MongoUIActivator.getImageDescriptor("icons/mongodb_logo.png");
    private static final ImageDescriptor DOCUMENTDB_LOGO = MongoUIActivator.getImageDescriptor("icons/amazon_documentdb_logo.png");
    private Composite settingsGroup;
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text databaseNameText;
    private Text replicaSetNameText;
    private boolean activated;
    private Button typeManualRadio;
    private Button typeURLRadio;
    private Composite urlGroup;
    private Composite seedsGroup;
    private String driverId;

    public void createControl(Composite composite) {
        this.driverId = this.getSite().getDriver().getId();
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    public Image getImage() {
        DBPDriver driver = this.getSite().getDriver();
        DBPImage logoImage = driver.getLogoImage();
        if (logoImage != null) {
            return DBeaverIcons.getImage((DBPImage)logoImage);
        }
        if (driver.getId().equalsIgnoreCase("documentdb")) {
            return DOCUMENTDB_LOGO.createImage();
        }
        return MONGODB_LOGO.createImage();
    }

    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "documentdb".equals(this.driverId) ? "documentdb_default" : "mongodb_default";
    }

    private Composite createGeneralTab(Composite parent) {
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.site.updateButtons();
            }
        };
        Group addressGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)MongoDBMessages.connection_page_group_address, (int)1, (int)768, (int)-1);
        Composite typeComposite = UIUtils.createComposite((Composite)addressGroup, (int)3);
        UIUtils.createControlLabel((Composite)typeComposite, (String)"Type");
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBConnectionPage.this.showTypeControls((Boolean)e.widget.getData());
            }
        };
        this.typeManualRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"Manual", (Object)false, (SelectionListener)typeSwitcher);
        this.typeURLRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"URL", (Object)true, (SelectionListener)typeSwitcher);
        this.urlGroup = UIUtils.createComposite((Composite)addressGroup, (int)2);
        this.urlGroup.setLayoutData((Object)new GridData(768));
        this.urlText = UIUtils.createLabelText((Composite)this.urlGroup, (String)"URL", (String)"");
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)this.urlGroup, (int)1, (int)1);
        UIUtils.createLabel((Composite)this.urlGroup, (String)"Do not put user name/password in the URL.\nURL must look like mongodb://parameters or mongodb+srv://parameters");
        this.seedsGroup = UIUtils.createComposite((Composite)addressGroup, (int)4);
        this.seedsGroup.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)MongoDBMessages.connection_page_label_host, (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)MongoDBMessages.connection_page_label_port, (String)"");
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)this.portText.getFont()) * 10;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.databaseNameText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)MongoDBMessages.connection_page_label_database, (String)"");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        gd.horizontalSpan = 3;
        this.databaseNameText.setLayoutData((Object)gd);
        this.replicaSetNameText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)MongoDBMessages.connection_page_label_text_replica_set, (String)"");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        gd.horizontalSpan = 3;
        this.replicaSetNameText.setLayoutData((Object)gd);
        this.createAuthPanel(this.settingsGroup, 1);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    private void showTypeControls(boolean showURL) {
        UIUtils.setControlVisible((Control)this.urlGroup, (boolean)showURL);
        UIUtils.setControlVisible((Control)this.seedsGroup, (!showURL ? 1 : 0) != 0);
        this.settingsGroup.layout(true, true);
        this.site.updateButtons();
    }

    public boolean isComplete() {
        if (this.typeManualRadio.getSelection()) {
            return !CommonUtils.isEmptyTrimmed((String)this.hostText.getText()) && !CommonUtils.isEmptyTrimmed((String)this.portText.getText());
        }
        return !CommonUtils.isEmptyTrimmed((String)this.urlText.getText());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String url = connectionInfo.getUrl();
        if (url != null && !MGUtils.isValidURL((String)url)) {
            url = null;
        }
        if (this.urlText != null && !CommonUtils.isEmpty((String)url)) {
            this.urlText.setText(url);
        }
        if (this.hostText != null) {
            String defPort;
            String defHost;
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                defHost = "localhost";
                defPort = this.site.getDriver().getDefaultPort();
            } else {
                defHost = connectionInfo.getHostName();
                defPort = connectionInfo.getHostPort();
            }
            if (CommonUtils.isEmpty((String)defPort)) {
                defPort = String.valueOf(27017);
            }
            this.hostText.setText(defHost);
            this.portText.setText(defPort);
        }
        if (CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.databaseNameText.setText("local");
        } else {
            this.databaseNameText.setText(connectionInfo.getDatabaseName());
        }
        String replicaSet = connectionInfo.getProviderProperty("replicaSet");
        if (replicaSet != null) {
            this.replicaSetNameText.setText(replicaSet);
        }
        super.loadSettings();
        this.activated = true;
        boolean showURL = !CommonUtils.isEmpty((String)url);
        this.typeURLRadio.setSelection(showURL);
        this.typeManualRadio.setSelection(!showURL);
        this.showTypeControls(showURL);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Iterator prop = providerProperties.entrySet().iterator();
        while (prop.hasNext()) {
            String propName = (String)prop.next().getKey();
            if (!propName.startsWith("seed") && !propName.startsWith("@dbeaver-auth@")) continue;
            prop.remove();
        }
        connectionInfo.setHostName(this.hostText.getText().trim());
        connectionInfo.setHostPort(this.portText.getText().trim());
        connectionInfo.setDatabaseName(this.databaseNameText.getText().trim());
        connectionInfo.setProviderProperty("replicaSet", this.replicaSetNameText.getText());
        if (this.typeURLRadio.getSelection()) {
            connectionInfo.setConfigurationType(DBPDriverConfigurationType.URL);
        } else {
            connectionInfo.setConfigurationType(DBPDriverConfigurationType.MANUAL);
        }
        super.saveSettings(dataSource);
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText().trim());
        } else {
            connectionInfo.setUrl("");
        }
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

