/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.query.QueryResult;
import com.dbeaver.db.couchbase3.data.CouchbaseDocument;
import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.exec.CouchbaseQueryStatement;
import com.dbeaver.db.couchbase3.exec.CouchbaseResultSet;
import com.dbeaver.db.couchbase3.exec.CouchbaseSession;
import com.dbeaver.db.couchbase3.model.CouchbaseCollectionIndex;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import com.dbeaver.db.couchbase3.model.CouchbaseScope;
import com.dbeaver.model.document.DBAbstractDocumentContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CouchbaseCollection
extends DBAbstractDocumentContainer<CouchbaseDataSource>
implements DBSEntity,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject,
DBSDataContainer {
    private static final Log log = Log.getLog(CouchbaseCollection.class);
    private static final String CAT_STORAGE = "Storage";
    CollectionSpec collection;
    private boolean persisted = true;
    private final CouchbaseScope parent;
    private final IndexCache indexCache = new IndexCache();
    private Long docCount;

    protected CouchbaseCollection(@NotNull CouchbaseDataSource dataSource, CollectionSpec collection, CouchbaseScope parent) {
        super((DBPDataSource)dataSource);
        this.collection = collection;
        this.parent = parent;
    }

    public void setName(String newName) {
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.indexCache.clearCache();
        this.docCount = null;
        return this;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, order=30, updatable=true, category="Statistics")
    public long getMaxExpiry() {
        return this.collection.maxExpiry().getSeconds();
    }

    @Property(viewable=true, order=31, updatable=true, category="Statistics")
    public String getScopeName() {
        return this.collection.scopeName();
    }

    @Property(viewable=true, order=29, updatable=true, category="Statistics")
    @NotNull
    public String getName() {
        return this.collection.name();
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter"};
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics;
        block17: {
            statistics = new DBCStatistics();
            long startTime = System.currentTimeMillis();
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.beginTask("Read documents from collection", 1);
            monitor.subTask("Open collection '" + this.getName() + "'");
            try {
                monitor.subTask("Select documents");
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM `").append(this.parent.getParentObject().getName()).append("`.`").append(this.parent.getName()).append("`.`").append(this.collection.name()).append("`");
                SQLUtils.appendQueryConditions((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                if (firstRow > 0L) {
                    sql.append(" OFFSET ").append(firstRow);
                }
                if (maxRows > 0L) {
                    sql.append(" LIMIT ").append(maxRows);
                }
                Throwable throwable = null;
                Object var18_16 = null;
                try (CouchbaseQueryStatement statement = new CouchbaseQueryStatement((CouchbaseSession)session, ((CouchbaseExecutionContext)((CouchbaseDataSource)this.dataSource).getDefaultContext()).getCluster(), sql.toString());){
                    statement.setLimit(firstRow, maxRows);
                    boolean hasResults = statement.executeStatement();
                    statistics.addExecuteTime(System.currentTimeMillis() - startTime);
                    if (!hasResults) break block17;
                    DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                    CouchbaseResultSet resultSetN1 = statement.openResultSet();
                    try {
                        dataReceiver.fetchStart(session, (DBCResultSet)resultSetN1, firstRow, maxRows);
                        while (resultSetN1.nextRow() && !monitor.isCanceled()) {
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSetN1);
                            fetchProgress.monitorRowFetch();
                        }
                        fetchProgress.dumpStatistics(statistics);
                    }
                    finally {
                        dataReceiver.fetchEnd(session, (DBCResultSet)resultSetN1);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        block27: {
            if (this.docCount != null) {
                return this.docCount;
            }
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.beginTask("Read documents from collection", 1);
            monitor.subTask("Open collection '" + this.getName() + "'");
            try {
                monitor.subTask("Select documents");
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT COUNT(*) FROM `").append(this.parent.getParentObject().getName()).append('.').append(this.parent.getName()).append('.').append(this.getName()).append("`");
                SQLUtils.appendQueryConditions((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                Throwable throwable = null;
                Object var9_9 = null;
                try (CouchbaseQueryStatement statement = new CouchbaseQueryStatement((CouchbaseSession)session, ((CouchbaseExecutionContext)((CouchbaseDataSource)this.dataSource).getDefaultContext()).getCluster(), sql.toString());){
                    boolean hasResults = statement.executeStatement();
                    if (!hasResults) break block27;
                    new DBFetchProgress(session.getProgressMonitor());
                    Throwable throwable2 = null;
                    Object var13_15 = null;
                    try (CouchbaseResultSet resultSetN1 = statement.openResultSet();){
                        if (resultSetN1.nextRow()) {
                            Object countValue = resultSetN1.getAttributeValue(0);
                            if (countValue instanceof CouchbaseDocument) {
                                countValue = ((CouchbaseDocument)((Object)countValue)).getAttributeValue("$1");
                            }
                            if (countValue instanceof Number) {
                                this.docCount = ((Number)countValue).longValue();
                            } else {
                                log.debug((Object)("Unsupported count value: " + countValue));
                                this.docCount = -1L;
                            }
                        } else {
                            log.debug((Object)"Can't retrieve document count");
                            this.docCount = -1L;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.docCount;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.parent;
    }

    @Association
    @NotNull
    public Collection<? extends DBSTableConstraint> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    public class IndexCache
    extends BasicObjectCache<CouchbaseCollection, CouchbaseCollectionIndex> {
        @NotNull
        public List<CouchbaseCollectionIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseCollection bucket) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseCollectionIndex> result = new ArrayList<CouchbaseCollectionIndex>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (CouchbaseSession ignored = ((CouchbaseExecutionContext)((CouchbaseDataSource)CouchbaseCollection.this.getDataSource()).getDefaultContext()).openSession(monitor, DBCExecutionPurpose.META, "Read collection indexes");){
                        QueryResult query = ((CouchbaseExecutionContext)((CouchbaseDataSource)CouchbaseCollection.this.dataSource).getDefaultContext()).getCluster().query("SELECT * FROM system:indexes where keyspace_id='" + CouchbaseCollection.this.getName() + "'");
                        for (JsonObject jsonObject : query.rowsAsObject()) {
                            CouchbaseCollectionIndex index = new CouchbaseCollectionIndex(CouchbaseCollection.this, jsonObject.getObject("indexes"));
                            result.add(index);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting buckets", (Throwable)ex);
                }
                result.sort(DBUtils.nameComparator());
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

