/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.v3.replication;

import com.edb.copy.CopyDual;
import com.edb.core.PGStream;
import com.edb.core.QueryExecutor;
import com.edb.core.ReplicationProtocol;
import com.edb.core.v3.replication.V3PGReplicationStream;
import com.edb.replication.PGReplicationStream;
import com.edb.replication.ReplicationType;
import com.edb.replication.fluent.CommonOptions;
import com.edb.replication.fluent.logical.LogicalReplicationOptions;
import com.edb.replication.fluent.physical.PhysicalReplicationOptions;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import com.edb.util.internal.Nullness;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private static final Logger LOGGER = Logger.getLogger(V3ReplicationProtocol.class.getName());
    private final QueryExecutor queryExecutor;
    private final PGStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, PGStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pgStream;
    }

    @Override
    public PGReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public PGReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL);
    }

    private PGReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType) throws SQLException {
        LOGGER.log(Level.FINEST, " FE=> StartReplication(query: {0})", query);
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3PGReplicationStream(Nullness.castNonNull(copyDual), options.getStartLSNPosition(), options.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws PSQLException {
        if (options.getStatusInterval() == 0) {
            return;
        }
        try {
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            int minimalTimeOut = previousTimeOut > 0 ? Math.min(previousTimeOut, options.getStatusInterval()) : options.getStatusInterval();
            this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

