/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchStatus {
    private final long errorCount;
    private final long successCount;
    private final Map<String, String> errors;

    @JsonCreator
    private SearchStatus(@JsonProperty(value="failed") long errorCount, @JsonProperty(value="successful") long successCount, @JsonProperty(value="errors") Map<String, String> errors) {
        this.errorCount = errorCount;
        this.successCount = successCount;
        this.errors = errors;
    }

    public long successCount() {
        return this.successCount;
    }

    public long errorCount() {
        return this.errorCount;
    }

    public Map<String, String> errors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchStatus that = (SearchStatus)o;
        return this.errorCount == that.errorCount && this.successCount == that.successCount && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.errorCount, this.successCount, this.errors);
    }

    public String toString() {
        return "SearchStatus{errorCount=" + this.errorCount + ", successCount=" + this.successCount + ", errors=" + this.errors + '}';
    }
}

