/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.ReactiveQueryIndexManager;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class QueryIndexManager {
    private final AsyncQueryIndexManager async;
    private final ReactiveQueryIndexManager reactive;

    @Stability.Internal
    public QueryIndexManager(AsyncQueryIndexManager async) {
        this.async = Objects.requireNonNull(async);
        this.reactive = new ReactiveQueryIndexManager(async);
    }

    public AsyncQueryIndexManager async() {
        return this.async;
    }

    public ReactiveQueryIndexManager reactive() {
        return this.reactive;
    }

    public void createPrimaryIndex(String bucketName) {
        AsyncUtils.block(this.async.createPrimaryIndex(bucketName));
    }

    public void createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        AsyncUtils.block(this.async.createPrimaryIndex(bucketName, options));
    }

    public void createIndex(String bucketName, String indexName, Collection<String> fields) {
        AsyncUtils.block(this.async.createIndex(bucketName, indexName, fields));
    }

    public void createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        AsyncUtils.block(this.async.createIndex(bucketName, indexName, fields, options));
    }

    public List<QueryIndex> getAllIndexes(String bucketName) {
        return AsyncUtils.block(this.async.getAllIndexes(bucketName));
    }

    public List<QueryIndex> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        return AsyncUtils.block(this.async.getAllIndexes(bucketName, options));
    }

    public void dropPrimaryIndex(String bucketName) {
        AsyncUtils.block(this.async.dropPrimaryIndex(bucketName));
    }

    public void dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        AsyncUtils.block(this.async.dropPrimaryIndex(bucketName, options));
    }

    public void dropIndex(String bucketName, String indexName) {
        AsyncUtils.block(this.async.dropIndex(bucketName, indexName));
    }

    public void dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        AsyncUtils.block(this.async.dropIndex(bucketName, indexName, options));
    }

    public void buildDeferredIndexes(String bucketName) {
        AsyncUtils.block(this.async.buildDeferredIndexes(bucketName));
    }

    public void buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        AsyncUtils.block(this.async.buildDeferredIndexes(bucketName, options));
    }

    public void watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        AsyncUtils.block(this.async.watchIndexes(bucketName, indexNames, timeout));
    }

    public void watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        AsyncUtils.block(this.async.watchIndexes(bucketName, indexNames, timeout, options));
    }
}

