/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.Optional;

public class GetAllQueryIndexesOptions
extends CommonOptions<GetAllQueryIndexesOptions> {
    private String scopeName;
    private String collectionName;

    private GetAllQueryIndexesOptions() {
    }

    public static GetAllQueryIndexesOptions getAllQueryIndexesOptions() {
        return new GetAllQueryIndexesOptions();
    }

    public GetAllQueryIndexesOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    public GetAllQueryIndexesOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(GetAllQueryIndexesOptions.this);
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(GetAllQueryIndexesOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(GetAllQueryIndexesOptions.this.collectionName);
        }
    }
}

