/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.manager.collection.AsyncCollectionManager;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveCollectionManager {
    private final AsyncCollectionManager async;

    @Stability.Internal
    public ReactiveCollectionManager(AsyncCollectionManager async) {
        this.async = async;
    }

    public Mono<Void> createCollection(CollectionSpec collectionSpec) {
        return this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    public Mono<Void> createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        return Reactor.toMono(() -> this.async.createCollection(collectionSpec, options));
    }

    public Mono<Void> createScope(String scopeName) {
        return this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public Mono<Void> createScope(String scopeName, CreateScopeOptions options) {
        return Reactor.toMono(() -> this.async.createScope(scopeName, options));
    }

    public Mono<Void> dropCollection(CollectionSpec collectionSpec) {
        return this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    public Mono<Void> dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        return Reactor.toMono(() -> this.async.dropCollection(collectionSpec, options));
    }

    public Mono<Void> dropScope(String scopeName) {
        return this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public Mono<Void> dropScope(String scopeName, DropScopeOptions options) {
        return Reactor.toMono(() -> this.async.dropScope(scopeName, options));
    }

    @Deprecated
    public Mono<ScopeSpec> getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    @Deprecated
    public Mono<ScopeSpec> getScope(String scopeName, GetScopeOptions options) {
        return Reactor.toMono(() -> this.async.getScope(scopeName, options));
    }

    public Flux<ScopeSpec> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public Flux<ScopeSpec> getAllScopes(GetAllScopesOptions options) {
        return Reactor.toMono(() -> this.async.getAllScopes(options)).flatMapMany(Flux::fromIterable);
    }
}

