/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class GetResult {
    protected final byte[] content;
    protected final int flags;
    private final long cas;
    private final Optional<Instant> expiry;
    protected final Transcoder transcoder;

    GetResult(byte[] content, int flags, long cas, Optional<Instant> expiry, Transcoder transcoder) {
        this.cas = cas;
        this.content = content;
        this.flags = flags;
        this.expiry = expiry;
        this.transcoder = transcoder;
    }

    public long cas() {
        return this.cas;
    }

    @Deprecated
    public Optional<Duration> expiry() {
        return this.expiry.map(instant -> Duration.ofSeconds(instant.getEpochSecond()));
    }

    public Optional<Instant> expiryTime() {
        return this.expiry;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public JsonArray contentAsArray() {
        return this.contentAs(JsonArray.class);
    }

    public <T> T contentAs(Class<T> target) {
        return this.transcoder.decode(target, this.content, this.flags);
    }

    public <T> T contentAs(TypeRef<T> target) {
        return this.transcoder.decode(target, this.content, this.flags);
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes() {
        return this.content;
    }

    public String toString() {
        return "GetResult{content=" + RedactableArgument.redactUser((Object)GetResult.convertContentToString(this.content, this.flags)) + ", flags=0x" + Integer.toHexString(this.flags) + ", cas=0x" + Long.toHexString(this.cas) + ", expiry=" + this.expiry + '}';
    }

    static String convertContentToString(byte[] content, int flags) {
        boolean printable;
        if (content.length == 0) {
            return "";
        }
        boolean bl = printable = CodecFlags.hasCommonFormat((int)flags, (int)CodecFlags.JSON_COMMON_FLAGS) || CodecFlags.hasCommonFormat((int)flags, (int)CodecFlags.STRING_COMMON_FLAGS) || flags == 0 && content[0] == 123;
        if (printable) {
            return new String(content, StandardCharsets.UTF_8);
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])content);
        String result = ByteBufUtil.prettyHexDump((ByteBuf)buf);
        buf.release();
        return "\n" + result + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        return this.flags == getResult.flags && this.cas == getResult.cas && Arrays.equals(this.content, getResult.content) && Objects.equals(this.expiry, getResult.expiry) && Objects.equals(this.transcoder, getResult.transcoder);
    }

    public int hashCode() {
        int result = Objects.hash(this.flags, this.cas, this.expiry, this.transcoder);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

