/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.openai;

import java.util.Arrays;
import java.util.Optional;
import org.jkiss.code.NotNull;

public enum GPTModel {
    GPT_TURBO("gpt-3.5-turbo", 4096, true),
    GPT_TURBO16("gpt-3.5-turbo-16k", 16384, true),
    TEXT_ADA("text-ada-001", 2048, false),
    TEXT_CURIE("text-curie-001", 2048, false),
    TEXT_BABBAGE("text-babbage-001", 2048, false),
    TEXT_DAVINCI01("text-davinci-003", 4096, false),
    TEXT_DAVINCI02("text-davinci-002", 4096, false),
    TEXT_DAVINCI03("text-davinci-001", 2048, false);

    private final String name;
    private final int maxTokens;
    private final boolean isChatAPI;

    @NotNull
    public static GPTModel getByName(@NotNull String name) {
        Optional<GPTModel> model = Arrays.stream(GPTModel.values()).filter(it -> it.name.equals(name)).findFirst();
        return model.orElse(GPT_TURBO16);
    }

    private GPTModel(String name, int maxTokens, boolean isChatAPI) {
        this.name = name;
        this.maxTokens = maxTokens;
        this.isChatAPI = isChatAPI;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public boolean isChatAPI() {
        return this.isChatAPI;
    }

    public String getName() {
        return this.name;
    }
}

