/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.completion;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class DAICompletionContext {
    private final DAICompletionScope scope;
    private final List<DBSEntity> customEntities;
    private final DBSLogicalDataSource dataSource;
    private final DBCExecutionContext executionContext;

    private DAICompletionContext(@NotNull DAICompletionScope scope, @Nullable List<DBSEntity> customEntities, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext) {
        this.scope = scope;
        this.customEntities = customEntities;
        this.dataSource = dataSource;
        this.executionContext = executionContext;
    }

    @NotNull
    public DAICompletionScope getScope() {
        return this.scope;
    }

    @NotNull
    public List<DBSEntity> getCustomEntities() {
        return Collections.unmodifiableList(Objects.requireNonNull(this.customEntities, "Scope is not custom"));
    }

    @NotNull
    public DBSLogicalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public static class Builder {
        private DAICompletionScope scope;
        private List<DBSEntity> customEntities;
        private DBSLogicalDataSource dataSource;
        private DBCExecutionContext executionContext;

        @NotNull
        public Builder setScope(@NotNull DAICompletionScope scope) {
            this.scope = scope;
            return this;
        }

        @NotNull
        public Builder setCustomEntities(@NotNull List<DBSEntity> customEntities) {
            this.customEntities = customEntities;
            return this;
        }

        @NotNull
        public Builder setDataSource(@NotNull DBSLogicalDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @NotNull
        public Builder setExecutionContext(@NotNull DBCExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @NotNull
        public DAICompletionContext build() {
            Assert.isLegal((this.scope != null ? 1 : 0) != 0, (String)"Scope must be specified");
            Assert.isLegal((this.scope != DAICompletionScope.CUSTOM || this.customEntities != null ? 1 : 0) != 0, (String)"Custom entities must be specified when using custom scope");
            Assert.isLegal((this.dataSource != null ? 1 : 0) != 0, (String)"Data source must be specified");
            Assert.isLegal((this.executionContext != null ? 1 : 0) != 0, (String)"Execution context must be specified");
            return new DAICompletionContext(this.scope, this.customEntities, this.dataSource, this.executionContext);
        }
    }
}

