/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.completion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionResponse;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSession;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.ai.openai.GPTModel;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractAICompletionEngine<SERVICE, REQUEST>
implements DAICompletionEngine<SERVICE> {
    @Override
    @NotNull
    public List<DAICompletionResponse> performQueryCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull DAICompletionMessage message, @NotNull IAIFormatter formatter) throws DBException {
        String result = this.requestCompletion(monitor, context, List.of(message), formatter);
        DAICompletionResponse response = this.createCompletionResponse(context, result);
        return Collections.singletonList(response);
    }

    @Override
    @NotNull
    public List<DAICompletionResponse> performQueryCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull DAICompletionSession session, @NotNull IAIFormatter formatter) throws DBException {
        String result = this.requestCompletion(monitor, context, session.getMessages(), formatter);
        DAICompletionResponse response = new DAICompletionResponse();
        response.setResultCompletion(result);
        return List.of(response);
    }

    @Override
    public abstract Map<String, SERVICE> getServiceMap();

    protected abstract int getMaxTokens();

    @Nullable
    protected abstract String requestCompletion(@NotNull DBRProgressMonitor var1, @NotNull DAICompletionContext var2, @NotNull List<DAICompletionMessage> var3, @NotNull IAIFormatter var4) throws DBException;

    @NotNull
    protected DAICompletionResponse createCompletionResponse(@NotNull DAICompletionContext context, @NotNull String result) {
        DAICompletionResponse response = new DAICompletionResponse();
        response.setResultCompletion(result);
        return response;
    }

    @Nullable
    protected abstract String callCompletion(@NotNull DBRProgressMonitor var1, @NotNull List<DAICompletionMessage> var2, @NotNull SERVICE var3, @NotNull REQUEST var4) throws DBException;

    @NotNull
    protected DBSObjectContainer getScopeObject(@NotNull DAICompletionContext context, @NotNull DBCExecutionContext executionContext) {
        DAICompletionScope scope = context.getScope();
        DBSObjectContainer mainObject = null;
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults != null) {
            switch (scope) {
                case CURRENT_SCHEMA: {
                    if (contextDefaults.getDefaultSchema() != null) {
                        mainObject = contextDefaults.getDefaultSchema();
                        break;
                    }
                    mainObject = contextDefaults.getDefaultCatalog();
                    break;
                }
                case CURRENT_DATABASE: {
                    mainObject = contextDefaults.getDefaultCatalog();
                    break;
                }
            }
        }
        if (mainObject == null) {
            mainObject = (DBSObjectContainer)executionContext.getDataSource();
        }
        return mainObject;
    }

    protected abstract REQUEST createCompletionRequest(@NotNull List<DAICompletionMessage> var1);

    protected abstract REQUEST createCompletionRequest(@NotNull List<DAICompletionMessage> var1, int var2);

    protected abstract SERVICE getServiceInstance(@NotNull DBCExecutionContext var1) throws DBException;

    protected abstract AIEngineSettings getSettings();

    @Nullable
    protected String processCompletion(@NotNull List<DAICompletionMessage> messages, @NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer mainObject, @Nullable String completionText, @NotNull IAIFormatter formatter, @NotNull GPTModel model) {
        if (CommonUtils.isEmpty((String)completionText)) {
            return null;
        }
        completionText = model.isChatAPI() ? String.valueOf(completionText.trim()) + ";" : "SELECT " + completionText.trim() + ";";
        return formatter.postProcessGeneratedQuery(monitor, mainObject, executionContext, completionText).trim();
    }
}

