/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AISettings {
    private static final Log log = Log.getLog(AISettings.class);
    private static final Gson gson = new Gson();
    public static final String AI_CONFIGURATION_JSON = "ai-configuration.json";
    private boolean aiDisabled;
    private String activeEngine;
    private final Map<String, AIEngineSettings> engineConfigurations = new LinkedHashMap<String, AIEngineSettings>();
    private final Set<String> disabledConnections = new LinkedHashSet<String>();
    private final Set<String> enabledConnections = new LinkedHashSet<String>();

    private AISettings() {
    }

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    @Property
    public String getActiveEngine() {
        return this.activeEngine;
    }

    public void setActiveEngine(String activeEngine) {
        this.activeEngine = activeEngine;
    }

    @NotNull
    public Set<String> getDisabledConnections() {
        return this.disabledConnections;
    }

    @NotNull
    public Set<String> getEnabledConnections() {
        return this.enabledConnections;
    }

    @NotNull
    public Map<String, AIEngineSettings> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    @NotNull
    public AIEngineSettings getEngineConfiguration(String engine) {
        AIEngineSettings settings = this.engineConfigurations.get(engine);
        if (settings == null) {
            settings = new AIEngineSettings();
            settings.setEngineEnabled(!this.aiDisabled);
            this.engineConfigurations.put(engine, settings);
        }
        this.tryMigrateFromPrefStore(engine, settings);
        return settings;
    }

    private void tryMigrateFromPrefStore(String engine, AIEngineSettings settings) {
        if ("openai".equals(engine) && settings.getProperties().get("gpt.model") == null) {
            DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String model = preferenceStore.getString("gpt.model");
            if (model != null) {
                settings.getProperties().put("gpt.model", model);
            }
            Double temperature = preferenceStore.getDouble("gpt.model.temperature");
            settings.getProperties().put("gpt.model.temperature", temperature);
            Boolean logQuery = preferenceStore.getBoolean("gpt.log.query");
            settings.getProperties().put("gpt.log.query", logQuery);
        }
    }

    @NotNull
    public static AISettings getSettings() {
        AISettings settings = null;
        SMSession session = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (session instanceof SMSessionPersistent) {
            settings = (AISettings)((SMSessionPersistent)session).getAttribute(AISettings.class.getName());
        }
        if (settings == null) {
            WorkspaceConfigEventManager.addConfigChangedListener((String)AI_CONFIGURATION_JSON, o -> AISettings.loadConfigurationFile());
            settings = AISettings.loadConfigurationFile();
        }
        if (settings.getActiveEngine() == null) {
            settings.setActiveEngine("openai");
        }
        if (DBWorkbench.getPlatform().getPreferenceStore().getString("ai.completion.disabled") != null) {
            settings.setAiDisabled(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.disabled"));
        }
        return settings;
    }

    private static AISettings loadConfigurationFile() {
        try {
            String content = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(AI_CONFIGURATION_JSON);
            AISettings settings = CommonUtils.isEmpty((String)content) ? new AISettings() : (AISettings)gson.fromJson((Reader)new StringReader(content), AISettings.class);
            SMSession session = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
            if (session instanceof SMSessionPersistent) {
                ((SMSessionPersistent)session).setAttribute(AISettings.class.getName(), (Object)settings);
            }
            return settings;
        }
        catch (Exception e) {
            log.error((Object)e);
            return new AISettings();
        }
    }

    public void saveSettings() {
        try {
            String content = gson.toJson((Object)this, AISettings.class);
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(AI_CONFIGURATION_JSON, content);
            DBWorkbench.getPlatform().getPreferenceStore().setValue("ai.completion.disabled", this.aiDisabled);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

