/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIFormatterRegistry {
    private static AIFormatterRegistry instance = null;
    private final Map<String, FormatterDescriptor> descriptorMap = new LinkedHashMap<String, FormatterDescriptor>();
    private final Map<String, String> replaceMap = new LinkedHashMap<String, String>();

    public static synchronized AIFormatterRegistry getInstance() {
        if (instance == null) {
            instance = new AIFormatterRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIFormatterRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.formatter");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("formatter".equals(ext.getName())) {
                FormatterDescriptor descriptor = new FormatterDescriptor(ext);
                this.descriptorMap.put(descriptor.getId(), descriptor);
                String replaces = descriptor.getReplaces();
                if (!CommonUtils.isEmpty((String)replaces)) {
                    String[] stringArray = replaces.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String rl = stringArray[n4];
                        this.replaceMap.put(rl, descriptor.getId());
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public IAIFormatter getFormatter(String id) throws DBException {
        String replace;
        while ((replace = this.replaceMap.get(id)) != null) {
            id = replace;
        }
        FormatterDescriptor descriptor = this.descriptorMap.get(id);
        if (descriptor == null) {
            throw new DBException("AI formatter '" + id + "' not found");
        }
        return descriptor.createInstance();
    }

    public static class FormatterDescriptor
    extends AbstractDescriptor {
        private final IConfigurationElement contributorConfig;

        protected FormatterDescriptor(IConfigurationElement contributorConfig) {
            super(contributorConfig);
            this.contributorConfig = contributorConfig;
        }

        public String getId() {
            return this.contributorConfig.getAttribute("id");
        }

        String getReplaces() {
            return this.contributorConfig.getAttribute("replaces");
        }

        public IAIFormatter createInstance() throws DBException {
            AbstractDescriptor.ObjectType objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, this.contributorConfig, "class");
            return (IAIFormatter)objectType.createInstance(IAIFormatter.class);
        }
    }
}

