/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AIEngineRegistry {
    private static final Log log = Log.getLog(AIEngineRegistry.class);
    private static AIEngineRegistry instance = null;
    private final Map<String, EngineDescriptor> descriptorMap = new LinkedHashMap<String, EngineDescriptor>();
    private final Map<String, String> replaceMap = new LinkedHashMap<String, String>();

    public static synchronized AIEngineRegistry getInstance() {
        if (instance == null) {
            instance = new AIEngineRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIEngineRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.engine");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("completionEngine".equals(ext.getName())) {
                EngineDescriptor descriptor = new EngineDescriptor(ext);
                this.descriptorMap.put(descriptor.getId(), descriptor);
                String replaces = descriptor.getReplaces();
                if (!CommonUtils.isEmpty((String)replaces)) {
                    String[] stringArray = replaces.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String rl = stringArray[n4];
                        this.replaceMap.put(rl, descriptor.getId());
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public List<EngineDescriptor> getCompletionEngines() {
        ArrayList<EngineDescriptor> list = new ArrayList<EngineDescriptor>();
        for (Map.Entry<String, EngineDescriptor> entry : this.descriptorMap.entrySet()) {
            if (this.replaceMap.containsKey(entry.getKey())) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public DAICompletionEngine<?> getCompletionEngine(String id) throws DBException {
        EngineDescriptor descriptor = this.getEngineDescriptor(id);
        if (descriptor == null) {
            throw new DBException("AI engine '" + id + "' not found");
        }
        return descriptor.createInstance();
    }

    public EngineDescriptor getEngineDescriptor(String id) {
        String replace;
        while ((replace = this.replaceMap.get(id)) != null) {
            id = replace;
        }
        return this.descriptorMap.get(id);
    }

    public static class EngineDescriptor
    extends AbstractDescriptor {
        private final IConfigurationElement contributorConfig;
        private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();

        protected EngineDescriptor(IConfigurationElement contributorConfig) {
            super(contributorConfig);
            this.contributorConfig = contributorConfig;
            for (IConfigurationElement propGroup : ArrayUtils.safeArray((Object[])contributorConfig.getChildren("propertyGroup"))) {
                this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)propGroup));
            }
        }

        public String getId() {
            return this.contributorConfig.getAttribute("id");
        }

        public String getLabel() {
            return this.contributorConfig.getAttribute("label");
        }

        String getReplaces() {
            return this.contributorConfig.getAttribute("replaces");
        }

        public List<DBPPropertyDescriptor> getProperties() {
            return this.properties;
        }

        public DAICompletionEngine<?> createInstance() throws DBException {
            AbstractDescriptor.ObjectType objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, this.contributorConfig, "class");
            return (DAICompletionEngine)objectType.createInstance(DAICompletionEngine.class);
        }
    }
}

