/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBPVirtualObject;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeFilter;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.data.DBDVoid;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProviderExt;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformerExt;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeDynamic;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSObjectWithType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public final class DBUtils {
    private static final Log log = Log.getLog(DBUtils.class);
    private static final int MAX_SAMPLE_ROWS = 1000;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPNamedObject object) {
        void dbo;
        void var2_1;
        DBSObject dBSObject;
        if (object instanceof DBSContextBoundAttribute) {
            return ((DBSContextBoundAttribute)object).formatMemberReference(false, null, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        DBPNamedObject dBPNamedObject = object;
        return dBPNamedObject instanceof DBSObject && (dBSObject = (DBSObject)dBPNamedObject) == (DBSObject)var2_1 ? DBUtils.getQuotedIdentifier(dbo.getDataSource(), object.getName()) : object.getName();
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBSObject object) {
        if (object instanceof DBSContextBoundAttribute) {
            return ((DBSContextBoundAttribute)object).formatMemberReference(false, null, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        return DBUtils.getQuotedIdentifier(object.getDataSource(), object.getName());
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBSObject object, @NotNull DBPAttributeReferencePurpose purpose) {
        if (object instanceof DBSContextBoundAttribute) {
            return ((DBSContextBoundAttribute)object).formatMemberReference(false, null, purpose);
        }
        return DBUtils.getQuotedIdentifier(object.getDataSource(), object.getName());
    }

    public static boolean isQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return dataSource.getSQLDialect().isQuotedIdentifier(str);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return dataSource.getSQLDialect().getUnquotedIdentifier(str);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, String[][] quoteStrings) {
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            quoteStrings = BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
        }
        int i = 0;
        while (i < quoteStrings.length) {
            str = DBUtils.getUnQuotedIdentifier(str, quoteStrings[i][0], quoteStrings[i][1]);
            ++i;
        }
        return str;
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote) {
        return DBUtils.getUnQuotedIdentifier(str, quote, quote);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote1, @NotNull String quote2) {
        if (quote1 != null && quote2 != null && str.length() >= quote1.length() + quote2.length() && str.startsWith(quote1) && str.endsWith(quote2)) {
            return str.substring(quote1.length(), str.length() - quote2.length());
        }
        return str;
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return DBUtils.getQuotedIdentifier(dataSource, str, true, false);
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str, boolean caseSensitiveNames, boolean quoteAlways) {
        return dataSource.getSQLDialect().getQuotedIdentifier(str, caseSensitiveNames, quoteAlways);
    }

    @NotNull
    public static String getFullQualifiedName(@Nullable DBPDataSource dataSource, DBPNamedObject ... path) {
        StringBuilder name = new StringBuilder(20 * path.length);
        if (dataSource == null) {
            DBPNamedObject[] dBPNamedObjectArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                DBPNamedObject namePart = dBPNamedObjectArray[n2];
                if (!DBUtils.isVirtualObject(namePart)) {
                    if (name.length() > 0) {
                        name.append('.');
                    }
                    name.append(namePart.getName());
                }
                ++n2;
            }
        } else {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            DBPNamedObject parent = null;
            DBPNamedObject[] dBPNamedObjectArray = path;
            int n = path.length;
            int n3 = 0;
            while (n3 < n) {
                DBPNamedObject namePart = dBPNamedObjectArray[n3];
                if (!(namePart == null || DBUtils.isVirtualObject(namePart) || namePart instanceof DBSCatalog && (sqlDialect.getCatalogUsage() & 1) == 0 || namePart instanceof DBSSchema && (sqlDialect.getSchemaUsage() & 1) == 0 || !DBUtils.isValidObjectName(namePart.getName()))) {
                    if (name.length() > 0) {
                        if (parent instanceof DBSCatalog) {
                            if (!sqlDialect.isCatalogAtStart()) {
                                log.warn("Catalog name should be at the start of full-qualified name!");
                            }
                            name.append(sqlDialect.getCatalogSeparator());
                        } else {
                            name.append(sqlDialect.getStructSeparator());
                        }
                    }
                    name.append(DBUtils.getQuotedIdentifier(dataSource, namePart.getName()));
                    parent = namePart;
                }
                ++n3;
            }
        }
        return name.toString();
    }

    @NotNull
    public static String getSimpleQualifiedName(Object ... names) {
        StringBuilder name = new StringBuilder(names.length * 16);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object namePart = objectArray[n2];
            if (namePart != null) {
                if (name.length() > 0 && name.charAt(name.length() - 1) != '.') {
                    name.append('.');
                }
                name.append(namePart);
            }
            ++n2;
        }
        return name.toString();
    }

    @NotNull
    public static String getFullyQualifiedName(@NotNull DBPDataSource dataSource, String ... names) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        StringBuilder name = new StringBuilder(names.length * 16);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String namePart = stringArray[n2];
            if (namePart != null) {
                if (name.length() > 0) {
                    name.append(dialect.getStructSeparator());
                }
                name.append(DBUtils.getQuotedIdentifier(dataSource, namePart));
            }
            ++n2;
        }
        return name.toString();
    }

    public static boolean isValidObjectName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (!Character.isWhitespace(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DBSObject getObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer rootSC, @Nullable String catalogName, @Nullable String schemaName, @Nullable String objectName) throws DBException {
        DBSObjectContainer catalog;
        DBSObject dBSObject;
        Class<? extends DBSObject> childType;
        if (!CommonUtils.isEmpty((String)catalogName) && (DBSSchema.class.isAssignableFrom(childType = rootSC.getPrimaryChildType(monitor)) || DBSEntity.class.isAssignableFrom(childType))) {
            catalogName = null;
        }
        if (!CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty((String)schemaName)) {
            DBSObject catalog2 = rootSC.getChild(monitor, catalogName);
            if (!(catalog2 instanceof DBSObjectContainer)) {
                return null;
            }
            rootSC = (DBSObjectContainer)catalog2;
            DBSObject schema = rootSC.getChild(monitor, schemaName);
            if (!(schema instanceof DBSObjectContainer)) {
                return null;
            }
            rootSC = (DBSObjectContainer)schema;
        } else if (!CommonUtils.isEmpty((String)catalogName) || !CommonUtils.isEmpty((String)schemaName)) {
            DBSObject child;
            Class<? extends DBSObject> childType2;
            DBSObject selectedObject;
            String containerName = !CommonUtils.isEmpty((String)catalogName) ? catalogName : schemaName;
            DBSObject sc = rootSC.getChild(monitor, containerName);
            if (!(sc instanceof DBSObjectContainer)) {
                selectedObject = DBUtils.getSelectedObject(executionContext);
                if (selectedObject instanceof DBSObjectContainer) {
                    if (selectedObject instanceof DBSSchema && selectedObject.getParentObject() instanceof DBSCatalog && CommonUtils.isEmpty((String)catalogName) && !CommonUtils.equalObjects((Object)schemaName, (Object)selectedObject.getName())) {
                        selectedObject = selectedObject.getParentObject();
                    }
                    sc = selectedObject instanceof DBSSchema && CommonUtils.equalObjects((Object)schemaName, (Object)selectedObject.getName()) || selectedObject instanceof DBSCatalog && CommonUtils.equalObjects((Object)catalogName, (Object)selectedObject.getName()) ? selectedObject : ((DBSObjectContainer)selectedObject).getChild(monitor, containerName);
                }
                if (!(sc instanceof DBSObjectContainer)) {
                    return null;
                }
            } else if (CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty((String)schemaName) && (dBSObject = sc) instanceof DBSCatalog && (selectedObject = (DBSCatalog)dBSObject) == (DBSCatalog)dBSObject && DBSSchema.class.isAssignableFrom(childType2 = catalog.getPrimaryChildType(monitor)) && (child = ((DBSCatalog)sc).getChild(monitor, schemaName)) instanceof DBSSchema) {
                sc = child;
            }
            rootSC = (DBSObjectContainer)sc;
        }
        if (objectName == null) {
            return rootSC;
        }
        DBSObject object = rootSC.getChild(monitor, objectName);
        if (object instanceof DBSEntity) {
            return object;
        }
        DBSObject selectedObject = DBUtils.getSelectedObject(executionContext);
        dBSObject = selectedObject;
        if (dBSObject instanceof DBSObjectContainer && (catalog = (DBSObjectContainer)dBSObject) == (DBSObjectContainer)dBSObject) {
            void oc;
            return oc.getChild(monitor, objectName);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DBSObject findNestedObject(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer parent, @NotNull List<String> names) throws DBException {
        int i = 0;
        while (i < names.size()) {
            void oc;
            Object contextDefaults;
            String childName = names.get(i);
            DBSObject child = parent.getChild(monitor, childName);
            if (child == null && i == 0 && (contextDefaults = executionContext.getContextDefaults()) != null) {
                Object container = contextDefaults.getDefaultSchema();
                if (container != null) {
                    child = container.getChild(monitor, childName);
                }
                if (child == null && (container = contextDefaults.getDefaultCatalog()) != null) {
                    child = container.getChild(monitor, childName);
                }
            }
            if (child == null) break;
            if (i == names.size() - 1) {
                return child;
            }
            DBSObject dBSObject = child;
            if (!(dBSObject instanceof DBSObjectContainer) || (contextDefaults = (DBSObjectContainer)dBSObject) != (DBSObjectContainer)dBSObject) break;
            parent = oc;
            ++i;
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName) {
        return DBUtils.findObject(theList, objectName, false);
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName, boolean caseInsensitive) {
        if (theList != null && !theList.isEmpty()) {
            for (DBPNamedObject object : theList) {
                if (!(caseInsensitive ? object.getName().equalsIgnoreCase(objectName) : object.getName().equals(objectName))) continue;
                return (T)object;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable T[] theList, String objectName) {
        if (theList != null && theList.length > 0) {
            T[] TArray = theList;
            int n = theList.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                if (object.getName().equals(objectName)) {
                    return object;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> List<T> findObjects(@Nullable Collection<T> theList, @Nullable String objectName) {
        if (theList != null && !theList.isEmpty()) {
            ArrayList<DBPNamedObject> result = new ArrayList<DBPNamedObject>();
            for (DBPNamedObject object : theList) {
                if (!object.getName().equalsIgnoreCase(objectName)) continue;
                result.add(object);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public static <T> T getAdapter(@NotNull Class<T> adapterType, @Nullable Object object) {
        Object object2 = object;
        if (object2 instanceof DBPDataSourceContainer && (var2_3 = (DBPDataSourceContainer)object2) == (DBPDataSourceContainer)var3_2) {
            object = ds.getDataSource();
        }
        if (object == null) {
            return null;
        }
        if (adapterType.isAssignableFrom(object.getClass())) {
            return adapterType.cast(object);
        }
        if (object instanceof IAdaptable var4_5) {
            return (T)adaptable.getAdapter(adapterType);
        }
        return null;
    }

    @Nullable
    public static <T> T getParentAdapter(@NotNull Class<T> i, DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject parent = object.getParentObject();
        if (parent == null) {
            return null;
        }
        T adapter = DBUtils.getAdapter(i, parent);
        return adapter == object ? null : (T)adapter;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject parent = object.getParentObject();
        while (parent != null) {
            if ((parent = DBUtils.getPublicObject(parent)) == null) break;
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBPDataSource || parent instanceof DBPDataSourceContainer) break;
            parent = parent.getParentObject();
        }
        return null;
    }

    public static boolean isParentOf(@NotNull DBSObject child, @NotNull DBSObject parent) {
        DBSObject object = child;
        while (object != null) {
            if (parent.equals(object)) {
                return true;
            }
            object = object.getParentObject();
        }
        return false;
    }

    @NotNull
    public static DBSObject[] getObjectPath(@NotNull DBSObject object, boolean includeSelf) {
        int depth = 0;
        DBSObject obj = root = includeSelf ? object : object.getParentObject();
        while (obj != null) {
            obj = DBUtils.getPublicObjectContainer(obj);
            ++depth;
            obj = obj.getParentObject();
        }
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBSTablePartition && (obj = (DBSTablePartition)dBSObject) == (DBSTablePartition)dBSObject && part.needFullPath()) {
            ++depth;
        }
        DBSObject[] path = new DBSObject[depth];
        DBSObject obj2 = root;
        while (obj2 != null) {
            obj2 = DBUtils.getPublicObjectContainer(obj2);
            path[depth-- - 1] = obj2;
            if (obj2 instanceof DBSTablePartition var8_8 && part.needFullPath()) {
                path[depth-- - 1] = part.getParentTable();
            }
            obj2 = obj2.getParentObject();
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public static String getObjectFullId(@NotNull DBSObject object) {
        DBSObject[] path = DBUtils.getObjectPath(object, true);
        StringBuilder pathStr = new StringBuilder();
        DBSObject[] dBSObjectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject obj = dBSObjectArray[n2];
            if (!DBUtils.isVirtualObject(obj)) {
                DBPDataSourceContainer dBPDataSourceContainer;
                DBSObject dBSObject;
                if (pathStr.length() > 0) {
                    pathStr.append('/');
                }
                if ((dBSObject = (obj = DBUtils.getPublicObjectContainer(obj))) instanceof DBPDataSourceContainer && (dBPDataSourceContainer = (DBPDataSourceContainer)dBSObject) == (DBPDataSourceContainer)dBSObject) {
                    void ds;
                    pathStr.append(ds.getId());
                } else {
                    pathStr.append(obj.getName());
                }
            }
            ++n2;
        }
        return pathStr.toString();
    }

    public static String getObjectNameFromId(String objectId) {
        String[] parts = objectId.split("/");
        return parts[parts.length - 1];
    }

    public static DBSObject findObjectById(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String objectId) throws DBException {
        String[] names = objectId.split("/");
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSource(names[0]);
        if (dataSourceContainer == null) {
            log.debug("Can't find datasource '" + names[0] + "' in project " + project.getName());
            return null;
        }
        if (names.length == 1) {
            return dataSourceContainer;
        }
        if (!dataSourceContainer.isConnected()) {
            try {
                dataSourceContainer.connect(monitor, true, true);
            }
            catch (DBException e) {
                throw new DBException("Error connecting to datasource '" + dataSourceContainer.getName() + "'", e);
            }
        }
        if ((dataSource = dataSourceContainer.getDataSource()) == null) {
            log.debug("Null datasource in container " + dataSourceContainer.getId());
            return null;
        }
        DBSObjectContainer sc = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        DBSEntity finalEntity = null;
        if (sc != null) {
            int i = 1;
            while (i < names.length - 1) {
                String name = names[i];
                child = sc.getChild(monitor, name);
                if (child == null) {
                    log.debug("Can't find child container " + name + " in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                    return null;
                }
                if (!(child instanceof DBSObjectContainer var11_13)) {
                    if (child instanceof DBSEntity && i == names.length - 2) {
                        sc = null;
                        finalEntity = (DBSEntity)child;
                        break;
                    }
                    log.debug("Child object '" + name + "' is not a container or entity");
                    return null;
                }
                sc = oc;
                ++i;
            }
        }
        String objectName = names[names.length - 1];
        if (sc != null) {
            DBSObject object = sc.getChild(monitor, objectName);
            if (object == null) {
                log.debug("Child object '" + objectName + "' not found in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                throw new DBException("Child object '" + objectName + "' not found in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
            }
            return object;
        }
        if (finalEntity != null) {
            DBSEntityAttribute attribute = finalEntity.getAttribute(monitor, objectName);
            if (attribute != null) {
                return attribute;
            }
            DBSEntity dBSEntity = finalEntity;
            if (dBSEntity instanceof DBSTable && (child = (DBSTable)dBSEntity) == (DBSTable)dBSEntity) {
                List<? extends DBSTrigger> triggers = table.getTriggers(monitor);
                if (triggers != null && (trigger = DBUtils.findObject(triggers, objectName)) != null) {
                    return trigger;
                }
                Collection<? extends DBSTableIndex> indices = table.getIndexes(monitor);
                if (indices != null && (index = DBUtils.findObject(indices, objectName)) != null) {
                    return index;
                }
                if (finalEntity instanceof DBSPartitionContainer && !CommonUtils.isEmpty(partitions = ((DBSPartitionContainer)((Object)finalEntity)).getPartitions(monitor)) && (partition = DBUtils.findObject(partitions, objectName)) != null) {
                    return partition;
                }
                log.debug("Object '" + objectName + "' not found in entity " + DBUtils.getObjectFullName(finalEntity, DBPEvaluationContext.UI));
                return null;
            }
        }
        return null;
    }

    public static DBPDataSourceContainer findDataSourceByObjectId(@NotNull DBPProject project, @NotNull String objectId) {
        return project.getDataSourceRegistry().getDataSource(objectId.split("/")[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNullValue(@Nullable Object value) {
        void dbv;
        void var2_1;
        DBDValue dBDValue;
        Object object;
        return value == null || (object = value) instanceof DBDValue && (dBDValue = (DBDValue)object) == (DBDValue)var2_1 && dbv.isNull();
    }

    public static boolean isErrorValue(@Nullable Object value) {
        return value instanceof DBDValueError;
    }

    @Nullable
    public static Object makeNullValue(@NotNull DBCSession session, @NotNull DBDValueHandler valueHandler, @NotNull DBSTypedObject type) throws DBCException {
        return valueHandler.getValueFromObject(session, type, null, false, false);
    }

    @NotNull
    public static DBDAttributeBindingMeta getAttributeBinding(@NotNull DBSDataContainer dataContainer, @NotNull DBCSession session, @NotNull DBCAttributeMetaData attributeMeta) {
        return new DBDAttributeBindingMeta(dataContainer, session, attributeMeta);
    }

    @NotNull
    public static DBDAttributeBinding[] getAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSetMetaData metaData) {
        List<DBCAttributeMetaData> metaAttributes = metaData.getAttributes();
        int columnsCount = metaAttributes.size();
        DBDAttributeBinding[] bindings = new DBDAttributeBinding[columnsCount];
        int i = 0;
        while (i < columnsCount) {
            bindings[i] = DBUtils.getAttributeBinding(dataContainer, session, metaAttributes.get(i));
            ++i;
        }
        return DBUtils.injectAndFilterAttributeBindings(session.getDataSource(), dataContainer, bindings, false);
    }

    /*
     * WARNING - void declaration
     */
    public static DBDAttributeBinding[] injectAndFilterAttributeBindings(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer dataContainer, DBDAttributeBinding[] bindings, boolean filterAttributes) {
        DBSDataContainer dBSDataContainer;
        Object customAttributes;
        DBVEntity vEntity = DBVUtils.getVirtualEntity(dataContainer, false);
        if (vEntity != null && !CommonUtils.isEmpty(customAttributes = DBVUtils.getCustomAttributes(vEntity))) {
            DBDAttributeBinding[] customBindings = new DBDAttributeBinding[customAttributes.size()];
            int i = 0;
            while (i < customAttributes.size()) {
                customBindings[i] = new DBDAttributeBindingCustom(null, dataContainer, dataSource, (DBVEntityAttribute)customAttributes.get(i), bindings.length + i);
                ++i;
            }
            DBDAttributeBinding[] combinedAttrs = new DBDAttributeBinding[bindings.length + customBindings.length];
            System.arraycopy(bindings, 0, combinedAttrs, 0, bindings.length);
            System.arraycopy(customBindings, 0, combinedAttrs, bindings.length, customBindings.length);
            bindings = combinedAttrs;
        }
        if (filterAttributes && (dBSDataContainer = dataContainer) instanceof DBDAttributeFilter && (customAttributes = (DBDAttributeFilter)dBSDataContainer) == (DBDAttributeFilter)dBSDataContainer) {
            void attributeFilter;
            return attributeFilter.filterAttributeBindings(bindings);
        }
        return bindings;
    }

    @NotNull
    public static DBDAttributeBinding[] makeLeafAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSet resultSet) throws DBCException {
        ArrayList<DBDAttributeBinding> metaColumns = new ArrayList<DBDAttributeBinding>();
        List<DBCAttributeMetaData> attributes = resultSet.getMeta().getAttributes();
        boolean bl = isDocumentAttribute = attributes.size() == 1 && attributes.get(0).getDataKind() == DBPDataKind.DOCUMENT;
        if (isDocumentAttribute) {
            DBCAttributeMetaData attributeMeta = attributes.get(0);
            DBDAttributeBindingMeta docBinding = DBUtils.getAttributeBinding(dataContainer, session, attributeMeta);
            try {
                List<Object[]> sampleRows = Collections.emptyList();
                if (resultSet instanceof DBCResultSetSampleProvider var9_11) {
                    session.getProgressMonitor().subTask("Read sample rows");
                    sampleRows = rssp.getSampleRows(session, 1000);
                }
                session.getProgressMonitor().subTask("Discover attribute structure");
                docBinding.lateBinding(session, sampleRows);
            }
            catch (Exception e) {
                log.error("Document attribute '" + docBinding.getName() + "' binding error", e);
            }
            List<DBDAttributeBinding> nested = docBinding.getNestedBindings();
            if (!CommonUtils.isEmpty(nested)) {
                metaColumns.addAll(nested);
            } else {
                try {
                    DBSEntity docEntity = DBUtils.getEntityFromMetaData(session.getProgressMonitor(), session.getExecutionContext(), attributeMeta.getEntityMetaData());
                    if (docEntity != null && !CommonUtils.isEmpty(entityAttrs = docEntity.getAttributes(session.getProgressMonitor()))) {
                        for (DBSEntityAttribute dBSEntityAttribute : entityAttrs) {
                            metaColumns.add(new DBDAttributeBindingType(docBinding, dBSEntityAttribute, metaColumns.size()));
                        }
                    }
                }
                catch (DBException e) {
                    log.debug("Error getting attributes from document entity", e);
                }
            }
        }
        if (metaColumns.isEmpty()) {
            for (DBCAttributeMetaData attribute : attributes) {
                DBDAttributeBindingMeta columnBinding = DBUtils.getAttributeBinding(dataContainer, session, attribute);
                metaColumns.add(columnBinding);
            }
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(metaColumns.size());
        for (DBDAttributeBinding binding : metaColumns) {
            DBUtils.addLeafBindings(result, binding);
        }
        return DBUtils.injectAndFilterAttributeBindings(session.getDataSource(), dataContainer, result.toArray(new DBDAttributeBinding[0]), true);
    }

    private static void addLeafBindings(List<DBDAttributeBinding> result, DBDAttributeBinding binding) {
        List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
        if (CommonUtils.isEmpty(nestedBindings)) {
            result.add(binding);
        } else {
            for (DBDAttributeBinding nested : nestedBindings) {
                DBUtils.addLeafBindings(result, nested);
            }
        }
    }

    @Nullable
    public static Object getAttributeValue(@NotNull DBDAttributeBinding attribute, DBDAttributeBinding[] allAttributes, Object[] row) {
        return DBUtils.getAttributeValue(attribute, allAttributes, row, null);
    }

    @Nullable
    public static Object getAttributeValue(@NotNull DBDAttributeBinding attribute, @NotNull DBDAttributeBinding[] allAttributes, @NotNull Object[] row, @Nullable int[] nestedIndexes) {
        if (attribute.isCustom()) {
            try {
                return DBVUtils.executeExpression(((DBDAttributeBindingCustom)attribute).getEntityAttribute(), allAttributes, row);
            }
            catch (Exception e) {
                return new DBDValueError(e);
            }
        }
        int depth = attribute.getLevel();
        int index = attribute.getTopParent().getOrdinalPosition();
        if (depth == 0 && attribute != attribute.getTopParent()) {
            log.debug("Top-level attribute '" + attribute.getName() + "' has bad top-level parent: '" + attribute.getTopParent().getName() + "'");
            return null;
        }
        if (index >= row.length) {
            log.debug("Bad attribute '" + attribute.getName() + "' index: " + index + " is out of row values' bounds (" + row.length + ")");
            return null;
        }
        Object curValue = row[index];
        int curNestedIndex = 0;
        int i = 0;
        while (i < depth) {
            block12: {
                if (curValue == null) break;
                DBDAttributeBinding parent = Objects.requireNonNull(attribute.getParent(depth - i - 1));
                try {
                    if (nestedIndexes == null || !DBUtils.isIndexedValue(parent, curValue)) {
                        curValue = parent.extractNestedValue(curValue, 0);
                        break block12;
                    }
                    if (DBUtils.isValidIndex(curValue, nestedIndexes[curNestedIndex])) {
                        curValue = parent.extractNestedValue(curValue, nestedIndexes[curNestedIndex]);
                        ++curNestedIndex;
                        break block12;
                    }
                    return DBDVoid.INSTANCE;
                }
                catch (Throwable e) {
                    return new DBDValueError(e);
                }
            }
            ++i;
        }
        while (nestedIndexes != null && curNestedIndex < nestedIndexes.length) {
            if (curValue == null || !DBUtils.isIndexedValue(attribute, curValue)) break;
            if (DBUtils.isValidIndex(curValue, nestedIndexes[curNestedIndex])) {
                curValue = DBUtils.getValueElement(curValue, nestedIndexes[curNestedIndex]);
                ++curNestedIndex;
                continue;
            }
            return DBDVoid.INSTANCE;
        }
        return curValue;
    }

    private static boolean isIndexedValue(@NotNull DBDAttributeBinding attr, @NotNull Object value) {
        return value instanceof List || value instanceof DBDComposite && !(value instanceof DBDDocument) && attr.getDataKind() == DBPDataKind.STRUCT;
    }

    private static boolean isValidIndex(@NotNull Object value, int index) {
        return !(value instanceof List && ((List)value).size() <= index || value instanceof DBDComposite && ((DBDComposite)value).getAttributeCount() <= index);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Object getValueElement(@NotNull Object value, int index) {
        void var3_2;
        DBDComposite dBDComposite;
        Object object = value;
        if (object instanceof DBDComposite && (dBDComposite = (DBDComposite)object) == (DBDComposite)var3_2) {
            void composite;
            DBSAttributeBase attribute = composite.getAttributes()[index];
            try {
                return composite.getAttributeValue(attribute);
            }
            catch (DBCException e) {
                return new DBDValueError(e);
            }
        }
        if (value instanceof List && ((List)value).size() > index) {
            return ((List)value).get(index);
        }
        return null;
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBCSession session, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(session.getDataSource(), session, column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(dataSource, dataSource.getContainer(), column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@Nullable DBPDataSource dataSource, @Nullable DBDFormatSettings preferences, @NotNull DBSTypedObject column) {
        DBDValueHandler valueHandler = null;
        DBDValueHandlerProvider handlerProvider = DBUtils.getAdapter(DBDValueHandlerProvider.class, dataSource);
        if (handlerProvider != null && (valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column)) != null) {
            return valueHandler;
        }
        if (dataSource != null && (handlerProvider = DBWorkbench.getPlatform().getValueHandlerRegistry().getValueHandlerProvider(dataSource, column)) != null) {
            valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column);
        }
        if (valueHandler == null) {
            valueHandler = preferences == null ? DefaultValueHandler.INSTANCE : preferences.getDefaultValueHandler();
        }
        return valueHandler;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIdentifyingAssociation(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        if (!(association instanceof DBSEntityReferrer)) {
            return false;
        }
        DBSEntityReferrer referrer = (DBSEntityReferrer)((Object)association);
        DBSEntity refEntity = association.getAssociatedEntity();
        DBSEntity ownerEntity = association.getParentObject();
        assert (ownerEntity != null);
        if (refEntity == ownerEntity) {
            return false;
        }
        List<DBSEntityAttribute> ownAttrs = DBUtils.getEntityAttributes(monitor, referrer);
        Collection<? extends DBSEntityConstraint> constraints = ownerEntity.getConstraints(monitor);
        if (constraints != null) {
            boolean hasPrimaryKey = false;
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
                hasPrimaryKey = true;
                break;
            }
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                void eref;
                DBSEntityReferrer dBSEntityReferrer;
                DBSEntityConstraint dBSEntityConstraint2 = dBSEntityConstraint;
                if (!(dBSEntityConstraint2 instanceof DBSEntityReferrer) || (dBSEntityReferrer = (DBSEntityReferrer)dBSEntityConstraint2) != (DBSEntityReferrer)dBSEntityConstraint2 || (!hasPrimaryKey || dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) && (hasPrimaryKey || !dBSEntityConstraint.getConstraintType().isUnique())) continue;
                List<DBSEntityAttribute> constAttrs = DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)eref);
                boolean included = true;
                for (DBSEntityAttribute attr : ownAttrs) {
                    if (constAttrs.contains(attr)) continue;
                    included = false;
                    break;
                }
                if (!included) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOptionalAssociation(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        void eref;
        void var3_2;
        DBSEntityReferrer dBSEntityReferrer;
        DBSEntityAssociation dBSEntityAssociation = association;
        if (!(dBSEntityAssociation instanceof DBSEntityReferrer) || (dBSEntityReferrer = (DBSEntityReferrer)((Object)dBSEntityAssociation)) != (DBSEntityReferrer)var3_2) {
            return false;
        }
        for (DBSEntityAttributeRef ref : CommonUtils.safeCollection(eref.getAttributeReferences(monitor))) {
            if (ref.getAttribute() == null || ref.getAttribute().isRequired()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String getDefaultDataTypeName(@NotNull DBSObject objectContainer, DBPDataKind dataKind) {
        void var3_2;
        DBPDataTypeProvider dBPDataTypeProvider;
        DBSObject dBSObject = objectContainer;
        if (dBSObject instanceof DBPDataTypeProvider && (dBPDataTypeProvider = (DBPDataTypeProvider)((Object)dBSObject)) == (DBPDataTypeProvider)var3_2) {
            void dtp;
            return dtp.getDefaultDataTypeName(dataKind);
        }
        return "?";
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull Collection<DBDAttributeBinding> bindings, @NotNull DBSAttributeBase attribute) {
        for (DBDAttributeBinding binding : bindings) {
            DBDAttributeBinding subBinding;
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings == null || (subBinding = DBUtils.findBinding(nestedBindings, attribute)) == null) continue;
            return subBinding;
        }
        return null;
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull DBDAttributeBinding[] bindings, @Nullable DBSAttributeBase attribute) {
        if (attribute == null) {
            return null;
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding subBinding;
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings != null && (subBinding = DBUtils.findBinding(nestedBindings, attribute)) != null) {
                return subBinding;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<DBSEntityReferrer> getAttributeReferrers(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute entityAttribute, boolean includeVirtual) throws DBException {
        Collection<DBSEntityAssociation> associations;
        DBSEntity entity = entityAttribute.getParentObject();
        Collection<DBSEntityAssociation> collection = associations = includeVirtual ? DBVUtils.getAllAssociations(monitor, entity) : entity.getAssociations(monitor);
        if (associations != null) {
            ArrayList<DBSEntityReferrer> refs = new ArrayList<DBSEntityReferrer>();
            for (DBSEntityAssociation fk : associations) {
                void referrer;
                DBSEntityReferrer dBSEntityReferrer;
                DBSEntityAssociation dBSEntityAssociation = fk;
                if (!(dBSEntityAssociation instanceof DBSEntityReferrer) || (dBSEntityReferrer = (DBSEntityReferrer)((Object)dBSEntityAssociation)) != (DBSEntityReferrer)((Object)dBSEntityAssociation) || DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)referrer, entityAttribute) == null) continue;
                refs.add((DBSEntityReferrer)((Object)fk));
            }
            return refs;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        DBSEntity dBSEntity = entity;
        if (dBSEntity instanceof DBSTable && (var2_3 = (DBSTable)dBSEntity) == (DBSTable)var3_2 && table.isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty(entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityConstraint> identifiers = new ArrayList<DBSEntityConstraint>();
        if (entity instanceof DBSTable var5_6) {
            try {
                Collection<? extends DBSTableIndex> indexes = table.getIndexes(monitor);
                if (!CommonUtils.isEmpty(indexes)) {
                    for (DBSTableIndex dBSTableIndex : indexes) {
                        if (!DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                        identifiers.add(dBSTableIndex);
                    }
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (identifiers.isEmpty() && (uniqueKeys = entity.getConstraints(monitor)) != null) {
            for (DBSEntityConstraint dBSEntityConstraint : uniqueKeys) {
                if (!DBUtils.isIdentifierConstraint(monitor, dBSEntityConstraint)) continue;
                identifiers.add(dBSEntityConstraint);
            }
        }
        if (!identifiers.isEmpty()) {
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                if (dBSEntityConstraint instanceof DBSEntityReferrer var10_16 && dBSEntityConstraint.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                    return DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)referrer);
                }
                if (dBSEntityConstraint.getConstraintType().isUnique()) {
                    uniqueId = dBSEntityConstraint;
                    continue;
                }
                 instanceOfPatternExpressionValue = dBSEntityConstraint;
                if (!( instanceOfPatternExpressionValue instanceof DBSTableIndex) || (var12_18 = (DBSTableIndex) instanceOfPatternExpressionValue) != (DBSTableIndex) instanceOfPatternExpressionValue || !tableIndex.isUnique()) continue;
                uniqueId = dBSEntityConstraint;
            }
            DBSEntityConstraint dBSEntityConstraint = uniqueId;
            return dBSEntityConstraint instanceof DBSEntityReferrer && (var8_15 = (DBSEntityReferrer)dBSEntityConstraint) == (DBSEntityReferrer)dBSEntityConstraint ? DBUtils.getEntityAttributes(monitor, var8_15) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static boolean isIdentifierIndex(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        if (!index.isUnique()) {
            return false;
        }
        List<? extends DBSTableIndexColumn> attrs = index.getAttributeReferences(monitor);
        if (attrs == null || attrs.isEmpty()) {
            return false;
        }
        for (DBSTableIndexColumn dBSTableIndexColumn : attrs) {
            if (dBSTableIndexColumn.getTableColumn() != null && dBSTableIndexColumn.getTableColumn().isRequired()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIdentifierConstraint(DBRProgressMonitor monitor, DBSEntityConstraint constraint) throws DBException {
        if (constraint.getConstraintType().isUnique()) {
            void var3_2;
            DBSEntityReferrer dBSEntityReferrer;
            DBSEntityConstraint dBSEntityConstraint = constraint;
            if (dBSEntityConstraint instanceof DBSEntityReferrer && (dBSEntityReferrer = (DBSEntityReferrer)dBSEntityConstraint) == (DBSEntityReferrer)var3_2) {
                void referrer;
                List<? extends DBSEntityAttributeRef> attrs = referrer.getAttributeReferences(monitor);
                if (attrs == null || attrs.isEmpty()) {
                    return false;
                }
                for (DBSEntityAttributeRef dBSEntityAttributeRef : attrs) {
                    if (dBSEntityAttributeRef.getAttribute() != null && dBSEntityAttributeRef.getAttribute().isRequired() || constraint.getDataSource().getInfo().supportsNullableUniqueConstraints()) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static DBSEntityConstraint findEntityConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        Collection<? extends DBSEntityConstraint> constraints = entity.getConstraints(monitor);
        if (!CommonUtils.isEmpty(constraints)) {
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                DBSEntityConstraint dBSEntityConstraint2 = dBSEntityConstraint;
                if (!(dBSEntityConstraint2 instanceof DBSEntityReferrer) || (var6_7 = (DBSEntityReferrer)dBSEntityConstraint2) != (DBSEntityReferrer)dBSEntityConstraint2 || !DBUtils.referrerMatches(monitor, (DBSEntityReferrer)referrer, attributes)) continue;
                return dBSEntityConstraint;
            }
        }
        if (entity instanceof DBSTable var4_6 && !CommonUtils.isEmpty(indexes = var4_6.getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : indexes) {
                if (!dBSTableIndex.isUnique() || !DBUtils.referrerMatches(monitor, dBSTableIndex, attributes)) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    public static boolean referrerMatches(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer referrer, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        List<? extends DBSEntityAttributeRef> refs = referrer.getAttributeReferences(monitor);
        if (refs != null && !refs.isEmpty() && attributes.size() == refs.size()) {
            Iterator<? extends DBSEntityAttribute> attrIterator = attributes.iterator();
            for (DBSEntityAttributeRef dBSEntityAttributeRef : refs) {
                if (!attrIterator.hasNext()) {
                    return false;
                }
                if (dBSEntityAttributeRef.getAttribute() != null && CommonUtils.equalObjects((Object)dBSEntityAttributeRef.getAttribute().getName(), (Object)attrIterator.next().getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<DBSEntityAttribute> getEntityAttributes(@NotNull DBRProgressMonitor monitor, @Nullable DBSEntityReferrer referrer) {
        try {
            if (referrer instanceof DBVEntityConstraint var2_4 && ec.isUseAllColumns() && (var4_6 = ec.getEntity().getRealEntity(monitor)) != null) {
                List<? extends DBSEntityAttribute> attributes = var4_6.getAttributes(monitor);
                return attributes == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(attributes);
            }
        }
        catch (DBException e) {
            log.error("Error discovering virtual constraint attributes", e);
        }
        List<? extends DBSEntityAttributeRef> constraintColumns = null;
        if (referrer != null) {
            try {
                constraintColumns = referrer.getAttributeReferences(monitor);
            }
            catch (DBException e) {
                log.warn("Error reading reference attributes", e);
            }
        }
        if (constraintColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityAttribute> attributes = new ArrayList<DBSEntityAttribute>(constraintColumns.size());
        for (DBSEntityAttributeRef dBSEntityAttributeRef : constraintColumns) {
            DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull DBSEntityAttribute tableColumn) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                if (dBSEntityAttributeRef.getAttribute() != tableColumn) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull String columnName) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
                if (attribute == null || !attribute.getName().equals(columnName)) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttribute getReferenceAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association, @NotNull DBSEntityAttribute tableColumn, boolean reference) throws DBException {
        DBSEntityConstraint refConstr = association.getReferencedConstraint();
        if (association instanceof DBSEntityReferrer var5_6 && ( instanceOfPatternExpressionValue = refConstr) instanceof DBSEntityReferrer var6_8) {
            List<? extends DBSEntityAttributeRef> ownAttrs = eRef.getAttributeReferences(monitor);
            List<? extends DBSEntityAttributeRef> refAttrs = rRef.getAttributeReferences(monitor);
            if (ownAttrs == null || refAttrs == null || ownAttrs.size() != refAttrs.size()) {
                log.error("Invalid internal state of referrer association");
                return null;
            }
            Iterator ownIterator = ownAttrs.iterator();
            Iterator refIterator = refAttrs.iterator();
            while (ownIterator.hasNext()) {
                DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownIterator.next();
                if (reference ? ( instanceOfPatternExpressionValue = ownAttr) instanceof DBSTableForeignKeyColumn && (var14_14 = (DBSTableForeignKeyColumn) instanceOfPatternExpressionValue) == (DBSTableForeignKeyColumn) instanceOfPatternExpressionValue && fkc.getReferencedColumn() == tableColumn : ownAttr.getAttribute() == tableColumn) {
                    return ((DBSEntityAttributeRef)refIterator.next()).getAttribute();
                }
                refIterator.next();
            }
        }
        return null;
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull String query, long offset, long maxRows) throws DBCException {
        SQLQuery sqlQuery = new SQLQuery(session.getDataSource(), query);
        return DBUtils.makeStatement(executionSource, session, statementType, sqlQuery, offset, maxRows);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull SQLQuery sqlQuery, long offset, long maxRows) throws DBCException {
        String queryText;
        void faQT;
        DBCQueryTransformer dBCQueryTransformer;
        void lQT;
        DBCQueryTransformer dBCQueryTransformer2;
        Object transformProvider;
        boolean selectQuery = sqlQuery.getType() == SQLQueryType.SELECT && sqlQuery.isPlainSelect();
        boolean hasLimits = (offset > 0L || selectQuery) && maxRows > 0L;
        boolean isShouldSetLimit = true;
        boolean possiblySelect = sqlQuery.getType() == SQLQueryType.SELECT || sqlQuery.getType() == SQLQueryType.UNKNOWN;
        boolean limitAffectsDML = Boolean.TRUE.equals(session.getDataSource().getDataSourceFeature("datasource.limit-affects-dml"));
        DBCQueryTransformer limitTransformer = null;
        DBCQueryTransformer fetchAllTransformer = null;
        if (selectQuery && (transformProvider = DBUtils.getAdapter(DBCQueryTransformProvider.class, session.getDataSource())) != null) {
            Object object = transformProvider;
            if (transformProvider instanceof DBCQueryTransformProviderExt var16_15) {
                void qtp;
                isShouldSetLimit = qtp.isLimitApplicableTo(sqlQuery);
            }
            if (hasLimits) {
                void qtp;
                if (session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.maxrows.sql") || ( instanceOfPatternExpressionValue = transformProvider) instanceof DBCQueryTransformProviderExt var18_18 && qtp.isForceTransform(session, sqlQuery)) {
                    limitTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.RESULT_SET_LIMIT);
                }
            } else {
                fetchAllTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.FETCH_ALL_TABLE);
            }
        }
        if ((dBCQueryTransformer2 = limitTransformer) instanceof DBCQueryTransformerExt && (transformProvider = (DBCQueryTransformerExt)((Object)dBCQueryTransformer2)) == (DBCQueryTransformerExt)((Object)dBCQueryTransformer2) && !lQT.isApplicableTo(sqlQuery)) {
            limitTransformer = null;
        }
        if ((dBCQueryTransformer = fetchAllTransformer) instanceof DBCQueryTransformerExt && (object = (DBCQueryTransformerExt)((Object)dBCQueryTransformer)) == (DBCQueryTransformerExt)((Object)dBCQueryTransformer) && !faQT.isApplicableTo(sqlQuery)) {
            fetchAllTransformer = null;
        }
        boolean doScrollable = offset > 0L;
        try {
            if (hasLimits && limitTransformer != null) {
                limitTransformer.setParameters(offset, maxRows);
                queryText = limitTransformer.transformQueryString(sqlQuery);
                doScrollable = false;
            } else {
                queryText = fetchAllTransformer != null ? fetchAllTransformer.transformQueryString(sqlQuery) : sqlQuery.getText();
            }
        }
        catch (Exception e) {
            log.debug("Error transforming SQL query", e);
            queryText = sqlQuery.getText();
        }
        DBCStatement dbStat = statementType == DBCStatementType.SCRIPT ? DBUtils.createStatement(session, queryText, doScrollable) : DBUtils.makeStatement(session, queryText, doScrollable);
        dbStat.setStatementSource(executionSource);
        if (offset > 0L || hasLimits || possiblySelect && maxRows > 0L && !limitAffectsDML) {
            if (limitTransformer == null) {
                if (isShouldSetLimit) {
                    dbStat.setLimit(offset, maxRows);
                }
            } else {
                limitTransformer.transformStatement(dbStat, 0);
            }
        } else if (fetchAllTransformer != null) {
            fetchAllTransformer.transformStatement(dbStat, 0);
        }
        return dbStat;
    }

    @NotNull
    public static DBCStatement createStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        SQLDialect dialect = SQLUtils.getDialectFromObject(session.getDataSource());
        DBCStatementType statementType = DBCStatementType.SCRIPT;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(dialect, query)) {
            statementType = DBCStatementType.EXEC;
            query = dialect.formatStoredProcedureCall(session.getDataSource(), query);
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        DBCStatementType statementType = DBCStatementType.QUERY;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(SQLUtils.getDialectFromObject(session.getDataSource()), query)) {
            statementType = DBCStatementType.EXEC;
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    public static void fireObjectUpdate(@NotNull DBSObject object) {
        DBUtils.fireObjectUpdate(object, null, null);
    }

    public static void fireObjectUpdate(DBSObject object, boolean enabled) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, enabled));
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Map<String, Object> options, @Nullable Object data) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, data);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Object data) {
        DBUtils.fireObjectUpdate(object, null, data);
    }

    public static void fireObjectAdd(DBSObject object, Map<String, Object> options) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_ADD, object);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectRemove(DBSObject object) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_REMOVE, object));
        }
    }

    public static void fireObjectSelect(DBSObject object, boolean select) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_SELECT, object, select));
        }
    }

    public static void fireObjectRefresh(DBSObject object) {
        DBUtils.fireObjectSelect(object, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String getObjectUniqueName(@NotNull DBSObject object) {
        void var2_1;
        DBPUniqueObject dBPUniqueObject;
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBPUniqueObject && (dBPUniqueObject = (DBPUniqueObject)((Object)dBSObject)) == (DBPUniqueObject)var2_1) {
            void uo;
            return uo.getUniqueName();
        }
        return object.getName();
    }

    @Nullable
    public static DBSDataType findBestDataType(@NotNull Collection<? extends DBSDataType> allTypes, String ... typeNames) {
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String testType = stringArray[n2];
            for (DBSDataType dBSDataType : allTypes) {
                if (!dBSDataType.getName().equalsIgnoreCase(testType)) continue;
                return dBSDataType;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    public static <T extends DBSTypedObject> T getMoreCommonType(@NotNull T t1, @NotNull T t2) {
        if (!t1.equals(t2) && t1.getDataKind().getCommonality() < t2.getDataKind().getCommonality()) {
            return t2;
        }
        return t1;
    }

    @Nullable
    public static DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String fullTypeName) throws DBException {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.resolveDataType(monitor, fullTypeName);
    }

    @Nullable
    public static DBSDataType getLocalDataType(@NotNull DBPDataSource dataSource, @NotNull String fullTypeName) {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.getLocalDataType(fullTypeName);
    }

    public static DBSObject getPublicObject(@Nullable DBSObject object) {
        if (object instanceof DBPDataSourceContainer) {
            return object.getDataSource();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static DBSObject getPublicObjectContainer(@NotNull DBSObject object) {
        void var2_1;
        DBPDataSource dBPDataSource;
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBPDataSource && (dBPDataSource = (DBPDataSource)dBSObject) == (DBPDataSource)var2_1) {
            void ds;
            return ds.getContainer();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DBPDataSourceContainer getContainer(@Nullable DBSObject object) {
        void var2_1;
        DBPDataSourceContainer dBPDataSourceContainer;
        if (object == null) {
            return null;
        }
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBPDataSourceContainer && (dBPDataSourceContainer = (DBPDataSourceContainer)dBSObject) == (DBPDataSourceContainer)var2_1) {
            void dsc;
            return dsc;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null ? null : dataSource.getContainer();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DBPDataSourceRegistry getObjectRegistry(@NotNull DBSObject object) {
        DBPDataSourceContainer container;
        void var3_1;
        DBPDataSourceContainer dBPDataSourceContainer;
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBPDataSourceContainer && (dBPDataSourceContainer = (DBPDataSourceContainer)dBSObject) == (DBPDataSourceContainer)var3_1) {
            void dsc;
            container = dsc;
        } else {
            DBPDataSource dataSource = object.getDataSource();
            if (dataSource == null) {
                return null;
            }
            container = dataSource.getContainer();
        }
        return container.getRegistry();
    }

    @Nullable
    public static DBPProject getObjectOwnerProject(DBSObject object) {
        DBPDataSourceRegistry registry = DBUtils.getObjectRegistry(object);
        return registry == null ? null : registry.getProject();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String getObjectShortName(Object object) {
        void no;
        void var3_1;
        DBPNamedObject dBPNamedObject;
        Object object2 = object;
        String strValue = object2 instanceof DBPNamedObject && (dBPNamedObject = (DBPNamedObject)object2) == (DBPNamedObject)var3_1 ? no.getName() : String.valueOf(object);
        return strValue;
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPNamedObject object, DBPEvaluationContext context) {
        DBPNamedObject dBPNamedObject = object;
        if (dBPNamedObject instanceof DBPQualifiedObject && (var2_3 = (DBPQualifiedObject)((Object)dBPNamedObject)) == (DBPQualifiedObject)var3_2) {
            return qo.getFullyQualifiedName(context);
        }
        if (object instanceof DBSObject var4_5 && dbso.getDataSource() != null) {
            return DBUtils.getObjectFullName(dbso.getDataSource(), object, context, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        return object.getName();
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPDataSource dataSource, @NotNull DBPNamedObject object, @NotNull DBPEvaluationContext context) {
        return DBUtils.getObjectFullName(dataSource, object, context, DBPAttributeReferencePurpose.UNSPECIFIED);
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPDataSource dataSource, @NotNull DBPNamedObject object, @NotNull DBPEvaluationContext context, @NotNull DBPAttributeReferencePurpose purpose) {
        if (object instanceof DBDAttributeBinding var4_5) {
            return binding.getFullyQualifiedName(context, purpose);
        }
        if (object instanceof DBPQualifiedObject var6_7) {
            return qo.getFullyQualifiedName(context);
        }
        return DBUtils.getQuotedIdentifier(dataSource, object.getName());
    }

    @NotNull
    public static String getFullTypeName(@NotNull DBSTypedObject typedObject) {
        DBSObject structObject = DBUtils.getFromObject(typedObject);
        DBPDataSource dataSource = structObject == null ? null : structObject.getDataSource();
        return DBUtils.getFullTypeName(dataSource, typedObject);
    }

    @NotNull
    public static String getFullTypeName(DBPDataSource dataSource, @NotNull DBSTypedObject typedObject) {
        String typeName = typedObject.getTypeName();
        if (CommonUtils.isEmpty((String)typeName)) {
            return "<" + ModelMessages.dbutils_type_name_unknown + ">";
        }
        String typeModifiers = SQLUtils.getColumnTypeModifiers(dataSource, typedObject, typeName, typedObject.getDataKind());
        return typeModifiers == null ? typeName : String.valueOf(typeName) + typeModifiers;
    }

    /*
     * WARNING - void declaration
     */
    public static void releaseValue(@Nullable Object value) {
        void var2_1;
        DBDValue dBDValue;
        Object object = value;
        if (object instanceof DBDValue && (dBDValue = (DBDValue)object) == (DBDValue)var2_1) {
            void dbdv;
            dbdv.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void resetValue(@Nullable Object value) {
        void var2_1;
        DBDContent dBDContent;
        Object object = value;
        if (object instanceof DBDContent && (dBDContent = (DBDContent)object) == (DBDContent)var2_1) {
            void dbdc;
            dbdc.resetContents();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static DBCLogicalOperator[] getAttributeOperators(DBSTypedObject attribute) {
        void typedObjectEx;
        DBSDataType dataType;
        void var2_1;
        DBSTypedObjectEx dBSTypedObjectEx;
        DBSTypedObject dBSTypedObject = attribute;
        if (dBSTypedObject instanceof DBSTypedObjectEx && (dBSTypedObjectEx = (DBSTypedObjectEx)((Object)dBSTypedObject)) == (DBSTypedObjectEx)var2_1 && (dataType = typedObjectEx.getDataType()) != null) {
            return dataType.getSupportedOperators(attribute);
        }
        return DBUtils.getDefaultOperators(attribute);
    }

    @NotNull
    public static DBCLogicalOperator[] getDefaultOperators(DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (attribute instanceof DBSAttributeBase && !((DBSAttributeBase)attribute).isRequired()) {
            operators.add(DBCLogicalOperator.IS_NULL);
            operators.add(DBCLogicalOperator.IS_NOT_NULL);
        }
        if (dataKind == DBPDataKind.BOOLEAN || dataKind == DBPDataKind.ROWID || dataKind == DBPDataKind.OBJECT || dataKind == DBPDataKind.BINARY) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
        } else if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
            operators.add(DBCLogicalOperator.IN);
        }
        if (dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.LIKE);
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }

    public static Object getRawValue(Object value) {
        if (value instanceof DBDValue) {
            return ((DBDValue)value).getRawValue();
        }
        return value;
    }

    public static DBSTableIndex findAttributeIndex(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        Collection<? extends DBSTableIndex> indexes;
        DBSEntity entity = attribute.getParentObject();
        if (entity instanceof DBSTable && !CommonUtils.isEmpty(indexes = ((DBSTable)entity).getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : indexes) {
                if (DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)dBSTableIndex, attribute) == null) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    @Nullable
    public static DBCTransactionManager getTransactionManager(@Nullable DBCExecutionContext executionContext) {
        if (executionContext != null && executionContext.isConnected()) {
            return DBUtils.getAdapter(DBCTransactionManager.class, executionContext);
        }
        return null;
    }

    @NotNull
    public static <T> Class<T> getDriverClass(@NotNull DBPDataSource dataSource, @NotNull String className) throws ClassNotFoundException {
        return Class.forName(className, true, dataSource.getContainer().getDriver().getClassLoader());
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) throws DBCException {
        DBCExecutionContext defaultContext = DBUtils.getOrOpenDefaultContext(object, true);
        if (defaultContext == null) {
            throw new DBCException("Default context not found");
        }
        return (T)defaultContext.openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String task) throws DBCException {
        return (T)dataSource.getDefaultInstance().getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openUtilSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) throws DBCException {
        DBCExecutionContext defaultContext = DBUtils.getOrOpenDefaultContext(object, true);
        if (defaultContext == null) {
            throw new DBCException("Default context not found");
        }
        return (T)DBUtils.getOrOpenDefaultContext(object, false).openSession(monitor, DBCExecutionPurpose.UTIL, task);
    }

    @Nullable
    public static DBSObject getFromObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DBSWrapper) {
            return ((DBSWrapper)object).getObject();
        }
        if (object instanceof DBSObject) {
            return (DBSObject)object;
        }
        return RuntimeUtils.getObjectAdapter(object, DBSObject.class);
    }

    public static boolean isAtomicParameter(Object o) {
        return o == null || o instanceof CharSequence || o instanceof Number || o instanceof Date || o instanceof Boolean;
    }

    @NotNull
    public static DBSObject getDefaultOrActiveObject(@NotNull DBSInstance object) {
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext(object, true);
        DBSObject activeObject = defaultContext == null ? null : DBUtils.getActiveInstanceObject(defaultContext);
        return activeObject == null ? object.getDataSource() : activeObject;
    }

    @Nullable
    public static DBSObject getActiveInstanceObject(@NotNull DBCExecutionContext executionContext) {
        return DBUtils.getSelectedObject(executionContext);
    }

    @Nullable
    public static DBSObject getSelectedObject(@NotNull DBCExecutionContext context) {
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults != null) {
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (defaultSchema != null) {
                return defaultSchema;
            }
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                return defaultCatalog;
            }
        }
        return null;
    }

    @Nullable
    public static <T> T getSelectedObject(@NotNull DBCExecutionContext context, Class<T> theClass) {
        DBSObject selectedObject = DBUtils.getSelectedObject(context);
        if (theClass.isInstance(selectedObject)) {
            return theClass.cast(selectedObject);
        }
        return null;
    }

    @NotNull
    public static DBSObject[] getSelectedObjects(@NotNull DBCExecutionContext context) {
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults != null) {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (defaultCatalog != null && defaultSchema != null) {
                return new DBSObject[]{defaultCatalog, defaultSchema};
            }
            if (defaultCatalog != null) {
                return new DBSObject[]{defaultCatalog};
            }
            if (defaultSchema != null) {
                return new DBSObject[]{defaultSchema};
            }
        }
        return new DBSObject[0];
    }

    public static void refreshContextDefaultsAndReflect(DBRProgressMonitor monitor, DBCExecutionContextDefaults contextDefaults) {
        try {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (contextDefaults.refreshDefaults(monitor, false)) {
                DBUtils.fireObjectSelectionChange(defaultCatalog, contextDefaults.getDefaultCatalog());
                DBUtils.fireObjectSelectionChange(defaultSchema, contextDefaults.getDefaultSchema());
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void fireObjectSelectionChange(DBSObject oldDefaultObject, DBSObject newDefaultObject) {
        if (oldDefaultObject != newDefaultObject) {
            if (oldDefaultObject != null) {
                DBUtils.fireObjectSelect(oldDefaultObject, false);
            }
            if (newDefaultObject != null) {
                DBUtils.fireObjectSelect(newDefaultObject, true);
            }
        }
    }

    public static DBSObjectContainer getChangeableObjectContainer(DBCExecutionContextDefaults contextDefaults, DBSObjectContainer root, Class<? extends DBSObject> childType) {
        if (contextDefaults == null) {
            return null;
        }
        if (childType == DBSCatalog.class && contextDefaults.supportsCatalogChange()) {
            return root;
        }
        if (childType == DBSSchema.class && contextDefaults.supportsSchemaChange()) {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                return defaultCatalog;
            }
            return root;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isHiddenObject(Object object) {
        void ho;
        void var2_1;
        DBPHiddenObject dBPHiddenObject;
        Object object2 = object;
        return object2 instanceof DBPHiddenObject && (dBPHiddenObject = (DBPHiddenObject)object2) == (DBPHiddenObject)var2_1 && ho.isHidden();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSystemObject(Object object) {
        void so;
        void var2_1;
        DBPSystemObject dBPSystemObject;
        Object object2 = object;
        return object2 instanceof DBPSystemObject && (dBPSystemObject = (DBPSystemObject)object2) == (DBPSystemObject)var2_1 && so.isSystem();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isVirtualObject(Object object) {
        void vo;
        void var2_1;
        DBPVirtualObject dBPVirtualObject;
        Object object2 = object;
        return object2 instanceof DBPVirtualObject && (dBPVirtualObject = (DBPVirtualObject)object2) == (DBPVirtualObject)var2_1 && vo.isVirtual();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInheritedObject(Object object) {
        void io;
        void var2_1;
        DBPInheritedObject dBPInheritedObject;
        Object object2 = object;
        return object2 instanceof DBPInheritedObject && (dBPInheritedObject = (DBPInheritedObject)object2) == (DBPInheritedObject)var2_1 && io.isInherited();
    }

    /*
     * WARNING - void declaration
     */
    public static DBDPseudoAttribute getRowIdAttribute(DBSEntity entity) {
        void var2_1;
        DBDPseudoAttributeContainer dBDPseudoAttributeContainer;
        DBSEntity dBSEntity = entity;
        if (dBSEntity instanceof DBDPseudoAttributeContainer && (dBDPseudoAttributeContainer = (DBDPseudoAttributeContainer)((Object)dBSEntity)) == (DBDPseudoAttributeContainer)var2_1) {
            try {
                void pac;
                return DBDPseudoAttribute.getAttribute(pac.getPseudoAttributes(), DBDPseudoAttributeType.ROWID);
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDynamicAttribute(DBSAttributeBase attr) {
        void da;
        void var2_1;
        DBSAttributeDynamic dBSAttributeDynamic;
        DBSAttributeBase dBSAttributeBase = attr;
        return dBSAttributeBase instanceof DBSAttributeDynamic && (dBSAttributeDynamic = (DBSAttributeDynamic)dBSAttributeBase) == (DBSAttributeDynamic)var2_1 && da.isDynamicAttribute();
    }

    public static boolean isRowIdAttribute(DBSEntityAttribute attr) {
        DBDPseudoAttribute rowIdAttribute = DBUtils.getRowIdAttribute(attr.getParentObject());
        return rowIdAttribute != null && rowIdAttribute.getName().equals(attr.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static DBDPseudoAttribute getPseudoAttribute(DBSEntity entity, String attrName) {
        void var3_2;
        DBDPseudoAttributeContainer dBDPseudoAttributeContainer;
        DBSEntity dBSEntity = entity;
        if (dBSEntity instanceof DBDPseudoAttributeContainer && (dBDPseudoAttributeContainer = (DBDPseudoAttributeContainer)((Object)dBSEntity)) == (DBDPseudoAttributeContainer)var3_2) {
            try {
                void pac;
                DBDPseudoAttribute[] pseudoAttributes = pac.getPseudoAttributes();
                if (pseudoAttributes != null && pseudoAttributes.length > 0) {
                    DBDPseudoAttribute[] dBDPseudoAttributeArray = pseudoAttributes;
                    int n = pseudoAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDPseudoAttribute pa = dBDPseudoAttributeArray[n2];
                        String attrId = pa.getAlias();
                        if (CommonUtils.isEmpty((String)attrId)) {
                            attrId = pa.getName();
                        }
                        if (attrId.equals(attrName)) {
                            return pa;
                        }
                        ++n2;
                    }
                }
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isPseudoAttribute(DBSAttributeBase attr) {
        void ab;
        void var2_1;
        DBDAttributeBinding dBDAttributeBinding;
        DBSAttributeBase dBSAttributeBase = attr;
        return dBSAttributeBase instanceof DBDAttributeBinding && (dBDAttributeBinding = (DBDAttributeBinding)dBSAttributeBase) == (DBDAttributeBinding)var2_1 && ab.isPseudoAttribute();
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparator() {
        return Comparator.comparing(DBPNamedObject::getName);
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparatorIgnoreCase() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public static Comparator<? super DBSAttributeBase> orderComparator() {
        return Comparator.comparingInt(DBSAttributeBase::getOrdinalPosition);
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull Collection<T> objects) {
        ArrayList<T> ordered = new ArrayList<T>(objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull T[] objects) {
        ArrayList ordered = new ArrayList();
        Collections.addAll(ordered, objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> void orderObjects(@NotNull List<T> objects) {
        objects.sort((o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1 == null && name2 == null ? 0 : (name1 == null ? -1 : (name2 == null ? 1 : name1.compareTo(name2)));
        });
    }

    public static String getClientApplicationName(@NotNull DBPDataSourceContainer container, @Nullable DBCExecutionContext context, @Nullable String purpose) {
        return DBUtils.getClientApplicationName(container, context, purpose, true);
    }

    public static String getClientApplicationName(@NotNull DBPDataSourceContainer container, @Nullable DBCExecutionContext context, @Nullable String purpose, boolean addVersion) {
        if (container.getPreferenceStore().getBoolean("database.meta.client.name.override")) {
            String appName = container.getPreferenceStore().getString("database.meta.client.name.value");
            IVariableResolver cVarResolver = container.getVariablesResolver(false);
            return GeneralUtils.replaceVariables(appName, name -> switch (name) {
                case "context.name" -> {
                    if (context == null) {
                        yield null;
                    }
                    yield context.getContextName();
                }
                case "context.id" -> {
                    if (context == null) {
                        yield null;
                    }
                    yield String.valueOf(context.getContextId());
                }
                default -> cVarResolver.get(name);
            });
        }
        String productTitle = addVersion ? GeneralUtils.getProductTitle() : GeneralUtils.getProductName();
        return purpose == null ? productTitle : String.valueOf(productTitle) + " - " + purpose;
    }

    public static DBSInstance getObjectOwnerInstance(DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject p = object;
        while (p != null) {
            if (p instanceof DBSInstance) {
                return (DBSInstance)p;
            }
            p = p.getParentObject();
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null ? null : dataSource.getDefaultInstance();
    }

    /*
     * WARNING - void declaration
     */
    public static DBCExecutionContext getDefaultContext(DBSObject object, boolean meta) {
        void instanceLazy;
        DBSInstanceLazy dBSInstanceLazy;
        DBSInstance dBSInstance;
        if (object == null) {
            return null;
        }
        DBSInstance instance = DBUtils.getObjectOwnerInstance(object);
        return instance == null || (dBSInstance = instance) instanceof DBSInstanceLazy && (dBSInstanceLazy = (DBSInstanceLazy)dBSInstance) == (DBSInstanceLazy)dBSInstance && !instanceLazy.isInstanceConnected() ? null : instance.getDefaultContext(new VoidProgressMonitor(), meta);
    }

    /*
     * WARNING - void declaration
     */
    public static DBCExecutionContext getOrOpenDefaultContext(DBSObject object, boolean meta) throws DBCException {
        void instanceLazy;
        DBSInstanceLazy dBSInstanceLazy;
        DBSInstance ownerInstance;
        DBSInstance dBSInstance;
        DBCExecutionContext context = DBUtils.getDefaultContext(object, meta);
        if (context == null && (dBSInstance = (ownerInstance = DBUtils.getObjectOwnerInstance(object))) instanceof DBSInstanceLazy && (dBSInstanceLazy = (DBSInstanceLazy)dBSInstance) == (DBSInstanceLazy)dBSInstance && !instanceLazy.isInstanceConnected()) {
            if (!RuntimeUtils.runTask(arg_0 -> DBUtils.lambda$5((DBSInstanceLazy)instanceLazy, arg_0), "Initiate instance connection", object.getDataSource().getContainer().getPreferenceStore().getInt("connection.open.timeout"))) {
                throw new DBCException("Timeout while opening database connection");
            }
            context = DBUtils.getDefaultContext(object, meta);
        }
        return context;
    }

    public static List<DBPDataSourceRegistry> getAllRegistries(boolean forceLoad) {
        ArrayList<DBPDataSourceRegistry> result = new ArrayList<DBPDataSourceRegistry>();
        for (DBPProject dBPProject : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            if (!forceLoad && (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded())) continue;
            dBPProject.ensureOpen();
            DBPDataSourceRegistry registry = dBPProject.getDataSourceRegistry();
            if (registry == null) continue;
            result.add(registry);
        }
        return result;
    }

    @Deprecated
    public static DBPDataSourceContainer findDataSource(String dataSourceId) {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject dBPProject : workspace.getProjects()) {
            DBPDataSourceContainer dataSourceContainer;
            DBPDataSourceRegistry dataSourceRegistry = dBPProject.getDataSourceRegistry();
            if (dataSourceRegistry == null || (dataSourceContainer = dataSourceRegistry.getDataSource(dataSourceId)) == null) continue;
            return dataSourceContainer;
        }
        return null;
    }

    public static DBPDataSourceContainer findDataSource(String projectName, String dataSourceId) {
        DBPProject project = null;
        if (!CommonUtils.isEmpty((String)projectName)) {
            project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        }
        if (project != null) {
            return project.getDataSourceRegistry().getDataSource(dataSourceId);
        }
        return DBUtils.findDataSource(dataSourceId);
    }

    public static int compareDataValues(Object cell1, Object cell2) {
        if (cell1 == cell2 || DBUtils.isNullValue(cell1) && DBUtils.isNullValue(cell2)) {
            return 0;
        }
        if (DBUtils.isNullValue(cell1)) {
            return 1;
        }
        if (DBUtils.isNullValue(cell2)) {
            return -1;
        }
        if (cell1 instanceof Number && cell2 instanceof Number) {
            return CommonUtils.compareNumbers((Number)((Number)cell1), (Number)((Number)cell2));
        }
        if (cell1 instanceof Comparable && cell1.getClass() == cell2.getClass()) {
            return ((Comparable)cell1).compareTo(cell2);
        }
        if (cell1 instanceof Number) {
            Object num2 = GeneralUtils.convertString(String.valueOf(cell2), cell1.getClass());
            if (num2 == null) {
                return -1;
            }
            if (num2 instanceof Number) {
                return CommonUtils.compareNumbers((Number)((Number)cell1), (Number)((Number)num2));
            }
        } else if (cell2 instanceof Number) {
            Object num1 = GeneralUtils.convertString(String.valueOf(cell1), cell2.getClass());
            if (num1 == null) {
                return 1;
            }
            if (num1 instanceof Number) {
                return CommonUtils.compareNumbers((Number)((Number)num1), (Number)((Number)cell2));
            }
        }
        String str1 = String.valueOf(cell1);
        String str2 = String.valueOf(cell2);
        return str1.compareTo(str2);
    }

    public static DBSEntity getEntityFromMetaData(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBCEntityMetaData entityMeta) throws DBException {
        DBSObjectContainer objectContainer = DBUtils.getAdapter(DBSObjectContainer.class, executionContext.getDataSource());
        if (objectContainer != null) {
            DBSEntity entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, false);
            if (entity == null) {
                entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, true);
            }
            return entity;
        }
        return null;
    }

    public static DBSEntity getEntityFromMetaData(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer objectContainer, DBCEntityMetaData entityMeta, boolean transformName) throws DBException {
        DBPDataSource dataSource = objectContainer.getDataSource();
        String catalogName = entityMeta.getCatalogName();
        String schemaName = entityMeta.getSchemaName();
        String entityName = entityMeta.getEntityName();
        if (transformName) {
            catalogName = DBObjectNameCaseTransformer.transformName(dataSource, catalogName);
            schemaName = DBObjectNameCaseTransformer.transformName(dataSource, schemaName);
            entityName = DBObjectNameCaseTransformer.transformName(dataSource, entityName);
        }
        if (CommonUtils.isEmpty((String)entityName)) {
            return null;
        }
        DBSObject entityObject = DBUtils.getObjectByPath(monitor, executionContext, objectContainer, catalogName, schemaName, entityName);
        if (entityObject instanceof DBSAlias && !(entityObject instanceof DBSEntity)) {
            entityObject = ((DBSAlias)entityObject).getTargetObject(monitor);
        }
        if (entityObject == null) {
            return null;
        }
        if (entityObject instanceof DBSEntity) {
            return (DBSEntity)entityObject;
        }
        log.debug("Unsupported table class: " + entityObject.getClass().getName());
        return null;
    }

    public static DBSEntityConstraint getConstraint(DBRProgressMonitor monitor, DBSEntity dbsEntity, DBSAttributeBase attribute) throws DBException {
        for (DBSEntityConstraint constraint : CommonUtils.safeCollection(dbsEntity.getConstraints(monitor))) {
            DBSEntityAttributeRef constraintAttribute = DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)constraint, attribute.getName());
            if (constraintAttribute == null || constraintAttribute.getAttribute() != attribute) continue;
            return constraint;
        }
        return null;
    }

    public static boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || !dataSource.getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA) || dataSource.getInfo().isReadOnlyMetaData();
    }

    public static <T> T createNewAttributeValue(final DBCExecutionContext context, final DBDValueHandler valueHandler, final DBSTypedObject valueType, Class<T> targetType) throws DBCException {
        DBRRunnableWithResult<Object> runnable = new DBRRunnableWithResult<Object>(){

            @Override
            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Create new object");){
                        this.result = valueHandler.createNewValueObject(session, valueType);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBCException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            DBWorkbench.getPlatformUI().executeWithProgress(runnable);
        }
        catch (InvocationTargetException e) {
            throw new DBCException(e.getTargetException(), context);
        }
        catch (InterruptedException e) {
            throw new DBCException((Throwable)e, context);
        }
        Object result = runnable.getResult();
        if (result == null) {
            throw new DBCException("Internal error - null object created");
        }
        if (!targetType.isInstance(result)) {
            throw new DBCException("Internal error - wrong object type '" + result.getClass().getName() + "' while '" + targetType.getName() + "' was expected");
        }
        return targetType.cast(result);
    }

    public static boolean isView(DBSEntity table) {
        return table instanceof DBSView || table instanceof DBSTable && ((DBSTable)table).isView();
    }

    public static String getEntityScriptName(DBSEntity entity, Map<String, Object> options) {
        return CommonUtils.getOption(options, (String)"useFQN", (boolean)true) && entity instanceof DBPQualifiedObject ? ((DBPQualifiedObject)((Object)entity)).getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(entity);
    }

    public static String getObjectTypeName(DBSObject object) {
        DBSObjectType[] objectTypes;
        DBSObjectType objectType;
        if (object instanceof DBSObjectWithType && (objectType = ((DBSObjectWithType)((Object)object)).getObjectType()) != null) {
            return objectType.getTypeName();
        }
        DBSObjectType[] dBSObjectTypeArray = objectTypes = object.getDataSource().getInfo().getSupportedObjectTypes();
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType ot = dBSObjectTypeArray[n2];
            Class<? extends DBSObject> typeClass = ot.getTypeClass();
            if (typeClass != null && typeClass != DBSObject.class && typeClass.isInstance(object)) {
                return ot.getTypeName();
            }
            ++n2;
        }
        return "Object";
    }

    @Nullable
    public static DBSDataType getDataType(@NotNull DBSTypedObject typedObject) {
        if (typedObject instanceof DBSDataType) {
            return (DBSDataType)typedObject;
        }
        if (typedObject instanceof DBSTypedObjectEx) {
            return ((DBSTypedObjectEx)((Object)typedObject)).getDataType();
        }
        return null;
    }

    @NotNull
    public static Pair<String, String[]> getTypeModifiers(@NotNull String type) throws DBException {
        int modEndIndex;
        int modStartIndex = type.indexOf(40);
        if (modStartIndex < 0 ^ (modEndIndex = type.indexOf(41)) < 0) {
            throw new DBException("Type '" + type + "' has malformed modifiers");
        }
        if (modStartIndex < 0) {
            return new Pair((Object)type, (Object)new String[0]);
        }
        String name = (String.valueOf(type.substring(0, modStartIndex)) + type.substring(modEndIndex + 1)).trim();
        if (name.isEmpty()) {
            throw new DBException("Type name is missing");
        }
        String mod = type.substring(modStartIndex + 1, modEndIndex).trim();
        if (mod.isEmpty()) {
            throw new DBException("Type with zero modifiers is not allowed");
        }
        String[] mods = mod.split(",");
        int i = 0;
        while (i < mods.length) {
            mods[i] = mods[i].trim();
            if (mods[i].isEmpty()) {
                throw new DBException("Type has empty modifiers");
            }
            ++i;
        }
        return new Pair((Object)name, (Object)mods);
    }

    @NotNull
    public static <PARENT extends DBSObject, CHILD extends DBSObject> String makeNewObjectName(@NotNull DBRProgressMonitor monitor, @NotNull String template, @NotNull PARENT parent, @NotNull Class<? extends CHILD> type, @NotNull ChildExtractor<PARENT, CHILD> extractor, @NotNull DBECommandContext context) {
        int suffix = 1;
        while (true) {
            String name = Objects.requireNonNull(DBObjectNameCaseTransformer.transformName(parent.getDataSource(), NLS.bind((String)template, (Object)suffix)));
            try {
                boolean exists;
                boolean bl = exists = extractor.extract(parent, monitor, name) != null;
                if (!exists) {
                    for (DBPObject object : context.getEditedObjects()) {
                        if (!type.isInstance(object) || ((DBSObject)object).getParentObject() != parent || !name.equalsIgnoreCase(((DBSObject)object).getName())) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    return name;
                }
            }
            catch (DBException e) {
                log.warn(e);
                return name;
            }
            ++suffix;
        }
    }

    public static List<DBSDataContainer> getAllDataContainersFromParentContainer(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject parent) throws DBException {
        List<DBSDataContainer> containers;
        DBPDataSource dataSource;
        ArrayList<DBSDataContainer> result = new ArrayList<DBSDataContainer>();
        if (parent instanceof DBSDataContainer) {
            result.add((DBSDataContainer)parent);
        } else if (parent instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)parent;
            Class<? extends DBSObject> primaryChildType = container.getPrimaryChildType(monitor);
            if (DBSDataContainer.class.isAssignableFrom(primaryChildType)) {
                Collection<? extends DBSObject> children = container.getChildren(monitor);
                if (!CommonUtils.isEmpty(children)) {
                    for (DBSObject dBSObject : children) {
                        if (!(dBSObject instanceof DBSDataContainer)) continue;
                        result.add((DBSDataContainer)dBSObject);
                    }
                }
            } else if (DBSObjectContainer.class.isAssignableFrom(primaryChildType)) {
                Collection<? extends DBSObject> children = container.getChildren(monitor);
                for (DBSObject dBSObject : children) {
                    Collection<? extends DBSObject> dbsObjects = ((DBSObjectContainer)dBSObject).getChildren(monitor);
                    for (DBSObject dBSObject2 : dbsObjects) {
                        if (!(dBSObject2 instanceof DBSDataContainer)) continue;
                        result.add((DBSDataContainer)dBSObject2);
                    }
                }
            }
        } else if (parent instanceof DBNDatabaseFolder) {
            Collection<DBSObject> dbsObjects = ((DBNDatabaseFolder)parent).getChildrenObjects(monitor);
            for (DBSObject dbsObject : dbsObjects) {
                List<DBSDataContainer> list = DBUtils.getAllDataContainersFromParentContainer(monitor, dbsObject);
                if (CommonUtils.isEmpty(list)) continue;
                result.addAll(list);
            }
        } else if (parent instanceof DBPDataSourceContainer && (dataSource = ((DBPDataSourceContainer)parent).getDataSource()) instanceof DBSObjectContainer && !CommonUtils.isEmpty(containers = DBUtils.getAllDataContainersFromParentContainer(monitor, dataSource))) {
            result.addAll(containers);
        }
        return result;
    }

    public static boolean initDataSource(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @Nullable DBRProgressListener onFinish) throws DBException {
        if (!dataSource.isConnected()) {
            DBServiceConnections serviceConnections = DBWorkbench.getService(DBServiceConnections.class);
            if (serviceConnections != null) {
                serviceConnections.initConnection(monitor, dataSource, onFinish);
            }
        } else if (onFinish != null) {
            onFinish.onTaskFinished(Status.OK_STATUS);
        }
        return dataSource.isConnected();
    }

    public static long readRowCount(@NotNull DBRProgressMonitor monitor, @Nullable DBCExecutionContext executionContext, @Nullable DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter, @NotNull Object controller) throws DBException {
        if (executionContext == null || dataContainer == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        long[] result = new long[1];
        DBExecUtils.tryExecuteRecover(monitor, executionContext.getDataSource(), param -> {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.USER, "Read total row count");){
                    long rowCount;
                    lArray[0] = rowCount = dataContainer.countData(new AbstractExecutionSource(dataContainer, executionContext, controller), session, dataFilter, 0L);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                throw new InvocationTargetException(e);
            }
        });
        return result[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long countDataFromQuery(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull SQLQuery query) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCStatement dbStatement = DBUtils.makeStatement(source, session, DBCStatementType.SCRIPT, query, 0L, 0L);){
            if (!dbStatement.executeStatement()) throw new DBCException("Row count query didn't return any value");
            Throwable throwable2 = null;
            Object var7_10 = null;
            try {
                Object countValue;
                block20: {
                    long l;
                    DBCResultSet rs = dbStatement.openResultSet();
                    try {
                        Object singleValue;
                        if (!rs.nextRow()) throw new DBCException("Row count result is empty");
                        List<DBCAttributeMetaData> resultAttrs = rs.getMeta().getAttributes();
                        countValue = null;
                        if (resultAttrs.size() == 1) {
                            countValue = rs.getAttributeValue(0);
                        } else {
                            int i = 0;
                            while (i < resultAttrs.size()) {
                                DBCAttributeMetaData ma = resultAttrs.get(i);
                                if (ma.getName().toLowerCase(Locale.ENGLISH).contains("count")) {
                                    countValue = rs.getAttributeValue(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (countValue instanceof Map && ((Map)countValue).size() == 1 && (singleValue = ((Map)countValue).values().iterator().next()) instanceof Number) {
                            countValue = singleValue;
                        }
                        if (!(countValue instanceof Number)) break block20;
                        l = ((Number)countValue).longValue();
                        if (rs == null) return l;
                    }
                    catch (Throwable throwable3) {
                        if (rs == null) throw throwable3;
                        rs.close();
                        throw throwable3;
                    }
                    rs.close();
                    return l;
                }
                throw new DBCException("Unexpected row count value: " + countValue);
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                }
                if (throwable2 == throwable4) throw throwable2;
                throwable2.addSuppressed(throwable4);
                throw throwable2;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$5(DBSInstanceLazy dBSInstanceLazy, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            dBSInstanceLazy.checkInstanceConnection(monitor);
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static interface ChildExtractor<PARENT, CHILD> {
        @Nullable
        public CHILD extract(@NotNull PARENT var1, @NotNull DBRProgressMonitor var2, @NotNull String var3) throws DBException;
    }
}

