/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.subscription.fluent.AliasClient;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasListResultInner;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasResponseInner;
import com.azure.resourcemanager.subscription.implementation.SubscriptionClientImpl;
import com.azure.resourcemanager.subscription.models.PutAliasRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AliasClientImpl
implements AliasClient {
    private final AliasService service;
    private final SubscriptionClientImpl client;

    AliasClientImpl(SubscriptionClientImpl client) {
        this.service = (AliasService)RestProxy.create(AliasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String aliasName, PutAliasRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), aliasName, "2020-09-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String aliasName, PutAliasRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), aliasName, "2020-09-01", body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PutAliasResponseInner>, PutAliasResponseInner> beginCreateAsync(String aliasName, PutAliasRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(aliasName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PutAliasResponseInner.class), (Type)((Object)PutAliasResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PutAliasResponseInner>, PutAliasResponseInner> beginCreateAsync(String aliasName, PutAliasRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(aliasName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PutAliasResponseInner.class), (Type)((Object)PutAliasResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PutAliasResponseInner>, PutAliasResponseInner> beginCreate(String aliasName, PutAliasRequest body) {
        return this.beginCreateAsync(aliasName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PutAliasResponseInner>, PutAliasResponseInner> beginCreate(String aliasName, PutAliasRequest body, Context context) {
        return this.beginCreateAsync(aliasName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PutAliasResponseInner> createAsync(String aliasName, PutAliasRequest body) {
        return this.beginCreateAsync(aliasName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PutAliasResponseInner> createAsync(String aliasName, PutAliasRequest body, Context context) {
        return this.beginCreateAsync(aliasName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PutAliasResponseInner create(String aliasName, PutAliasRequest body) {
        return (PutAliasResponseInner)((Object)this.createAsync(aliasName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PutAliasResponseInner create(String aliasName, PutAliasRequest body, Context context) {
        return (PutAliasResponseInner)((Object)this.createAsync(aliasName, body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PutAliasResponseInner>> getWithResponseAsync(String aliasName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), aliasName, "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PutAliasResponseInner>> getWithResponseAsync(String aliasName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), aliasName, "2020-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PutAliasResponseInner> getAsync(String aliasName) {
        return this.getWithResponseAsync(aliasName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PutAliasResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PutAliasResponseInner> getWithResponse(String aliasName, Context context) {
        return (Response)this.getWithResponseAsync(aliasName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PutAliasResponseInner get(String aliasName) {
        return (PutAliasResponseInner)((Object)this.getWithResponse(aliasName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String aliasName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), aliasName, "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String aliasName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (aliasName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aliasName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), aliasName, "2020-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String aliasName) {
        return this.deleteWithResponseAsync(aliasName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String aliasName, Context context) {
        return (Response)this.deleteWithResponseAsync(aliasName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String aliasName) {
        this.deleteWithResponse(aliasName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PutAliasListResultInner>> listWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PutAliasListResultInner>> listWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2020-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PutAliasListResultInner> listAsync() {
        return this.listWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((PutAliasListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PutAliasListResultInner> listWithResponse(Context context) {
        return (Response)this.listWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PutAliasListResultInner list() {
        return (PutAliasListResultInner)this.listWithResponse(Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SubscriptionClientAl")
    public static interface AliasService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Subscription/aliases/{aliasName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="aliasName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PutAliasRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Subscription/aliases/{aliasName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PutAliasResponseInner>> get(@HostParam(value="$host") String var1, @PathParam(value="aliasName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Subscription/aliases/{aliasName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="aliasName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Subscription/aliases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PutAliasListResultInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

