/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jalgapi.AlgDH;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapSecretKey;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.ietf.jgss.GSSException;

public final class LdapDH
implements AlgDH {
    private final TdgssLogger logger;
    private BigInteger pG;
    private BigInteger pN;
    private BigInteger PrivateKey;
    private static int DH_KEY_SIZE;
    private static final int BYTESININT = 4;

    public LdapDH(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
    }

    @Override
    public byte[] GenerateParameters(int n, byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            if (n == 1) {
                DH_KEY_SIZE = byArray2.length;
                this.pG = new BigInteger(1, byArray);
                this.pN = new BigInteger(1, byArray2);
                return null;
            }
            DH_KEY_SIZE = 64;
            this.pG = BigInteger.valueOf(2L);
            byte[] byArray3 = new byte[]{-17, 101, 68, -8, -128, -112, 124, 43, -60, -104, 125, -83, -21, 119, 8, -31, -117, 74, 90, -90, -27, 30, -70, 56, 108, -79, 1, 38, 37, 121, -109, -71, -71, 100, -91, -1, -88, 59, -96, -58, -16, -113, 109, 56, 23, 88, 19, -116, -115, 102, 89, 110, -8, 99, 110, 67, -110, -109, -111, 89, 102, -50, 107, -117};
            this.pN = new BigInteger(1, byArray3);
            return null;
        }
        catch (Exception exception) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_DH_PARAM_GEN_FAILURE, exception);
        }
    }

    @Override
    public void SetDHParameters(byte[] byArray) throws GSSException {
        try {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            BigInteger bigInteger = new BigInteger(byArray2);
            int n = bigInteger.intValue();
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 4, byArray3, 0, n);
            System.arraycopy(byArray, 4 + n, byArray2, 0, 4);
            bigInteger = new BigInteger(byArray2);
            int n2 = bigInteger.intValue();
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray, 8 + n, byArray4, 0, n2);
            this.pG = new BigInteger(1, byArray4);
            this.pN = new BigInteger(1, byArray3);
        }
        catch (Exception exception) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_DH_PARAM_SET_FAILURE, exception);
        }
    }

    @Override
    public byte[] GenerateKey() throws GSSException {
        BigInteger bigInteger;
        byte[] byArray = null;
        SecureRandom secureRandom = new SecureRandom();
        while ((bigInteger = new BigInteger(512, secureRandom)).compareTo(BigInteger.ZERO) != 1 || bigInteger.compareTo(this.pN.subtract(BigInteger.ONE)) != -1) {
        }
        BigInteger bigInteger2 = this.pG.modPow(bigInteger, this.pN);
        this.PrivateKey = bigInteger;
        byArray = this.NormalizeKey(bigInteger2);
        return byArray;
    }

    @Override
    public byte[] ComputeKey(byte[] byArray) throws GSSException {
        byte[] byArray2 = null;
        try {
            BigInteger bigInteger;
            BigInteger bigInteger2 = bigInteger = new BigInteger(1, byArray);
            bigInteger2 = bigInteger2.modPow(this.PrivateKey, this.pN);
            byArray2 = this.NormalizeKeyTemp(bigInteger2);
        }
        catch (Exception exception) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_DH_KEY_COMP_FAILURE, exception);
        }
        return byArray2;
    }

    public byte[] NormalizeKey(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("normalize_key :outbuf = " + byArray.length, byArray));
        }
        if (byArray.length != DH_KEY_SIZE) {
            if (byArray.length > DH_KEY_SIZE) {
                byte[] byArray2 = new byte[DH_KEY_SIZE];
                System.arraycopy(byArray, byArray.length - DH_KEY_SIZE, byArray2, 0, DH_KEY_SIZE);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("", byArray2));
                }
                return byArray2;
            }
            byte[] byArray3 = new byte[DH_KEY_SIZE];
            int n = DH_KEY_SIZE - byArray.length;
            for (int i = 0; i < n; ++i) {
                byArray3[i] = 0;
            }
            System.arraycopy(byArray, 0, byArray3, n, byArray.length);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("", byArray3));
            }
            return byArray3;
        }
        return byArray;
    }

    public byte[] NormalizeKeyTemp(BigInteger bigInteger) {
        int n = 0;
        byte[] byArray = bigInteger.toByteArray();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("normalize_key_temp: outbuf = " + byArray.length, byArray));
        }
        if (byArray.length > DH_KEY_SIZE) {
            byte[] byArray2 = new byte[DH_KEY_SIZE];
            System.arraycopy(byArray, byArray.length - DH_KEY_SIZE, byArray2, 0, DH_KEY_SIZE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("", byArray2));
            }
            return byArray2;
        }
        if (byArray[0] == 0) {
            for (int i = 0; i < byArray.length && byArray[i] == 0; ++i) {
                ++n;
            }
            byte[] byArray3 = new byte[DH_KEY_SIZE];
            for (int i = 0; i < byArray3.length; ++i) {
                byArray3[i] = 0;
            }
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("", byArray3));
            }
            return byArray3;
        }
        if (byArray.length < DH_KEY_SIZE) {
            byte[] byArray4 = new byte[DH_KEY_SIZE];
            for (int i = 0; i < byArray4.length; ++i) {
                byArray4[i] = 0;
            }
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            return byArray4;
        }
        return byArray;
    }

    @Override
    public SecretKey BytetoKey(String string, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        LdapSecretKey ldapSecretKey = new LdapSecretKey(string, byArray2);
        return ldapSecretKey;
    }

    public byte[] NormalizeLength(int n) {
        Integer n2 = new Integer(n);
        BigInteger bigInteger = new BigInteger(n2.toString());
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            int n3 = byArray.length;
            for (int i = 4; i > 0; --i) {
                if (--n3 >= 0) {
                    byArray2[i] = byArray[n3];
                    continue;
                }
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }
}

