/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RawResultSetMetaData
implements ResultSetMetaData {
    private RawPreparedStatement pstmt = null;
    private int numberOfColumns = 1;
    public static final String COLUMN_NAME = "RawMessage";

    public RawResultSetMetaData(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    protected void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.numberOfColumns) {
            throw ErrorFactory.makeDriverJDBCException("TJ599", n);
        }
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "[B";
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.pstmt.abortIfClosed();
        return this.numberOfColumns;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return this.pstmt.con.getMaxMessageSize(false, true);
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return COLUMN_NAME;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return COLUMN_NAME;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return -3;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "VARBYTE";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return true;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

