/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.fastexport.FastExportConnection;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.RequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class FastExportPreparedStatement
implements PreparedStatement {
    private FastExportConnection con = null;
    private boolean noSpoolEnabled = false;
    private Results results = null;
    private int resultsIndex = -1;
    private Object workingMetadata = null;
    private boolean m_bStatementBlockCountNumberSpecified = false;
    private long statementBlockCount = 0L;
    private int statementNumber = 0;
    private boolean m_bIsClosed = false;

    public FastExportPreparedStatement(FastExportConnection fastExportConnection) throws SQLException {
        this.con = fastExportConnection;
        this.results = new Results(fastExportConnection.getLog());
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n, int n2) throws SQLException {
        if (n != n2) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initReq(TDPacket tDPacket) throws SQLException {
        RequestParcel requestParcel = new RequestParcel(this.con);
        byte[] byArray = new byte[this.noSpoolEnabled ? 4 : 8];
        if (this.noSpoolEnabled) {
            ByteConverter.putInt(byArray, 0, this.statementNumber);
        } else {
            ByteConverter.putLong(byArray, 0, this.statementBlockCount);
        }
        requestParcel.setRequestText(byArray);
        tDPacket.addParcel(requestParcel);
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        BigResponseParcel bigResponseParcel = new BigResponseParcel(this.con);
        bigResponseParcel.setMaxMsgSize(this.con.getMaxMessageSize(false, false));
        tDPacket.addParcel(bigResponseParcel);
    }

    protected void requestResults() throws SQLException {
        TDPacket tDPacket = this.con.createPacket(1);
        this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
        this.initReq(tDPacket);
        this.initResp(tDPacket);
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.con.getIO());
    }

    protected void receiveResults(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = null;
        try {
            tDNetworkIOIF = this.con.getIO();
            tDNetworkIOIF.acquireReadLock();
            tDPacket.getBuffer().readStream(tDNetworkIOIF);
        }
        finally {
            if (tDNetworkIOIF != null) {
                tDNetworkIOIF.releaseReadLock();
            }
        }
        tDPacket.initParcelFactory(this.con);
    }

    protected void deserializeResults(TDPacket tDPacket) throws SQLException {
        TeraResultSetMetaData teraResultSetMetaData = (TeraResultSetMetaData)this.workingMetadata;
        TDResultSet tDResultSet = null;
        ResultSetRow resultSetRow = null;
        Parcel parcel = null;
        block9: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                this.con.getLog().error("Did not receive an expected parcel from the database!");
                throw ErrorFactory.makeIoJDBCException("TJ420", "FastExportPreparedStatement.receiveResults", this.con.getIO(), null, this.con.getLog());
            }
            this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
            switch (parcel.getFlavor()) {
                case 8: {
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    tDPacket.setParcelFactoryPrepInfo(teraResultSetMetaData.getPrepInfoParcel());
                    if (this.resultsIndex < 0) {
                        tDResultSet = this.con.constructResultSet(teraResultSetMetaData, 1, this, null, this.con.getLog());
                        tDResultSet.setActivityCount(successParcel.getActivityCount() < 0L ? 0x7FFFFFFEL : successParcel.getActivityCount());
                        break;
                    }
                    tDResultSet = this.results.getResult(this.resultsIndex).getResultSet();
                    break;
                }
                case 10: {
                    if (tDResultSet.isClosed()) continue block9;
                    RecordParcel recordParcel = (RecordParcel)parcel;
                    if (resultSetRow == null) {
                        resultSetRow = new ResultSetRow();
                    }
                    int n = 1;
                    ReceiveRecordSubState.SlobMapping slobMapping = new ReceiveRecordSubState.SlobMapping();
                    RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
                    while (recordParcelColumnValuesIterator.hasNext()) {
                        if (n <= teraResultSetMetaData.getColumnCount() && teraResultSetMetaData.getColumnProperties(n).isStruct()) {
                            resultSetRow.addValue(ReceiveRecordSubState.deserializeStructValue(recordParcelColumnValuesIterator, teraResultSetMetaData.getColumnProperties(n), this.con, slobMapping));
                        } else {
                            resultSetRow.addValue(slobMapping.processColumn(recordParcelColumnValuesIterator.next(), teraResultSetMetaData.getColumnProperties(n).getMetadataItemNumber()));
                        }
                        ++n;
                    }
                    tDResultSet.addResultSetRow(resultSetRow);
                    resultSetRow = null;
                    break;
                }
                case 144: {
                    if (tDResultSet.isClosed()) continue block9;
                    MultiPartRecordParcel multiPartRecordParcel = (MultiPartRecordParcel)parcel;
                    if (resultSetRow == null) {
                        resultSetRow = new ResultSetRow();
                    }
                    int n = 1;
                    ReceiveRecordSubState.SlobMapping slobMapping = new ReceiveRecordSubState.SlobMapping();
                    RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = multiPartRecordParcel.getRecordParcelColumnValuesIterator();
                    while (true) {
                        if (!recordParcelColumnValuesIterator.hasNext()) continue block9;
                        if (n <= teraResultSetMetaData.getColumnCount() && teraResultSetMetaData.getColumnProperties(n).isStruct()) {
                            resultSetRow.addValue(ReceiveRecordSubState.deserializeStructValue(recordParcelColumnValuesIterator, teraResultSetMetaData.getColumnProperties(n), this.con, slobMapping));
                        } else {
                            resultSetRow.addValue(slobMapping.processColumn(recordParcelColumnValuesIterator.next(), teraResultSetMetaData.getColumnProperties(n).getMetadataItemNumber()));
                        }
                        ++n;
                    }
                }
                case 145: {
                    if (tDResultSet.isClosed()) continue block9;
                    EndMultiPartRecordParcel endMultiPartRecordParcel = (EndMultiPartRecordParcel)parcel;
                    tDResultSet.addResultSetRow(resultSetRow);
                    resultSetRow = null;
                    break;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
                case 12: {
                    if (this.resultsIndex < 0) {
                        tDResultSet.lastRowFetched();
                        this.results.addResult(null, new Result(tDResultSet));
                    }
                    tDPacket.setParcelFactoryPrepInfo(null);
                    return;
                }
                default: {
                    this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                    throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
                }
            }
        }
    }

    protected void shareResults(Results results, int n) {
        this.results = results;
        this.resultsIndex = n;
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        this.workingMetadata = null;
        this.m_bStatementBlockCountNumberSpecified = false;
        this.statementBlockCount = 0L;
        this.statementNumber = 0;
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Object object;
        this.abortIfClosed();
        if (this.workingMetadata == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ740");
        }
        SQLException sQLException = null;
        ResultSet resultSet = null;
        try {
            this.clearWarnings();
            this.results.reinit();
            if (!this.m_bStatementBlockCountNumberSpecified) {
                throw ErrorFactory.makeDriverJDBCException("TJ741");
            }
            object = this.con.createPacket(1);
            this.requestResults();
            this.receiveResults((TDPacket)object);
            this.deserializeResults((TDPacket)object);
            resultSet = this.getResultSet();
            if (resultSet == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ583");
            }
        }
        catch (SQLException sQLException2) {
            sQLException = FastExportPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ567");
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n, 2);
        this.m_bStatementBlockCountNumberSpecified = true;
        this.statementBlockCount = 0L;
        this.statementNumber = n2;
        this.noSpoolEnabled = true;
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n, 2);
        this.m_bStatementBlockCountNumberSpecified = true;
        this.statementBlockCount = l;
        this.statementNumber = 0;
        this.noSpoolEnabled = false;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n, 1);
        if (!(object instanceof TeraResultSetMetaData)) {
            throw ErrorFactory.makeDriverJDBCException("TJ738", String.valueOf(n), object == null ? "null" : object.getClass().getName());
        }
        this.workingMetadata = object;
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.m_bIsClosed = true;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            TDResultSet tDResultSet = this.results.getResult().getResultSet();
            return tDResultSet;
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_bIsClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

