/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class SignonExchangeAttributeRep
extends ClientAccessDataStream {
    SignonExchangeAttributeRep() {
    }

    public Object getNewDataStream() {
        return new SignonExchangeAttributeRep();
    }

    int getRC() {
        return this.get32bit(20);
    }

    int getServerVersion() {
        return this.get32bit(30);
    }

    int getServerLevel() {
        return this.get16bit(40);
    }

    byte[] getServerSeed() {
        int n = this.findCP(4355);
        if (n == -1) {
            return null;
        }
        byte[] byArray = new byte[8];
        System.arraycopy(this.data_, n + 6, byArray, 0, 8);
        return byArray;
    }

    boolean getPasswordLevel() {
        int n = this.findCP(4377);
        if (n == -1) {
            return false;
        }
        return this.data_[n + 6] >= 2;
    }

    byte[] getJobNameBytes() {
        int n = this.findCP(4383);
        if (n == -1) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.get32bit(n) - 10];
        System.arraycopy(this.data_, n + 10, byArray, 0, byArray.length);
        return byArray;
    }

    int findCP(int n) {
        for (int i = 42; i < this.data_.length - 1; i += this.get32bit(i)) {
            if (this.get16bit(i + 4) != n) continue;
            return i;
        }
        return -1;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving signon server exchange client/server attributes reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the signon server exchange client/server attributes reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 20);
        this.readAfterHeader(inputStream);
    }

    public int hashCode() {
        return 61443;
    }
}

