/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

final class SQLLongNVarchar
extends SQLDataBase {
    private int length_ = 0;
    private int maxLength_;
    private String value_;

    SQLLongNVarchar(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.value_ = "";
    }

    public Object clone() {
        return new SQLLongNVarchar(this.maxLength_, this.settings_);
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = convTable.byteArrayToString(byArray, n + 2, this.length_, bidiConversionProperties);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            byte[] byArray2 = convTable.stringToByteArray(this.value_, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(byArray2.length, byArray, n);
            if (byArray2.length > this.maxLength_) {
                this.maxLength_ = byArray2.length;
                JDError.throwSQLException((Object)this, "HY000");
            }
            System.arraycopy(byArray2, 0, byArray, n + 2, byArray2.length);
            if (this.maxLength_ > 256 && this.maxLength_ - byArray2.length > 16) {
                int n3 = n + 2 + this.maxLength_;
                for (int i = n + 2 + byArray2.length; i < n3; ++i) {
                    byArray[i] = 0;
                }
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        int n2;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof Boolean) {
            string = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            string = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            string = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar);
        } else if (object instanceof Date) {
            string = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            Clob clob = (Clob)object;
            string = clob.getSubString(1L, (int)clob.length());
        }
        if (string == null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.value_ = string;
        int n3 = this.value_.length();
        if (n3 > (n2 = this.maxLength_)) {
            this.value_ = this.value_.substring(0, n2);
            this.truncated_ = n3 - n2;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length();
    }

    public int getSQLType() {
        return 37;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "LONGNVARCHAR";
    }

    public int getMaximumPrecision() {
        return 32739;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 456;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -1;
    }

    public String getTypeName() {
        return "LONGVARCHAR";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.value_));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.value_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getString();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }
}

