/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageFile
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final DateFormat YYYYMMDD_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final int NO_FORMATTING = 0;
    public static final int RETURN_FORMATTING_CHARACTERS = 1;
    public static final int SUBSTITUTE_FORMATTING_CHARACTERS = 2;
    public static final int CCSID_OF_JOB = 0;
    private int helpTextFormatting_ = 0;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = null;
    private String name_ = null;
    private transient boolean connected_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String previousMessageId_ = null;
    public static final String NEXT = "*NEXT";
    public static final String FIRST = "*FIRST";
    private static final byte[] OPTION_MSGID = new byte[]{92, -44, -30, -57, -55, -60, 64, 64, 64, 64};
    private static final byte[] OPTION_NEXT = new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64};
    private static final byte[] OPTION_FIRST = new byte[]{92, -58, -55, -39, -30, -29, 64, 64, 64, 64};

    public MessageFile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object.");
        }
    }

    public MessageFile(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public MessageFile(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object, system: " + aS400 + " path: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGF");
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.path_ = string;
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageFile messageFile = this;
        synchronized (messageFile) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageFile messageFile = this;
        synchronized (messageFile) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public static String substituteFormattingCharacters(String string) {
        return MessageFile.substituteFormattingCharacters(string, false);
    }

    private static String substituteFormattingCharacters(String string, boolean bl) {
        String string2 = string;
        string2 = MessageFile.replaceText(string2, "&N", "\n");
        string2 = MessageFile.replaceText(string2, "&P", "\n      ");
        string2 = MessageFile.replaceText(string2, "&B", "\n    ");
        if (bl) {
            string2 = MessageFile.replaceText(string2, "N&", "\n");
            string2 = MessageFile.replaceText(string2, "P&", "\n      ");
            string2 = MessageFile.replaceText(string2, "B&", "\n    ");
        }
        return string2;
    }

    public int getHelpTextFormatting() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting help text formatting:", this.helpTextFormatting_);
        }
        return this.helpTextFormatting_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public AS400Message getMessage(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string);
        }
        return this.getMessage(string, null, 0, 0, 0);
    }

    public AS400Message getMessage(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", type:", n);
        }
        return this.getMessage(string, null, n, 0, 0);
    }

    public AS400Message getMessage(String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", substitutionText: " + string2);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (AS400BidiTransform.isBidiCcsid(this.system_.getCcsid())) {
            return this.getMessage(string, string2, AS400BidiTransform.getStringType(this.system_.getCcsid()));
        }
        return this.getMessage(string, string2, 0);
    }

    public AS400Message getMessage(String string, String string2, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", substitutionText: " + string2 + ", type:", n);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        return this.getMessage(string, string2 != null ? new Converter(this.system_.getCcsid(), this.system_).stringToByteArray(string2, n) : null, n, 0, 0);
    }

    public AS400Message getMessage(String string, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", substitutionText:", byArray);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (AS400BidiTransform.isBidiCcsid(this.system_.getCcsid())) {
            return this.getMessage(string, byArray, AS400BidiTransform.getStringType(this.system_.getCcsid()));
        }
        return this.getMessage(string, byArray, 0, 0, 0);
    }

    public AS400Message getMessage(String string, byte[] byArray, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", type:" + n + ", substitutionText:", byArray);
        }
        return this.getMessage(string, byArray, n, 0, 0);
    }

    public AS400Message getMessage(String string, byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        int n4;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + string + ", type:" + n + ", ccsidOfSubstitutionText:" + n2 + ", substitutionText:", byArray);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'ID' is null.");
            throw new NullPointerException("ID");
        }
        if (string.length() > 7) {
            Trace.log(2, "Length of parameter 'ID' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("ID (" + string + ")", 1);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_.length() == 0) {
            Trace.log(2, "Cannot connect to server before setting path.");
            throw new ExtendedIllegalStateException("path", 4);
        }
        this.connected_ = true;
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        byte[] byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(this.name_, byArray2, 0, 10, n);
        converter.stringToByteArray(this.library_, byArray2, 10, 10, n);
        byte[] byArray3 = OPTION_MSGID;
        if (string.equals(FIRST)) {
            byArray3 = OPTION_FIRST;
            string = "";
        } else if (string.equals(NEXT)) {
            if (this.previousMessageId_ == null) {
                byArray3 = OPTION_FIRST;
                string = "";
            } else {
                byArray3 = OPTION_NEXT;
                string = this.previousMessageId_;
            }
        }
        byte[] byArray4 = new byte[]{64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(string, byArray4, 0, 7);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[]{92, -43, -42, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{92, -24, -59, -30, 64, 64, 64, 64, 64, 64};
        byte[] byArray7 = byArray.length == 0 ? byArray5 : byArray6;
        byte[] byArray8 = this.helpTextFormatting_ == 0 ? byArray5 : byArray6;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(5120), new ProgramParameter(new byte[]{0, 0, 20, 0}), new ProgramParameter(new byte[]{-39, -29, -27, -44, -16, -12, -16, -16}), new ProgramParameter(byArray4), new ProgramParameter(byArray2), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(byArray.length)), new ProgramParameter(byArray7), new ProgramParameter(byArray8), new ProgramParameter(new byte[8]), new ProgramParameter(byArray3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(BinaryConverter.intToByteArray(n2))};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QMHRTVM.PGM", programParameterArray);
        programCall.suggestThreadsafe();
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList()[0]);
        }
        if (n3 == 0) {
            n4 = this.system_.getCcsid();
        } else {
            n4 = n3;
            converter = new Converter(n4, this.system_);
        }
        byte[] byArray9 = programParameterArray[0].getOutputData();
        string = converter.byteArrayToString(byArray9, 26, 7, n).trim();
        AS400Message aS400Message = null;
        if (string.length() > 0) {
            aS400Message = new AS400Message();
            aS400Message.setID(string);
            aS400Message.setSeverity(BinaryConverter.byteArrayToInt(byArray9, 8));
            String string2 = converter.byteArrayToString(byArray9, 200, 7, 0);
            String string3 = converter.byteArrayToString(byArray9, 212, 7, 0);
            Date date = this.convertDate(string2);
            Date date2 = this.convertDate(string3);
            aS400Message.setCreateDate(date);
            aS400Message.setModificationDate(date2);
            int n5 = BinaryConverter.byteArrayToInt(byArray9, 52);
            int n6 = BinaryConverter.byteArrayToInt(byArray9, 56);
            int n7 = BinaryConverter.byteArrayToInt(byArray9, 64);
            int n8 = BinaryConverter.byteArrayToInt(byArray9, 68);
            int n9 = BinaryConverter.byteArrayToInt(byArray9, 76);
            int n10 = BinaryConverter.byteArrayToInt(byArray9, 80);
            aS400Message.setDefaultReply(converter.byteArrayToString(byArray9, n5, n6, n));
            aS400Message.setText(converter.byteArrayToString(byArray9, n7, n8, n));
            String string4 = converter.byteArrayToString(byArray9, n9, n10, n);
            if (this.helpTextFormatting_ == 2) {
                string4 = MessageFile.substituteFormattingCharacters(string4, AS400BidiTransform.isBidiCcsid(n4));
            }
            aS400Message.setHelp(string4);
            this.previousMessageId_ = string;
        }
        return aS400Message;
    }

    private Date convertDate(String string) {
        Date date = null;
        String string2 = (string.charAt(0) == '0' ? "19" : "20") + string.substring(1);
        try {
            date = YYYYMMDD_FORMAT.parse(string2);
        }
        catch (ParseException parseException) {
            if (Trace.traceOn_) {
                Trace.log(2, "Invalid date " + string);
            }
            throw new IllegalArgumentException(parseException.toString());
        }
        return date;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private static String replaceText(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n >= 0) {
            if (n == 0) {
                string = string3 + string.substring(3);
            } else {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                stringBuffer.append(string3);
                stringBuffer.append(string.substring(n + 2));
                string = stringBuffer.toString();
            }
            n = string.indexOf(string2);
        }
        return string;
    }

    public void setHelpTextFormatting(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting help text formatting:", n);
        }
        if (n < 0 || n > 2) {
            Trace.log(2, "Value of parameter 'helpTextFormatting' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("helpTextFormatting (" + n + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.helpTextFormatting_ = n;
        } else {
            Integer n2 = new Integer(this.helpTextFormatting_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("helpTextFormatting", n2, n3);
            }
            this.helpTextFormatting_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("helpTextFormatting", n2, n3);
            }
        }
    }

    public void setPath(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGF");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string;
        } else {
            String string2 = this.path_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", string2, string3);
            }
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", string2, string3);
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }
}

