/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.DebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.ExpressionEvaluationOptions;
import com.azure.resourcemanager.resources.models.OnErrorDeployment;
import com.azure.resourcemanager.resources.models.ParametersLink;
import com.azure.resourcemanager.resources.models.TemplateLink;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class DeploymentProperties {
    @JsonProperty(value="template")
    private Object template;
    @JsonProperty(value="templateLink")
    private TemplateLink templateLink;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, DeploymentParameter> parameters;
    @JsonProperty(value="parametersLink")
    private ParametersLink parametersLink;
    @JsonProperty(value="mode", required=true)
    private DeploymentMode mode;
    @JsonProperty(value="debugSetting")
    private DebugSetting debugSetting;
    @JsonProperty(value="onErrorDeployment")
    private OnErrorDeployment onErrorDeployment;
    @JsonProperty(value="expressionEvaluationOptions")
    private ExpressionEvaluationOptions expressionEvaluationOptions;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentProperties.class);

    public Object template() {
        return this.template;
    }

    public DeploymentProperties withTemplate(Object template) {
        this.template = template;
        return this;
    }

    public TemplateLink templateLink() {
        return this.templateLink;
    }

    public DeploymentProperties withTemplateLink(TemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    public DeploymentProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ParametersLink parametersLink() {
        return this.parametersLink;
    }

    public DeploymentProperties withParametersLink(ParametersLink parametersLink) {
        this.parametersLink = parametersLink;
        return this;
    }

    public DeploymentMode mode() {
        return this.mode;
    }

    public DeploymentProperties withMode(DeploymentMode mode) {
        this.mode = mode;
        return this;
    }

    public DebugSetting debugSetting() {
        return this.debugSetting;
    }

    public DeploymentProperties withDebugSetting(DebugSetting debugSetting) {
        this.debugSetting = debugSetting;
        return this;
    }

    public OnErrorDeployment onErrorDeployment() {
        return this.onErrorDeployment;
    }

    public DeploymentProperties withOnErrorDeployment(OnErrorDeployment onErrorDeployment) {
        this.onErrorDeployment = onErrorDeployment;
        return this;
    }

    public ExpressionEvaluationOptions expressionEvaluationOptions() {
        return this.expressionEvaluationOptions;
    }

    public DeploymentProperties withExpressionEvaluationOptions(ExpressionEvaluationOptions expressionEvaluationOptions) {
        this.expressionEvaluationOptions = expressionEvaluationOptions;
        return this;
    }

    public void validate() {
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.parametersLink() != null) {
            this.parametersLink().validate();
        }
        if (this.mode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property mode in model DeploymentProperties"));
        }
        if (this.debugSetting() != null) {
            this.debugSetting().validate();
        }
        if (this.onErrorDeployment() != null) {
            this.onErrorDeployment().validate();
        }
        if (this.expressionEvaluationOptions() != null) {
            this.expressionEvaluationOptions().validate();
        }
    }
}

