/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.sqf;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheListReader;
import com.intersys.sqf.Address;
import com.intersys.sqf.Record;
import com.intersys.sqf.Sharder;
import com.intersys.sqf.Utl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;

public final class Master {
    private final CacheConnection m_conn;
    private final Address m_addr;
    private static final int maxhash = 2048;

    public Master(CacheConnection c, String h, int p, String n, String u, String z) {
        this.m_conn = c;
        this.m_addr = new Address(h, p, n, u, z);
    }

    public Sharder getSharder(String query, final String model) throws SQLException {
        assert (!this.m_conn.isClosed());
        CacheListReader v = this.broker(query, model);
        final String m_query = v.getString();
        final int[] m_fields = new int[v.getInt()];
        for (int i = 0; i < m_fields.length; ++i) {
            m_fields[i] = v.getInt();
            v.getString();
        }
        int n = v.getInt();
        final int[] m_bounds = new int[n + 1];
        final ArrayList<Address> m_shards = new ArrayList<Address>(n);
        for (int i = 0; i < n; ++i) {
            m_shards.add(new Address(v.getString(), Integer.parseInt(v.getString()), v.getString(), this.m_addr.user, this.m_addr.password));
            m_bounds[i] = v.getInt();
        }
        m_bounds[n] = 2048;
        if (m_fields.length == 0) {
            class RoundRobinSharder
            extends 1AbstractSharder {
                int m_last;
                int m_next;

                RoundRobinSharder() {
                    abstract class AbstractSharder
                    implements Sharder {
                        final /* synthetic */ String val$m_query;
                        final /* synthetic */ String val$model;
                        final /* synthetic */ List val$m_shards;

                        AbstractSharder() {
                            this.val$m_query = string;
                            this.val$model = string2;
                            this.val$m_shards = list;
                            Utl.log(this.toString(), new Object[0]);
                        }

                        @Override
                        public String getQuery() {
                            return this.val$m_query;
                        }

                        @Override
                        public String getModel() {
                            return this.val$model;
                        }

                        @Override
                        public List<Address> getShards() {
                            return this.val$m_shards;
                        }

                        @Override
                        public void close() {
                        }

                        public String toString() {
                            StringBuilder b = new StringBuilder(1024);
                            this.dump(b);
                            return b.toString();
                        }

                        void dump(StringBuilder b, String k, Object v) {
                            b.append("\n " + k + " : " + v);
                        }

                        void dump(StringBuilder b, String k, int[] v) {
                            this.dump(b, k, Arrays.toString(v));
                        }

                        void dump(StringBuilder sb) {
                            this.dump(sb, "query ", this.val$m_query);
                            this.dump(sb, "model ", this.val$model);
                            this.dump(sb, "shards", this.val$m_shards);
                        }
                    }
                    super(Master.this, string2, string, list);
                    this.m_last = m_shards.size();
                    this.m_next = 0;
                }

                @Override
                public int getShard(Record record) {
                    if (this.m_next == this.m_last) {
                        this.m_next = 0;
                    }
                    return this.m_next++;
                }

                @Override
                void dump(StringBuilder sb) {
                    this.dump(sb, "method", "round-robbin");
                    super.dump(sb);
                }
            }
            return new RoundRobinSharder();
        }
        class KeyHashSharder
        extends 1AbstractSharder {
            KeyHashSharder() {
                super(Master.this, string2, string, list);
            }

            @Override
            public int getShard(Record record) {
                CRC32 crc32 = new CRC32();
                for (int field : m_fields) {
                    Object k = record.fields[field];
                    String fld = k == null ? "" : k.toString();
                    fld = ("x" + fld.toUpperCase()).trim();
                    fld = " " + fld.substring(1, fld.length());
                    crc32.update(fld.getBytes());
                }
                int h = (int)(crc32.getValue() % 2048L);
                int i = Arrays.binarySearch(m_bounds, h);
                return i < 0 ? -i - 2 : i;
            }

            @Override
            void dump(StringBuilder sb) {
                this.dump(sb, "method", "key-hash");
                super.dump(sb);
                this.dump(sb, "fields", m_fields);
                this.dump(sb, "bounds", m_bounds);
            }
        }
        return new KeyHashSharder();
    }

    private CacheListReader broker(String query, String model) throws SQLException {
        assert (!this.m_conn.isClosed());
        try {
            CacheListReader r = this.m_conn.callListClassMethod("%BigData.ShardingManager", "%BrokerShardOp", model, query);
            Object o = r.getObject();
            if (!(o instanceof Long) || (Long)o != 1L) {
                throw new SQLException(r.getString());
            }
            return r;
        }
        catch (RuntimeException e) {
            CacheListBuilder b = new CacheListBuilder(this.m_conn.getServerLocale());
            b.set(query);
            b.set(0);
            b.set(1);
            b.set(this.m_addr.host);
            b.set(this.m_addr.port);
            b.set(this.m_addr.namespace);
            b.set(0);
            return new CacheListReader(b);
        }
    }

    public String toString() {
        return this.m_addr.toString();
    }
}

