/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser;

import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheParameter;
import com.intersys.jdbc.preparser.CheckPoint;
import com.intersys.jdbc.preparser.ITokenEnumerator;
import com.intersys.jdbc.preparser.ParseToken;
import com.intersys.jdbc.preparser.PreParseResult;
import com.intersys.jdbc.preparser.Scanner;
import com.intersys.jdbc.preparser.Token;
import com.intersys.jdbc.preparser.TokenList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class PreParser {
    Scanner m_Scanner;
    boolean m_bDelimitedIdentifiers;
    boolean m_bBracketSubstitution = false;
    TokenList m_Tokens;
    private int m_eStmtType;
    private int m_nUndefinedCount;
    private int m_addRowID;
    public int m_ExecParamCount = 0;
    static ConcurrentHashMap<String, Token.TOKEN> s_KeywordTable = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Integer> s_StatementTable;
    static ConcurrentHashMap<String, Integer> s_ParsedStatements;
    boolean hasNamedParameters = false;
    static ConcurrentHashMap<String, Boolean> s_TransactionStatements;
    static String s_replaceparm;
    static final int UNKNOWN = 0;
    static final int SELECT = 1;
    static final int QUERY = 1;
    static final int UPDATE = 2;
    static final int DELETE = 3;
    static final int INSERT = 4;
    static final int CALL = 5;
    static final int CALLWITHRESULT = 6;
    static final int CALL_HAS_RETURN_VALUE = 6;
    static final int SET_OPTION_SINGLE = 7;
    static final int SET_OPTION_MULTIPLE = 8;
    static final int DDL_ALTER_DROP = 9;
    static final int DDL_OTHER = 10;
    static final int SYNC_COMMIT = 11;
    static final int ASYNC_COMMIT = 12;
    static final int STREAMS_OFF = 13;
    static final int STREAMS_ON = 14;
    static final int STMT_USE = 15;
    static final int SQL_DIALECT_DEFAULT = 0;
    static final int SQL_DIALECT_MSSQL = 1;
    static final int SQL_DIALECT_SYBASE = 2;
    private boolean m_CacheOnServer = false;
    private CacheListBuilder m_ParamInfo;

    boolean CacheOnServerGet() {
        return this.m_CacheOnServer;
    }

    private void CacheOnServerSet(boolean b) {
        this.m_CacheOnServer = b;
    }

    CacheListBuilder ParamInfoGet() {
        return this.m_ParamInfo;
    }

    private void ParamInfoSet(CacheListBuilder s) {
        this.m_ParamInfo = s;
    }

    PreParser() {
        this(false, 0);
    }

    PreParser(boolean p_bDelimitedIdentifiers, int addRID) {
        this.m_bDelimitedIdentifiers = p_bDelimitedIdentifiers;
        this.m_addRowID = addRID;
        this.CacheOnServerSet(false);
    }

    PreParseResult PreParse(String p_strInput, ArrayList<CacheParameter> p_Parameters) throws Exception {
        this.Tokenize(p_strInput);
        return this.Resolve(p_strInput, p_Parameters);
    }

    private void Tokenize(String p_strInput) throws Exception {
        this.m_Scanner = new Scanner(p_strInput);
        this.m_Tokens = new TokenList();
        block31: while (this.m_Scanner.CurrentTokenGet() != ParseToken.tokEOS) {
            this.m_Scanner.SkipWhitespace();
            switch (this.m_Scanner.CurrentTokenGet()) {
                case tokEOS: {
                    continue block31;
                }
                case tokDOT: {
                    if (ParseToken.tokDIGIT != this.m_Scanner.PeekNextToken()) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.NextToken();
                        this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                        continue block31;
                    }
                }
                case tokDIGIT: {
                    String t_strNumber = this.m_Scanner.Hex();
                    if (this.m_Scanner.m_boolReturn) {
                        this.m_Tokens.Append(new Token(Token.TOKEN.HEX, t_strNumber));
                        continue block31;
                    }
                    t_strNumber = this.m_Scanner.Number();
                    if (!this.m_Scanner.m_boolReturn) {
                        throw new Exception("Invalid Numeric Constant");
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                    continue block31;
                }
                case tokMINUS: {
                    String t_strNumber;
                    Token.TOKEN t_eToken;
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokMINUS) {
                        this.m_Scanner.Skip(2);
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.SkipToEndOfLine();
                        continue block31;
                    }
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokGREAT) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.Skip(2);
                        this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                        continue block31;
                    }
                    Token.TOKEN tOKEN = t_eToken = this.m_Tokens.Last() != null ? this.m_Tokens.Last().GetValue().TokenTypeGet() : Token.TOKEN.UNKNOWN;
                    if ((t_eToken == Token.TOKEN.OP || t_eToken == Token.TOKEN.OPEN_PAREN) && (this.m_Scanner.PeekNextToken() == ParseToken.tokDIGIT || this.m_Scanner.PeekNextToken() == ParseToken.tokDOT && this.m_Scanner.PeekNextNextToken() == ParseToken.tokDIGIT)) {
                        t_strNumber = this.m_Scanner.Number();
                        if (!this.m_Scanner.m_boolReturn) {
                            throw new Exception("Invalid Numeric Constant");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                        continue block31;
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, "-"));
                    continue block31;
                }
                case tokPLUS: {
                    String t_strNumber;
                    Token.TOKEN t_eToken;
                    Token.TOKEN tOKEN = t_eToken = this.m_Tokens.Last() != null ? this.m_Tokens.Last().GetValue().TokenTypeGet() : Token.TOKEN.UNKNOWN;
                    if ((t_eToken == Token.TOKEN.OP || t_eToken == Token.TOKEN.OPEN_PAREN) && (this.m_Scanner.PeekNextToken() == ParseToken.tokDIGIT || this.m_Scanner.PeekNextToken() == ParseToken.tokDOT && this.m_Scanner.PeekNextNextToken() == ParseToken.tokDIGIT)) {
                        t_strNumber = this.m_Scanner.Number();
                        if (!this.m_Scanner.m_boolReturn) {
                            throw new Exception("Invalid Numeric Constant");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                        continue block31;
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, "+"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokLBRACK: {
                    String t_strString;
                    Token.TOKEN t_eToken;
                    if (this.m_bBracketSubstitution) {
                        if (!this.m_bDelimitedIdentifiers) {
                            throw new Exception("Delimited identifiers must be enabled on the server to support brackets");
                        }
                        t_strString = this.m_Scanner.ParseBrackets(this.m_bDelimitedIdentifiers);
                        t_eToken = this.m_Scanner.m_tempToken;
                        this.m_Tokens.Append(new Token(t_eToken, t_strString));
                        continue block31;
                    }
                    this.m_Scanner.BeginLexeme();
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokDQUOTE: 
                case tokSQUOTE: {
                    String t_strString = this.m_Scanner.String(this.m_bDelimitedIdentifiers);
                    Token.TOKEN t_eToken = this.m_Scanner.m_tempToken;
                    this.m_Tokens.Append(new Token(t_eToken, t_strString));
                    continue block31;
                }
                case tokSLASH: {
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokASTER) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.Skip(2);
                        if (!this.m_Scanner.Comment()) {
                            throw new Exception("Unexpected End-Of-Statement");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                        continue block31;
                    }
                    this.m_Scanner.BeginLexeme();
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokQUEST: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.QUESTION_MARK, "?"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokATSIGN: {
                    this.m_Scanner.NextToken();
                    if (this.m_Scanner.CurrentTokenGet() == ParseToken.tokDIGIT) {
                        throw new Exception("Parameter Name error, First value cannot be a digit: " + this.m_Scanner.CurrentChar());
                    }
                    String t_strID = this.m_Scanner.Identifier();
                    if (t_strID == "") {
                        this.m_Tokens.Append(new Token(Token.TOKEN.QUESTION_MARK, "?"));
                        continue block31;
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.ATSIGN, "@" + t_strID));
                    continue block31;
                }
                case tokLPARN: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.OPEN_PAREN, "("));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokRPARN: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.CLOSE_PAREN, ")"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokCOMMA: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.COMMA, ","));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokCOLON: {
                    this.m_Scanner.NextToken();
                    String t_strVariable = this.m_Scanner.Variable();
                    t_strVariable = ":" + t_strVariable;
                    this.m_Tokens.Append(new Token(Token.TOKEN.VAR, t_strVariable));
                    continue block31;
                }
                case tokLETTER: 
                case tokPERCENT: 
                case tokDOLLAR: 
                case tokUSCORE: 
                case tokPOUND: {
                    Token.TOKEN t_eToken = Token.TOKEN.ID;
                    String t_strID = this.m_Scanner.Identifier();
                    String t_strIDUpper = this.m_Scanner.EndUpperLexeme();
                    if (s_KeywordTable.containsKey(t_strIDUpper) && (t_eToken = s_KeywordTable.get(t_strIDUpper)) == Token.TOKEN.NOT) {
                        t_strID = this.m_Scanner.checkForNotPredicates();
                    }
                    this.m_Tokens.Append(new Token(t_eToken, t_strID, t_strIDUpper));
                    continue block31;
                }
                case tokLESS: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokEQUAL || this.m_Scanner.PeekNextToken() == ParseToken.tokGREAT) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokEXCLA: 
                case tokGREAT: 
                case tokASTER: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokEQUAL) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokEQUAL: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokASTER) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokVBAR: {
                    this.m_Scanner.BeginLexeme();
                    Token.TOKEN t_eToken = Token.TOKEN.OP;
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokVBAR) {
                        this.m_Scanner.Skip(2);
                    } else {
                        this.m_Scanner.NextToken();
                        t_eToken = Token.TOKEN.UNKNOWN;
                    }
                    this.m_Tokens.Append(new Token(t_eToken, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokLBRACE: {
                    String t_strKeyword;
                    this.m_Scanner.NextToken();
                    CheckPoint t_CP = this.m_Scanner.CreateCheckPoint();
                    this.m_Scanner.SkipWhitespace();
                    switch (t_strKeyword = this.m_Scanner.Keyword()) {
                        case "d": 
                        case "ds": 
                        case "t": 
                        case "ts": {
                            this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, "{"));
                            this.m_Tokens.Append(new Token(Token.TOKEN.DTS, t_strKeyword));
                            continue block31;
                        }
                    }
                    this.m_Scanner.RestoreCheckPoint(t_CP);
                    this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, "{"));
                    continue block31;
                }
            }
            this.m_Scanner.BeginLexeme();
            this.m_Scanner.NextToken();
            this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private PreParseResult Resolve(String p_strInput, ArrayList<CacheParameter> p_Parameters) throws Exception {
        block107: {
            block109: {
                block112: {
                    block111: {
                        block110: {
                            block108: {
                                block106: {
                                    pOut = new PreParseResult();
                                    t_SB = new StringBuilder();
                                    pOut.p_eStmtType = 0;
                                    if (this.ParamInfoGet() == null) {
                                        this.ParamInfoSet(new CacheListBuilder(100, null));
                                    } else {
                                        this.ParamInfoGet().clearList();
                                    }
                                    t_Enum = this.m_Tokens.GetEnumerator();
                                    v0 = t_bBoundParameters = p_Parameters.size() > 0;
                                    if (this.m_Tokens.Count() >= 2) break block106;
                                    t_SB.append(p_strInput);
                                    break block107;
                                }
                                t_Enum.MoveNext();
                                t_str = t_Enum.Current().UpperLexeme;
                                while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                                    t_Enum.MoveNext();
                                    t_str = t_Enum.Current().UpperLexeme;
                                }
                                if (!PreParser.s_ParsedStatements.containsKey(t_str)) break block108;
                                this.m_eStmtType = pOut.p_eStmtType = PreParser.s_ParsedStatements.get(t_str).intValue();
                                this.CacheOnServerSet(true);
                                break block109;
                            }
                            if (!PreParser.s_StatementTable.containsKey(t_str)) break block110;
                            pOut.p_eStmtType = PreParser.s_StatementTable.get(t_str);
                            if (this.m_bBracketSubstitution && this.m_bDelimitedIdentifiers) {
                                t_Enum.Reset();
                                while (t_Enum.MoveNext()) {
                                    t_SB.append(t_Enum.Current().Lexeme);
                                    t_SB.append(" ");
                                }
                            } else {
                                t_SB.append(p_strInput);
                            }
                            break block107;
                        }
                        if (PreParser.s_TransactionStatements.containsKey(t_str)) {
                            this.CacheOnServerSet(true);
                        } else if (t_str.startsWith("(") && t_Enum.MoveNext()) {
                            t_str = t_Enum.Current().UpperLexeme;
                            if (t_str == "SELECT") {
                                pOut.p_eStmtType = PreParser.s_ParsedStatements.get(t_str);
                            }
                            t_Enum.MovePrevious();
                            this.CacheOnServerSet(true);
                        }
                        if (!this.m_Tokens.First().GetValue().UpperEquals("SET")) break block111;
                        t_NewEnum = this.m_Tokens.GetEnumerator();
                        if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("TRANSACTION")) {
                            this.CacheOnServerSet(true);
                        }
                        if (5 == this.m_Tokens.Count()) {
                            t_NewEnum.Reset();
                            if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("OPTION")) {
                                if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("BLOB_SUPPORT")) {
                                    if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("=")) {
                                        if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("1")) {
                                            pOut.p_eStmtType = 14;
                                        } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("0")) {
                                            pOut.p_eStmtType = 13;
                                        }
                                    }
                                } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("SYNCHRONOUS_COMMIT") && t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("=")) {
                                    if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("1")) {
                                        pOut.p_eStmtType = 11;
                                    } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("0")) {
                                        pOut.p_eStmtType = 12;
                                    }
                                }
                            }
                        }
                        t_Enum.Reset();
                        while (t_Enum.MoveNext()) {
                            t_SB.append(t_Enum.Current().Lexeme);
                            t_SB.append(" ");
                        }
                        break block107;
                    }
                    if (this.CacheOnServerGet() || !this.Exec(t_SB, p_Parameters)) break block112;
                    this.CacheOnServerSet(true);
                    pOut.p_eStmtType = this.m_eStmtType;
                    break block107;
                }
                this.m_nUndefinedCount = 0;
                if (this.CacheOnServerGet() || !this.Call(t_SB, p_Parameters)) break block109;
                this.CacheOnServerSet(true);
                pOut.p_eStmtType = this.m_eStmtType;
                break block107;
            }
            t_SB.setLength(0);
            t_nOpenParen = 0;
            t_nOrdinal = 0;
            t_nRound = 0;
            t_nRoundNested = 0;
            t_Enum.Reset();
            t_bQuitLoop = false;
            bFirstElement = true;
            orderbyToken = null;
            lastToken = null;
            while (!t_bQuitLoop && t_Enum.MoveNext()) {
                t_Token = t_Enum.Current();
                if (bFirstElement) {
                    bFirstElement = false;
                    if (t_Token.UpperEquals("{")) {
                        throw new SQLException("'{' encountered at the beginning of the statement", "37000", 37000);
                    }
                }
                block0 : switch (1.$SwitchMap$com$intersys$jdbc$preparser$Token$TOKEN[t_Token.TokenTypeGet().ordinal()]) {
                    case 1: {
                        ++t_nOrdinal;
                        if (t_bBoundParameters) break;
                        p_Parameters.add(new CacheParameter("?", 0, '?'));
                        break;
                    }
                    case 2: {
                        this.hasNamedParameters = true;
                        ++t_nOrdinal;
                        if (!t_bBoundParameters || p_Parameters.size() == 0) {
                            p_Parameters.add(new CacheParameter(t_Token.Lexeme, 0));
                            break;
                        }
                        if (this.matchUpParam(p_Parameters, t_Token.Lexeme, p_Parameters.size())) break;
                        p_Parameters.add(new CacheParameter(t_Token.Lexeme, 0));
                        break;
                    }
                    case 3: {
                        ++t_nOrdinal;
                        cp = new CacheParameter(PreParser.HexStringToByteArray(t_Token.Lexeme), 5, -2, '?');
                        p_Parameters.add(cp);
                        t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                        break;
                    }
                    case 4: {
                        if (null != lastToken && lastToken == orderbyToken) {
                            orderbyToken = t_Token;
                            lastToken = t_Token;
                            break;
                        }
                        if (t_Token.UpperEquals("ORDER") && (t_NewEnum = t_Enum.Clone()).MoveNext() && (t_NewToken = t_NewEnum.Current()).UpperEquals("BY")) {
                            orderbyToken = t_NewToken;
                            if (t_nOpenParen == 0) break;
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) continue;
                                --t_nOpenParen;
                                break;
                            }
                        }
                        if (t_Token.UpperContains("JSON_") || t_Token.UpperContains("_JSON")) {
                            startParen = t_nOpenParen;
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                    ++t_nOpenParen;
                                }
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                    --t_nOpenParen;
                                }
                                if (t_nOpenParen != startParen) continue;
                            }
                        }
                        if (t_Token.UpperEquals("ROUND") && this.m_eStmtType == 1 && t_nRound == 0) {
                            t_nRound = 1;
                        }
                        if (!t_Token.UpperEquals("DATEPART") && !t_Token.UpperEquals("TIMESTAMPADD") && !t_Token.UpperEquals("TIMESTAMPDIFF") || !t_Enum.MoveNext()) break;
                        if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                    t_Enum.Current().TokenTypeSet(Token.TOKEN.ID);
                                    break block0;
                                }
                                if (t_Enum.Current().TokenTypeGet() != Token.TOKEN.COMMA && t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) continue;
                                break block0;
                            }
                            break;
                        }
                        t_Enum.MovePrevious();
                        break;
                    }
                    case 5: {
                        parenLevel = 0;
                        while (t_Enum.MoveNext()) {
                            if (parenLevel != true || t_Enum.Current().TokenTypeGet() != Token.TOKEN.COMMA) ** GOTO lbl184
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                    t_Enum.Current().TokenTypeSet(Token.TOKEN.ID);
                                    if (parenLevel != 1) continue;
                                } else {
                                    if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                        ++parenLevel;
                                        continue;
                                    }
                                    if (t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN || --parenLevel != 1) continue;
                                }
                                ** GOTO lbl211
                            }
                            ** GOTO lbl211
lbl184:
                            // 1 sources

                            if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                ++parenLevel;
                            } else if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                if (parenLevel == 1) break block0;
                                --parenLevel;
                            } else if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                bSubstitute = true;
                                if (parenLevel > 1) {
                                    t_Enum.MovePrevious();
                                    if (Token.TOKEN.OPEN_PAREN == t_Enum.Current().TokenTypeGet()) {
                                        t_Enum.MoveNext();
                                        t_Enum.MoveNext();
                                        if (Token.TOKEN.CLOSE_PAREN == t_Enum.Current().TokenTypeGet()) {
                                            bSubstitute = false;
                                        }
                                        t_Enum.MovePrevious();
                                    } else {
                                        t_Enum.MoveNext();
                                    }
                                }
                                if (bSubstitute) {
                                    t_Token = t_Enum.Current();
                                    t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                }
                            }
lbl211:
                            // 10 sources

                            if (parenLevel != 0) continue;
                            break block0;
                        }
                        break;
                    }
                    case 6: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        while (t_NewEnum.MoveNext() && (t_NewToken = t_NewEnum.Current()).TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) {
                        }
                        t_Enum = t_NewEnum;
                        break;
                    }
                    case 7: {
                        ++t_nOpenParen;
                        t_NewEnum = t_Enum.Clone();
                        if (t_nRound > 0) {
                            ++t_nRoundNested;
                        }
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        ++t_nOpenParen;
                        if (!t_NewEnum.MoveNext()) break;
                        t_NewToken = t_NewEnum.Current();
                        v1 = bCurlyBrace = 0 == t_NewToken.Lexeme.compareTo("{");
                        if (Token.TOKEN.CONSTANT != t_NewToken.TokenTypeGet() && !bCurlyBrace || !t_NewEnum.MoveNext()) break;
                        t_NewToken = t_NewEnum.Current();
                        if (bCurlyBrace) {
                            while (0 != t_NewToken.Lexeme.compareTo("}")) {
                                if (!t_NewEnum.MoveNext()) {
                                    bCurlyBrace = false;
                                    break;
                                }
                                t_NewToken = t_NewEnum.Current();
                            }
                            bCurlyBrace = false;
                            if (!t_NewEnum.MoveNext()) break;
                            t_NewToken = t_NewEnum.Current();
                        }
                        if (Token.TOKEN.CLOSE_PAREN != t_NewToken.TokenTypeGet()) break;
                        --t_nOpenParen;
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.CLOSE_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        --t_nOpenParen;
                        t_Enum = t_NewEnum;
                        if (t_nRound <= 0) break;
                        --t_nRoundNested;
                        break;
                    }
                    case 8: {
                        if (t_nRound > 0) {
                            --t_nRoundNested;
                        }
                        --t_nOpenParen;
                        break;
                    }
                    case 9: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet() || !t_NewEnum.MoveNext() || t_NewEnum.Current().TokenTypeGet() != Token.TOKEN.CONSTANT || !t_NewEnum.MoveNext() || t_NewEnum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) break;
                        t_Enum = t_NewEnum;
                        break;
                    }
                    case 10: {
                        if (t_nRound == 2 && t_nRoundNested == 1) {
                            t_Enum.MoveNext();
                            if (Token.TOKEN.COMMA != t_Enum.Current().TokenTypeGet()) {
                                t_nRound = 0;
                                t_nRoundNested = 0;
                            }
                            t_Enum.MovePrevious();
                            break;
                        }
                        if (null != lastToken) {
                            if (lastToken == orderbyToken) {
                                orderbyToken = t_Token;
                                break;
                            }
                            if (lastToken == orderbyToken) {
                                orderbyToken = t_Token;
                                lastToken = t_Token;
                                break;
                            }
                        }
                        if ((t_NewEnum = t_Enum.Clone()).MoveNext() && t_NewEnum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                            t_NewEnum.MovePrevious();
                            if (t_NewEnum.MovePrevious() && t_NewEnum.Current().Lexeme.charAt(0) == '-') {
                                t_NewEnum.MovePrevious();
                            }
                            if (t_Enum.Current() != null && t_NewEnum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                t_NewEnum.MovePrevious();
                                if (t_Enum.Current() != null && (Token.TOKEN.ID != t_NewEnum.Current().TokenTypeGet() || PreParser.s_replaceparm.indexOf(t_NewEnum.Current().UpperLexeme) > 0)) {
                                    t_Enum.MoveNext();
                                    break;
                                }
                            }
                        }
                        if (t_Enum.Current() != null) {
                            c = t_Enum.Current().Lexeme.toCharArray();
                            if (c[0] == '\'' || c[0] == '\"') {
                                aEnd = c[c.length - 1];
                                if (aEnd != c[0]) {
                                    throw new SQLException("unmatched quote in " + t_Enum.Current().Lexeme);
                                }
                                t_Enum.Current().m_format = t_Enum.Current().Lexeme.length() < 32 ? 1 : (t_Enum.Current().Lexeme.length() < 128 ? 2 : (t_Enum.Current().Lexeme.length() < 512 ? 3 : 4));
                            } else {
                                isInt = true;
                                for (ii = 0; ii < t_Enum.Current().Lexeme.length(); ++ii) {
                                    if (c[ii] != '.' && c[ii] != 'e' && c[ii] != 'E') continue;
                                    isInt = false;
                                    break;
                                }
                                t_Enum.Current().m_format = isInt != false ? 10 : 11;
                            }
                        }
                        t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                        break;
                    }
                    case 11: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MovePrevious() || (t_PreviousToken = t_NewEnum.Current()).TokenTypeGet() == Token.TOKEN.NOT || t_PreviousToken.TokenTypeGet() == Token.TOKEN.IS || t_PreviousToken.TokenTypeGet() == Token.TOKEN.THEN || t_PreviousToken.TokenTypeGet() == Token.TOKEN.COMMA || t_PreviousToken.TokenTypeGet() == Token.TOKEN.OPEN_PAREN || t_PreviousToken.TokenTypeGet() == Token.TOKEN.ELSE) break;
                        t_nOrdinal = this.Null(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                        break;
                    }
                    case 12: {
                        if (t_nRoundNested == 1 && t_nRound == 1) {
                            ++t_nRound;
                        }
                        if (t_nRound != 1) break;
                        ++t_nRound;
                        break;
                    }
                }
                if (Token.TOKEN.COMMA == t_Token.TokenTypeGet() || Token.TOKEN.OPEN_PAREN == t_Token.TokenTypeGet() || Token.TOKEN.CLOSE_PAREN == t_Token.TokenTypeGet()) continue;
                lastToken = t_Token;
            }
            t_Enum.Reset();
            t_nParamIndex = 1;
            t_count = 0;
            bExecute = false;
            while (t_Enum.MoveNext()) {
                ++t_count;
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("EXECUTE")) {
                    bExecute = true;
                }
                if (2 == t_count && bExecute) {
                    if (t_Token.UpperEquals("SELECT")) {
                        pOut.p_eStmtType = 1;
                        t_SB.setLength(0);
                    } else if (t_Token.UpperEquals("UPDATE")) {
                        pOut.p_eStmtType = 2;
                        t_SB.setLength(0);
                    } else if (t_Token.UpperEquals("INSERT")) {
                        pOut.p_eStmtType = 4;
                        t_SB.setLength(0);
                    }
                }
                if (Token.TOKEN.QUESTION_MARK == t_Token.TokenTypeGet() || Token.TOKEN.ATSIGN == t_Token.TokenTypeGet()) {
                    t_SB.append(String.format(":%%qpar(%d)", new Object[]{t_nParamIndex++}));
                    if (t_count >= t_Enum.Count()) continue;
                    t_SB.append(' ');
                    continue;
                }
                if (!t_Token.Lexeme.startsWith("/*")) {
                    t_SB.append(t_Token.Lexeme);
                }
                if (t_count < t_Enum.Count()) {
                    t_SB.append(' ');
                }
                if (t_Token.UpperEquals("SELECT")) {
                    this.appendRowId(t_SB);
                }
                if (!t_Token.UpperEquals("ORDER")) continue;
                t_Enum.MoveNext();
                t_SB.append(t_Enum.Current().Lexeme);
                if (t_count < t_Enum.Count()) {
                    t_SB.append(' ');
                }
                if (!t_Enum.Current().UpperEquals("BY")) continue;
                this.appendIdAdded(t_SB);
            }
        }
        this.m_ParamInfo.set(p_Parameters.size() - this.m_ExecParamCount);
        if (p_Parameters.size() - this.m_ExecParamCount > 0) {
            t_Enum.Reset();
            nParamIndex = 1;
            while (t_Enum.MoveNext()) {
                if (Token.TOKEN.QUESTION_MARK != t_Enum.Current().TokenTypeGet() && Token.TOKEN.ATSIGN != t_Enum.Current().TokenTypeGet()) continue;
                if (t_Enum.Current().m_replaced) {
                    this.m_ParamInfo.set(99);
                } else {
                    this.m_ParamInfo.set(63);
                }
                this.m_ParamInfo.set(t_Enum.Current().m_format);
                if (nParamIndex++ != p_Parameters.size()) continue;
            }
        }
        pOut.sResult = t_SB.toString();
        return pOut;
    }

    static byte[] HexStringToByteArray(String hex) throws Exception {
        if (hex.length() % 2 == 1) {
            throw new Exception("The binary key cannot have an odd number of digits");
        }
        byte[] arr = new byte[hex.length() - 2 >> 1];
        int i = 0;
        int j = 1;
        while (j < hex.length() >> 1) {
            arr[i] = (byte)((PreParser.GetHexVal(hex.charAt(j << 1)) << 4) + PreParser.GetHexVal(hex.charAt((j << 1) + 1)));
            ++j;
            ++i;
        }
        return arr;
    }

    static int GetHexVal(char hex) {
        char val;
        return val - ((val = hex) < ':' ? 48 : (val < 'a' ? 55 : 87));
    }

    int Null(boolean p_bBoundParameters, Token p_Token, int p_nOrdinal, ArrayList<CacheParameter> p_Parameters) {
        ++p_nOrdinal;
        CacheParameter t_Parameter = new CacheParameter(6);
        if (p_bBoundParameters) {
            p_Parameters.add(p_nOrdinal - 1, t_Parameter);
        } else {
            p_Parameters.add(t_Parameter);
        }
        p_Token.Lexeme = "?";
        p_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
        p_Token.m_replaced = true;
        return p_nOrdinal;
    }

    boolean Call(StringBuilder p_SB, ArrayList<CacheParameter> p_Parameters) throws Exception {
        boolean t_bRet;
        block36: {
            CacheParameter returnParam;
            Token t_Token;
            ITokenEnumerator t_Enum;
            block37: {
                block35: {
                    block34: {
                        t_bRet = false;
                        this.m_eStmtType = 0;
                        p_SB.setLength(0);
                        t_Enum = this.m_Tokens.GetEnumerator();
                        t_Enum.MoveNext();
                        String t_str = t_Enum.Current().UpperLexeme;
                        while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                            t_Enum.MoveNext();
                            t_str = t_Enum.Current().UpperLexeme;
                        }
                        t_Token = t_Enum.Current();
                        if (t_Token.Lexeme.charAt(0) == '{') {
                            t_Enum.MoveNext();
                            t_Token = t_Enum.Current();
                        }
                        returnParam = null;
                        if (t_Token.TokenTypeGet() != Token.TOKEN.QUESTION_MARK) break block34;
                        returnParam = new CacheParameter("?", 7, '?');
                        if (t_Enum.MoveNext() && t_Enum.Current().Lexeme.charAt(0) == '=' && t_Enum.MoveNext()) break block35;
                        break block36;
                    }
                    if (!(t_Enum.Current().UpperEquals("CALL") || t_Enum.Current().UpperEquals("EXEC") || t_Enum.Current().UpperEquals("EXECUTE"))) {
                        return false;
                    }
                }
                if (t_Token.TokenTypeGet() != Token.TOKEN.ATSIGN) break block37;
                this.hasNamedParameters = true;
                returnParam = new CacheParameter(t_Token.Lexeme, 7);
                if (!t_Enum.MoveNext() || t_Enum.Current().Lexeme.charAt(0) != '=' || !t_Enum.MoveNext()) break block36;
            }
            if (!(t_Enum.Current().UpperEquals("CALL") || t_Enum.Current().UpperEquals("EXEC") || t_Enum.Current().UpperEquals("EXECUTE") ? false == t_Enum.MoveNext() : Token.TOKEN.STRFUNCTION == t_Enum.Current().TokenTypeGet())) {
                p_SB.append(t_Enum.Current().Lexeme);
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) {
                    p_SB.setLength(0);
                } else if (t_Enum.MoveNext()) {
                    t_Token = t_Enum.Current();
                    if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) {
                        p_SB.setLength(0);
                    } else {
                        boolean t_bQuitLoop = false;
                        while (t_Token.Lexeme.charAt(0) == '.') {
                            p_SB.append('.');
                            if (!t_Enum.MoveNext()) {
                                t_bQuitLoop = true;
                                break;
                            }
                            t_Token = t_Enum.Current();
                            if (t_Token.TokenTypeGet() != Token.TOKEN.ID) continue;
                            p_SB.append(t_Token.Lexeme);
                            if (!t_Enum.MoveNext()) {
                                t_bQuitLoop = true;
                                break;
                            }
                            t_Token = t_Enum.Current();
                        }
                        boolean t_bBoundParameters = p_Parameters.size() > 0;
                        int t_nOrdinal = 0;
                        if (returnParam != null) {
                            ++t_nOrdinal;
                            if (!t_bBoundParameters) {
                                p_Parameters.add(0, returnParam);
                            } else if (!this.matchUpParam(p_Parameters, returnParam.GetName(), t_nOrdinal - 1) && p_Parameters.get(0).GetMode() != 7) {
                                p_Parameters.add(0, returnParam);
                            }
                        }
                        if (!t_bQuitLoop) {
                            Token.TOKEN t_eLastToken = Token.TOKEN.UNKNOWN;
                            block10: do {
                                t_Token = t_Enum.Current();
                                switch (t_Token.TokenTypeGet()) {
                                    case QUESTION_MARK: {
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        ++t_nOrdinal;
                                        if (t_bBoundParameters) continue block10;
                                        p_Parameters.add(new CacheParameter("?", 0, '?'));
                                        break;
                                    }
                                    case ATSIGN: {
                                        this.hasNamedParameters = true;
                                        t_eLastToken = Token.TOKEN.ATSIGN;
                                        ++t_nOrdinal;
                                        if (!t_bBoundParameters || p_Parameters.size() == 0) {
                                            p_Parameters.add(new CacheParameter(t_Token.Lexeme, 0));
                                            break;
                                        }
                                        if (this.matchUpParam(p_Parameters, t_Token.Lexeme, t_nOrdinal - 1)) continue block10;
                                        p_Parameters.add(new CacheParameter(t_Token.Lexeme, 0));
                                        break;
                                    }
                                    case HEX: {
                                        ++t_nOrdinal;
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        CacheParameter cp = new CacheParameter(PreParser.HexStringToByteArray(t_Token.Lexeme), 5, -2, '?');
                                        p_Parameters.add(cp);
                                        t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                                        break;
                                    }
                                    case ID: 
                                    case CONSTANT: {
                                        Token t_PreviousToken;
                                        ITokenEnumerator t_NewEnum = t_Enum.Clone();
                                        if (t_NewEnum.MovePrevious() && (t_PreviousToken = t_NewEnum.Current()).TokenTypeGet() == Token.TOKEN.OP) {
                                            t_nOrdinal = this.DynamicVariable(t_bBoundParameters, new Token(Token.TOKEN.CONSTANT, t_PreviousToken.Lexeme, t_PreviousToken.UpperLexeme), t_nOrdinal, p_Parameters);
                                            t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                                            t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                            break;
                                        }
                                        t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        break;
                                    }
                                    case NULL: {
                                        t_nOrdinal = this.Null(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                        break;
                                    }
                                    case CLOSE_PAREN: 
                                    case COMMA: {
                                        if (Token.TOKEN.COMMA == t_eLastToken || Token.TOKEN.OPEN_PAREN == t_eLastToken) {
                                            CacheParameter t_Parameter = new CacheParameter(6, 'd');
                                            ++t_nOrdinal;
                                            ++this.m_nUndefinedCount;
                                            if (t_bBoundParameters) {
                                                p_Parameters.add(t_nOrdinal - 1, t_Parameter);
                                            } else {
                                                p_Parameters.add(t_Parameter);
                                            }
                                        }
                                        t_eLastToken = t_Token.TokenTypeGet();
                                        break;
                                    }
                                    default: {
                                        t_eLastToken = t_Token.TokenTypeGet();
                                    }
                                }
                            } while (t_Enum.MoveNext());
                        }
                        this.m_eStmtType = returnParam == null ? 5 : 6;
                        t_bRet = true;
                    }
                }
            }
        }
        return t_bRet;
    }

    boolean matchUpParam(ArrayList<CacheParameter> param, String paramName, int numParam) {
        boolean match = false;
        if (!this.hasNamedParameters || paramName == null || paramName == "" || paramName.charAt(0) != '@') {
            return false;
        }
        for (int i = 0; i < param.size(); ++i) {
            if (param.get(i).GetName().toUpperCase() != paramName.toUpperCase() && "@" + param.get(i).GetName().toUpperCase() != paramName.toUpperCase()) continue;
            match = true;
            if (i != numParam) {
                CacheParameter cp;
                CacheParameter cporig = cp = param.get(i);
                if (!cporig.m_parsermatched) {
                    param.remove(i);
                } else {
                    cp = cporig.Clone();
                    cp.SetName(cporig.GetName() + Integer.toString(numParam));
                    cp.SetMode(0);
                    if (cporig.matchedParamaterList == null) {
                        cporig.matchedParamaterList = new ArrayList(5);
                    }
                    cporig.matchedParamaterList.add(cp);
                }
                cp.m_parsermatched = true;
                param.add(numParam, cp);
                break;
            }
            param.get((int)i).m_parsermatched = true;
            break;
        }
        return match;
    }

    boolean Exec(StringBuilder p_SB, ArrayList<CacheParameter> p_Parameters) {
        boolean t_bRet;
        block26: {
            boolean t_bHasReturnType;
            Token t_Token;
            ITokenEnumerator t_Enum;
            block27: {
                t_bRet = false;
                this.m_eStmtType = 0;
                t_Enum = this.m_Tokens.GetEnumerator();
                t_Enum.MoveNext();
                t_Token = t_Enum.Current();
                if (!t_Token.UpperEquals("EXEC") && !t_Token.UpperEquals("EXECUTE")) break block26;
                this.m_eStmtType = 5;
                t_Enum.MoveNext();
                String t_str = t_Enum.Current().UpperLexeme;
                while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                    t_Enum.MoveNext();
                    t_str = t_Enum.Current().UpperLexeme;
                }
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) break block26;
                t_bRet = true;
                t_bHasReturnType = false;
                if ('@' != t_Token.Lexeme.charAt(0)) break block27;
                t_bHasReturnType = true;
                if (!t_Enum.MoveNext() || !t_Enum.MoveNext()) break block26;
                t_Token = t_Enum.Current();
                if (t_Token.Lexeme != "=" || !t_Enum.MoveNext()) break block26;
                t_Token = t_Enum.Current();
            }
            p_SB.append(t_Token.Lexeme);
            if (!t_Enum.MoveNext()) {
                return true;
            }
            t_Token = t_Enum.Current();
            boolean t_bQuitLoop = false;
            while (t_Token.Lexeme.charAt(0) == '.') {
                p_SB.append('.');
                if (!t_Enum.MoveNext()) {
                    t_bQuitLoop = true;
                    break;
                }
                t_Token = t_Enum.Current();
                if (t_Token.TokenTypeGet() != Token.TOKEN.ID) continue;
                p_SB.append(t_Token.Lexeme);
                if (!t_Enum.MoveNext()) {
                    t_bQuitLoop = true;
                    break;
                }
                t_Token = t_Enum.Current();
            }
            if (!t_bQuitLoop) {
                int t_nOrdinal = 0;
                do {
                    if (Token.TOKEN.COMMA == (t_Token = t_Enum.Current()).TokenTypeGet()) {
                        if (!t_Enum.MoveNext()) break;
                        t_Token = t_Enum.Current();
                    }
                    if (t_Token.UpperEquals("WITH RECOMPILE")) break;
                    String t_strParameterName = "";
                    if (t_Token.Lexeme.charAt(0) == '@') {
                        if (t_Enum.MoveNext()) {
                            t_strParameterName = t_Enum.Current().Lexeme;
                            boolean bMoveNext = t_Enum.MoveNext();
                            if (!bMoveNext || t_Enum.Current().Lexeme != "=") {
                                if (!bMoveNext) {
                                    t_bQuitLoop = true;
                                }
                                CacheParameter t_Param = new CacheParameter(0);
                                t_Param.SetName(t_Token.Lexeme.substring(1));
                                t_Param.m_ExecuteParam = true;
                                t_Param.m_ExecConstantType = 3;
                                ++this.m_ExecParamCount;
                                p_Parameters.add(t_Param);
                                continue;
                            }
                            t_Enum.MoveNext();
                        }
                        t_Token = t_Enum.Current();
                        t_Enum.MoveNext();
                    }
                    switch (t_Token.TokenTypeGet()) {
                        case QUESTION_MARK: 
                        case OPEN_PAREN: 
                        case CLOSE_PAREN: 
                        case UNKNOWN: {
                            break;
                        }
                        default: {
                            if (t_Token != null && Token.TOKEN.OPEN_PAREN != t_Token.TokenTypeGet()) {
                                if (t_Token.Lexeme.charAt(0) == '-') {
                                    if (!t_Enum.MoveNext()) {
                                        t_bQuitLoop = true;
                                        break;
                                    }
                                    t_Token = t_Enum.Current();
                                    Token t_NewToken = new Token(Token.TOKEN.CONSTANT, "-" + t_Token.Lexeme, "-" + t_Token.UpperLexeme);
                                    t_nOrdinal = this.DynamicVariable(false, t_NewToken, t_nOrdinal, p_Parameters);
                                } else {
                                    t_nOrdinal = this.DynamicVariable(false, t_Token, t_nOrdinal, p_Parameters);
                                }
                            }
                            CacheParameter t_Parameter = p_Parameters.get(p_Parameters.size() - 1);
                            t_Parameter.SetName(t_strParameterName);
                            t_Parameter.m_ExecuteParam = true;
                            ++this.m_ExecParamCount;
                        }
                    }
                } while (t_Enum.MoveNext());
                if (!t_bQuitLoop) {
                    if (t_bHasReturnType) {
                        this.m_eStmtType = 6;
                        CacheParameter t_ReturnParam = new CacheParameter(0);
                        t_ReturnParam.m_ExecuteParam = true;
                        ++this.m_ExecParamCount;
                        p_Parameters.add(0, t_ReturnParam);
                    } else {
                        this.m_eStmtType = 5;
                    }
                    t_bRet = true;
                }
            }
        }
        if (0 == this.m_ExecParamCount) {
            return false;
        }
        return t_bRet;
    }

    int DynamicVariable(boolean p_bBoundParameters, Token p_Token, int p_nOrdinal, ArrayList<CacheParameter> p_Parameters) {
        ++p_nOrdinal;
        String t_strItem = p_Token.Lexeme;
        char t_c = t_strItem.charAt(0);
        StringBuilder t_strBld = new StringBuilder(p_Token.Lexeme);
        switch (t_c) {
            case '\"': 
            case '\'': {
                t_strBld.delete(0, 1);
                if (t_strBld.length() > 0) {
                    int ii = t_strBld.length() - 1;
                    t_strBld.delete(ii, ii + 1);
                }
                for (int t_i = 0; t_i < t_strBld.length() - 1; ++t_i) {
                    if (t_strBld.charAt(t_i) != t_c || t_strBld.charAt(t_i + 1) != t_c) continue;
                    t_strBld.delete(t_i, t_i + 1);
                }
                t_strItem = t_strBld.toString();
                break;
            }
            default: {
                if (p_Token.Lexeme.indexOf(101) != -1 || p_Token.Lexeme.indexOf(69) != -1) {
                    try {
                        double t_double = Double.parseDouble(p_Token.Lexeme.toLowerCase());
                        t_strItem = Double.toString(t_double);
                    }
                    catch (Exception ex) {}
                    break;
                }
                int p = 0;
                if (t_strBld.charAt(p) == '+') {
                    t_strBld.delete(0, 1);
                }
                if (t_strBld.charAt(p) == '-') {
                    ++p;
                }
                while (p < t_strBld.length() && t_strBld.charAt(p) == '0') {
                    t_strBld.delete(p, p + 1);
                }
                if (p_Token.Lexeme.indexOf(46) != -1) {
                    while (t_strBld.charAt(t_strBld.length() - 1) == '0') {
                        t_strBld.delete(t_strBld.length() - 1, t_strBld.length());
                    }
                    if (t_strBld.charAt(t_strBld.length() - 1) == '.') {
                        t_strBld.delete(t_strBld.length() - 1, t_strBld.length());
                    }
                }
                t_strItem = p >= t_strBld.length() ? "0" : t_strBld.toString();
            }
        }
        if (p_bBoundParameters) {
            p_Parameters.add(p_nOrdinal - 1, new CacheParameter(t_strItem, 63));
        } else {
            p_Parameters.add(new CacheParameter(t_strItem, 63));
        }
        p_Token.Lexeme = "?";
        p_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
        p_Token.m_replaced = true;
        return p_nOrdinal;
    }

    private void appendRowId(StringBuilder sb) {
        if (this.m_addRowID != 0) {
            sb.append("%ID ,");
        }
    }

    private void appendIdAdded(StringBuilder sb) {
        if (this.m_addRowID == 2) {
            sb.append("%IDADDED ");
        }
    }

    static {
        s_KeywordTable.put("AND", Token.TOKEN.OP);
        s_KeywordTable.put("BETWEEN", Token.TOKEN.OP);
        s_KeywordTable.put("CHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("CHARACTER", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("DEC", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("DECIMAL", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("FLOAT", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("IS", Token.TOKEN.IS);
        s_KeywordTable.put("LIKE", Token.TOKEN.OP);
        s_KeywordTable.put("LONGVARBINARY", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("LONGVARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NOT[", Token.TOKEN.OP);
        s_KeywordTable.put("NOT", Token.TOKEN.NOT);
        s_KeywordTable.put("NULL", Token.TOKEN.NULL);
        s_KeywordTable.put("NUMBER", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NUMERIC", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NVARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("RAW", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("STARTSWITH", Token.TOKEN.OP);
        s_KeywordTable.put("THEN", Token.TOKEN.THEN);
        s_KeywordTable.put("ELSE", Token.TOKEN.ELSE);
        s_KeywordTable.put("VARBINARY", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARCHAR2", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARYING", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("_", Token.TOKEN.NOT);
        s_KeywordTable.put("%SQLUPPER", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%STRING", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%SQLSTRING", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%TRUNCATE", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("TRUNCATE", Token.TOKEN.STRFUNCTION);
        s_StatementTable = new ConcurrentHashMap();
        s_StatementTable.put("ALTER", 9);
        s_StatementTable.put("CREATE", 10);
        s_StatementTable.put("DROP", 9);
        s_StatementTable.put("GRANT", 10);
        s_StatementTable.put("REVOKE", 10);
        s_StatementTable.put("%CHECKPRIV", 10);
        s_StatementTable.put("USE", 15);
        s_ParsedStatements = new ConcurrentHashMap();
        s_ParsedStatements.put("SELECT", 1);
        s_ParsedStatements.put("INSERT", 4);
        s_ParsedStatements.put("DELETE", 2);
        s_ParsedStatements.put("UPDATE", 2);
        s_TransactionStatements = new ConcurrentHashMap();
        s_TransactionStatements.put("COMMIT", true);
        s_TransactionStatements.put("ROLLBACK", true);
        s_TransactionStatements.put("START", true);
        s_TransactionStatements.put("%INTRANSACTION", true);
        s_TransactionStatements.put("%INTRANS", true);
        s_TransactionStatements.put("%BEGTRANS", true);
        s_replaceparm = " SELECT TOP WHERE ON AND OR NOT BETWEEN %STARTSWITH LIKE CASE WHEN ELSE THEN";
    }
}

