/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferRO;
import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheMsgHeader;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public final class InStream {
    static final int SEND_DATA = 0;
    static final int BYTE_STREAM = 1;
    static final int FETCH_DATA = 2;
    static final int OOB_FETCH = 3;
    CacheConnection connection;
    LogFileStream logFile;
    public CacheBufferRO wire;
    String locale;
    InputStream inputStream;
    LinkedBlockingQueue<CacheBufferRO> messages = new LinkedBlockingQueue(1);

    InStream(CacheConnection conn) throws IOException {
        this.inputStream = conn.inputStream;
        this.connection = conn;
        this.logFile = this.connection.logFile;
        this.locale = null;
    }

    public InStream(InputStream i, LogFileStream l) throws IOException {
        this.inputStream = i;
        this.connection = null;
        this.logFile = l;
        this.locale = null;
    }

    public void setLocale(CacheConnection conn) {
        if (!conn.connectionInfo.isUnicodeServer && !conn.connectionInfo.serverLocale.toUpperCase().matches("ISO8859_1")) {
            this.locale = conn.connectionInfo.serverLocale;
        }
    }

    public void setLocale(String inLocale, boolean isUnicodeServer) {
        this.locale = !isUnicodeServer && !inLocale.toUpperCase().matches("ISO8859_1") ? inLocale : null;
    }

    private int read(byte[] buffer, int offset, int count) throws SQLException, IOException {
        int len = this.inputStream.read(buffer, offset, count);
        if (len < 1) {
            this.inputStream.close();
            if (len == 0) {
                throw new SQLException("Server unexpectedly closing communication device", "08S01", 461);
            }
            throw new SQLException("Communication error:  Server closed communication device", "08S01", 461);
        }
        return len;
    }

    private int readBuffer(byte[] buffer, int offset, int count) throws SQLException, IOException {
        try {
            int cb;
            for (cb = 0; cb < count; cb += this.read(buffer, offset + cb, count - cb)) {
            }
            return cb;
        }
        catch (Exception e) {
            this.inputStream.close();
            throw new SQLException("Communication error: " + e.getMessage(), "08S01", 461);
        }
    }

    private int readBuffer(CacheBufferRO list) throws SQLException, IOException {
        try {
            int cb;
            int count = list.Header.getMessageLength();
            int offset = list.getEndLength();
            for (cb = 0; cb < count; cb += this.read(list.getTCPBuffer(), offset + cb, count - cb)) {
            }
            return cb;
        }
        catch (Exception e) {
            this.inputStream.close();
            throw new SQLException("Communication error: " + e.getMessage(), "08S01", 461);
        }
    }

    private void checkHeader(CacheMsgHeader header, int stmt_id, int msgCount) throws SQLException, IOException {
        this.readBuffer(header.hBuffer, 0, 14);
        if (header.getCount() != msgCount) {
            this.invalidMessageReceived(header);
        }
        if (stmt_id != 0 && stmt_id != header.getStatementID()) {
            this.inputStream.close();
            throw new SQLException("Invalid Statement Number (452); expected: " + stmt_id + " got: " + header.getStatementID() + ". Connection closed", "08S01", 452);
        }
    }

    int readMessage(CacheStatement stmt, int type, int allowError) throws SQLException {
        int stmt_id = stmt.serverCursorNumber;
        if (this.connection.activeFetchStatement != null && (this.connection.activeFetchStatement != stmt || this.connection.activeFetchStatement == stmt && type < 2) && this.connection.activeFetchStatement.weakResultSetReference != null && !this.connection.activeFetchStatement.fetchDone) {
            ((CacheResultSet)this.connection.activeFetchStatement.weakResultSetReference.get()).readOOBFetch();
        }
        if (type == 2 && stmt != null && stmt.resultSetType == 1004) {
            type = 0;
        }
        int ret = this.readMessage(stmt, stmt_id, type, allowError, type == 2);
        this.connection.activeFetchStatement = type == 2 && ret == 0 ? stmt : null;
        return ret;
    }

    int readMessage(int stmt_id, int type, int allowError) throws SQLException {
        this.connection.checkOutStandingFetches();
        return this.readMessage(null, stmt_id, type, allowError, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readMessage(Object inObj, int stmt_id, int type, int allowError, boolean requestData) throws SQLException {
        int highBit = 1;
        CacheMsgHeader header = new CacheMsgHeader();
        try {
            if (type == 1) {
                Stream cstream = (Stream)inObj;
                int MessageLength = 0;
                cstream.RawBytesPtr = 0;
                while (highBit != 0) {
                    this.checkHeader(header, stmt_id, this.connection.messageCount.count);
                    MessageLength = header.getMessageLength();
                    highBit = header.getHighBit();
                    if (MessageLength == 0) {
                        if (this.logFile == null || highBit != 0) break;
                        this.logFile.dump(null, 0, 0, 0, header.hBuffer);
                        break;
                    }
                    MessageLength = this.readStream(header, cstream);
                }
                if (header.getError() == 403) {
                    throw new SQLException("Null stream 403 error! ", "S1000", header.getError());
                }
            } else {
                CacheBufferRO list = null;
                CacheStatement stmt = (CacheStatement)inObj;
                int msgCount = 0;
                if (stmt != null && stmt.outstandingReads > 0) {
                    msgCount = stmt.nextServerNumber;
                    --stmt.outstandingReads;
                } else if (this.connection != null) {
                    msgCount = this.connection.messageCount.count;
                }
                while (highBit != 0) {
                    this.checkHeader(header, stmt_id, msgCount);
                    if (stmt != null && stmt.canceled && header.getError() == 0) {
                        header.setError(100);
                    }
                    if (requestData && header.getError() == 0 && stmt != null && stmt.weakResultSetReference != null) {
                        ((CacheResultSet)stmt.weakResultSetReference.get()).requestFetch(stmt.connection.messageCount.getCount());
                        requestData = false;
                    }
                    highBit = header.getHighBit();
                    if (list == null) {
                        list = new CacheBufferRO(this.wire, header, this.locale, type == 2);
                    } else {
                        list.growBuffer(header);
                    }
                    list.addToEndLength(this.readBuffer(list));
                    if (this.logFile == null || highBit != 0) continue;
                    this.logFile.dump(list, 0);
                }
                if (type == 3) {
                    this.messages.add(list);
                } else {
                    InStream inStream = this;
                    synchronized (inStream) {
                        this.wire = list;
                    }
                }
            }
            int error = header.getError();
            if (error != 0) {
                try {
                    if (this.connection == null) {
                        return error;
                    }
                    return this.connection.processError(error, allowError);
                }
                catch (Exception e) {
                    if (!this.messages.isEmpty()) {
                        this.messages.remove();
                    }
                    throw e;
                }
            }
            return 0;
        }
        catch (IOException e) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw new SQLException("Communication error:  Server closed communication device", "08S01", 461);
        }
    }

    private int readStream(CacheMsgHeader header, Stream cstream) throws SQLException, IOException {
        int RawBytesPtr = cstream.RawBytesPtr;
        int MessageLength = header.getMessageLength();
        if (RawBytesPtr + MessageLength > cstream.RawBytes.length) {
            byte[] b = new byte[RawBytesPtr + MessageLength];
            if (RawBytesPtr > 0) {
                CacheBufferUtils.copyByteArray(cstream.RawBytes, 0, b, 0, RawBytesPtr);
            }
            cstream.RawBytes = b;
        }
        int cb = this.readBuffer(cstream.RawBytes, RawBytesPtr, MessageLength);
        RawBytesPtr += cb;
        if (this.logFile != null) {
            this.logFile.dump(cstream.RawBytes, RawBytesPtr - MessageLength, MessageLength, 0, header.hBuffer);
        }
        cstream.RawBytesPtr = RawBytesPtr;
        return cb;
    }

    private void invalidMessageReceived(CacheMsgHeader header) throws SQLException, IOException {
        if (this.logFile != null && header.getHighBit() == 0) {
            this.logFile.dump(header, 0);
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            } else {
                this.inputStream.close();
            }
        }
        catch (SQLException e) {
            this.inputStream.close();
            throw new SQLException("Communication error: " + e.getMessage(), "08S01", 461);
        }
        if (this.connection == null) {
            throw new SQLException("Invalid Header, count: " + header.getCount() + ". Connection closed", "08S01", 452);
        }
        throw new SQLException("Invalid Message Count (452); expected: " + this.connection.messageCount.count + " got: " + header.getCount() + ". Connection closed", "08S01", 452);
    }

    public int readMessage() throws SQLException {
        return ((0xFF00 & this.readMessage(null, 0, 0, -1, false)) >> 8) - 48;
    }

    public boolean checkSHeader(byte[] hash, Socket sock) throws SQLException, IOException, NoSuchAlgorithmException {
        CacheMsgHeader sheader = new CacheMsgHeader();
        try {
            int timeout = sock.getSoTimeout();
            sock.setSoTimeout(5000);
            this.readBuffer(sheader.hBuffer, 0, 14);
            sock.setSoTimeout(timeout);
        }
        catch (Exception e) {
            if (this.logFile != null) {
                this.logFile.logApi(e.getMessage());
            }
            return false;
        }
        if (this.logFile != null) {
            this.logFile.dump(sheader, 0);
        }
        if (sheader.getMessageLength() != 0 || sheader.getError() != 0) {
            return false;
        }
        byte[] headerBytes = CacheBufferUtils.copyByteArray(sheader.hBuffer, 4, 8);
        byte[] inHash = MessageDigest.getInstance("SHA-256").digest(headerBytes);
        if (hash.length != inHash.length) {
            return false;
        }
        for (int i = 0; i < hash.length; ++i) {
            if (hash[i] == inHash[i]) continue;
            return false;
        }
        return true;
    }

    public final int readHeaderXEP(boolean read_data) throws SQLException, Exception {
        this.wire.clearList();
        this.readBuffer(this.wire.Header.hBuffer, 0, 14);
        int MessageLength = this.wire.Header.getMessageLength();
        int error = this.wire.Header.getError();
        if (error != 1 && error != 0) {
            if (MessageLength > 0) {
                this.wire.setBuffer(this.wire.Header);
                this.readBuffer(this.wire);
                if (this.logFile != null) {
                    this.logFile.dump(this.wire, 0);
                }
                throw new Exception(this.wire.getString());
            }
            if (this.logFile != null) {
                this.logFile.dump(this.wire.Header, 0);
            }
            throw new Exception("XEPError occured: " + error);
        }
        if (read_data) {
            if (MessageLength > 0) {
                this.wire.setBuffer(this.wire.Header);
                this.readBuffer(this.wire);
            }
            if (this.logFile != null) {
                this.logFile.dump(this.wire, 0);
            }
        }
        if (MessageLength == 0 && this.logFile != null) {
            this.logFile.dump(this.wire.Header, 0);
        }
        return error;
    }

    byte[] readBytesXEP() throws SQLException, Exception {
        this.readHeaderXEP(false);
        return this.readBytesXEP(this.wire.Header.getMessageLength());
    }

    private byte[] readBytesXEP(int len) throws SQLException, IOException {
        byte[] ba = new byte[len];
        this.readBuffer(ba, 0, len);
        if (this.logFile != null) {
            this.logFile.dump(ba, 0, len, 0, this.wire.Header.hBuffer);
        }
        return ba;
    }

    List<byte[]> readListofByteArraysXEP2() throws Exception {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        while (true) {
            this.readHeaderXEP(true);
            if (this.wire.Header.getMessageLength() == 0) break;
            byteArrays.add(this.wire.getTCPBuffer());
        }
        return byteArrays;
    }
}

