/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferRO;
import com.intersys.jdbc.CacheBufferWrite;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheListReader;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheResultSetRow;
import com.intersys.jdbc.CacheStaticResultSet;
import com.intersys.jdbc.CacheUpdatableResultSet;
import com.intersys.jdbc.CacheWrapper;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ExecParameter;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.PreparserInterface;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.preparser.Parser;
import com.intersys.jdbc.preparser2.StatementTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CacheStatement
extends CacheWrapper
implements Statement {
    boolean shardedInsert = false;
    boolean addToServerCache = false;
    int maxRows = 0;
    boolean genericExecuteCalled = false;
    CacheConnection connection;
    CacheResultSet myResultSet = null;
    List<Column> columns;
    int columnsOnWire = 0;
    List<Parameter> parameters;
    boolean hasStreamParameters = false;
    public int serverCursorNumber = 0;
    int statementType;
    boolean fetchDone = false;
    InStream input;
    OutStream output;
    String sqlText;
    String originalSqlText;
    int hasReturnValue;
    int resultSetType = 1003;
    int resultSetConcurrency;
    int fetchSize = 0;
    int parameterSets = 0;
    int batchCount = 0;
    CacheBufferWrite batch = null;
    CacheListBuilder additionalParameterInfo;
    CacheListReader outputParameterList;
    CacheResultSetRow paramRow;
    String batchException = "none";
    boolean closed = false;
    boolean canceled = false;
    int updateCnt;
    String autoGeneratedKeyColumn = null;
    boolean multipleResultSets = false;
    int queryTimeout = 0;
    String updatableRSTableName = null;
    String[] updatableRSColumnNames = null;
    boolean poolable = true;
    boolean namedParameters = false;
    List<ExecParameter> execParams = null;
    static final int NO_RETURN_VALUE = 0;
    static final int IGNORE_RETURN_VALUE = 1;
    static final int HAS_RETURN_VALUE = 2;
    static final int NULL_RETURN_VALUE = 3;
    static final String BATCH_EXCEPTION_NONE = "none";
    static final String BATCH_EXCEPTION_QUERY = "query";
    static final String BATCH_EXCEPTION_SP = "stored procedure";
    boolean parameterListMismatchException = false;
    int sqlDialect = 0;
    private boolean closeOnCompletion = false;
    WeakReference<CacheResultSet> weakResultSetReference = null;
    int outstandingReads = 0;
    int nextServerNumber = 0;
    int maxFieldSize = 0;
    static final int FLAG_STATEMENT_CACHED = 1;
    static final int FLAG_SHARDED_INSERT = 2;
    static final int UPDATE = 0;
    static final int QUERY = 1;
    static final int CALL = 2;
    static final int SYNC_COMMIT = 3;
    static final int ASYNC_COMMIT = 4;
    static final int STREAMS_OFF = 5;
    static final int STREAMS_ON = 6;
    static final int CALLWITHRESULT = 7;
    static final int DDL_ALTER_DROP = 8;
    static final int DDL_OTHER = 9;
    static final int DIRECT_CALL_QUERY = 10;
    static final int DIRECT_CALL_UPDATE = 11;
    static final int PREPARED_CALL_QUERY = 12;
    static final int PREPARED_CALL_UPDATE = 13;
    static final int SQL_DIALECT = 14;
    static final int STMT_USE = 15;

    CacheStatement(CacheConnection conn, int rst, int rsc, String agk) throws SQLException {
        this.connection = conn;
        this.sqlDialect = this.connection.getSQLDialect();
        this.parameters = new ArrayList<Parameter>();
        try {
            this.input = new InStream(this.connection);
            this.input.setLocale(this.connection);
            this.output = new OutStream(this.connection);
            this.output.wire.setConnectionInfo(this.connection.connectionInfo);
        }
        catch (IOException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
        this.resultSetType = rst;
        this.resultSetConcurrency = rsc;
        this.serverCursorNumber = 0;
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = agk;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (sql.equals("**getQuickStatement**")) {
            this.columns = new ArrayList<Column>();
            return this.createNewResultSet();
        }
        this.genericExecuteCalled = false;
        this.Query(sql);
        if (this.multipleResultSets) {
            this.columnInfo(this.input.wire);
        }
        this.updateCnt = -1;
        return this.myResultSet;
    }

    void createResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        this.myResultSet = this.resultSetConcurrency == 1008 ? new CacheUpdatableResultSet(this) : (this.resultSetType == 1004 ? new CacheStaticResultSet(this) : new CacheResultSet(this));
    }

    CacheResultSet createNewResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        this.myResultSet = new CacheResultSet(this);
        return this.myResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Query(String sql) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(sql);
        }
        this.fetchDone = false;
        if (this.statementType != 1 && this.statementType != 2 && this.statementType != 14) {
            throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == 11 || this.statementType == 13) {
                throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
            }
            if (this.statementType == 10 || this.statementType == 12) {
                this.storedProcedureQuery();
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType != 10) {
                throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
            }
            return;
        }
        if (this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (this.resultSetType == 1004) {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_STATIC_CURSOR);
                } else {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_QUERY_EXECUTE);
                }
                this.writeParameters(this.output.wire);
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
                this.output.send(this.connection.messageCount.getCount());
                this.handleError504(this.input.readMessage(this, 2, 504));
            }
        } else {
            this.sendDirectQueryRequest();
        }
    }

    void handleError504(int err) throws SQLException {
        if (err == 404) {
            this.query404();
        } else if (err == 100) {
            this.fetchDone = true;
            if (this.hasStreamColumns()) {
                this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    void bindExecParameters() throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            ExecParameter execParam = this.getExecParamByName(parameter.name);
            if (execParam != null) {
                if (execParam.mode == 0) continue;
                parameter.mode = execParam.mode;
                if (execParam.mode != 4) {
                    parameter.bind(execParam.value, null, this.parameterSets);
                } else {
                    parameter.bound = execParam.bound;
                }
                if (execParam.scale == -1) continue;
                parameter.scale = execParam.scale;
                continue;
            }
            if (parameter.mode != 0) continue;
            parameter.mode = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sendDirectQueryRequest() throws SQLException {
        int error;
        if (this.statementType == 14) {
            this.directExecuteDialect();
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                if (this.serverCursorNumber != this.connection.nextServerCursorNumber || this.serverCursorNumber < 1) {
                    this.serverCursorNumber = this.connection.getServerCursorNumber();
                }
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STATIC_CURSOR);
            } else {
                this.serverCursorNumber = this.connection.getServerCursorNumber();
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_QUERY);
            }
            this.output.wire.setSQLText(this.sqlText);
            if (this.connection.protocolVersion >= 45) {
                this.output.wire.append(this.additionalParameterInfo);
            }
            this.writeParameters(this.output.wire);
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.nextServerNumber = this.connection.messageCount.getCount();
            this.output.send(this.nextServerNumber);
            error = this.input.readMessage(this, 0, 100);
            this.columnInfo(this.input.wire);
            this.parameterInfo(this.input.wire);
            this.createResultSet();
            if (this.resultSetType != 1003) {
                if (error == 100) {
                    this.fetchDone = true;
                    if (this.connection.protocolVersion >= 44) {
                        this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                    }
                }
                return;
            }
            error = this.input.readMessage(this, 2, 100);
        }
        if (error == 100) {
            this.fetchDone = true;
        }
        if (this.connection.connectionInfo.protocolVersion > 50) {
            if (this.addToServerCache) {
                this.connection.addCachedPrepare(this, !this.fetchDone || this.hasStreamColumns());
            } else if (this.connection.protocolVersion >= 44) {
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
            }
        } else {
            this.connection.addCachedPrepare(this, !this.fetchDone || this.hasStreamColumns());
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update(sql);
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == 15) {
            this.connection.cachedPrepares.clear();
        }
        return this.updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Update(String sql) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(sql);
        }
        if (this.statementType == 1) {
            throw new SQLException("executeUpdate called with a query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == 11 || this.statementType == 13) {
                this.storedProcedureUpdate();
            } else if (this.statementType == 10 || this.statementType == 12) {
                throw new SQLException("executeUpdate called with a query.", "24000", 24000);
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType == 10) {
                throw new SQLException("executeUpdate called with a query.", "24000", 24000);
            }
            return;
        }
        if (this.statementType != 8 && this.statementType != 9 && this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_UPDATE_EXECUTE);
                this.output.wire.set(this.autoGeneratedKeyColumn);
                if (this.connection.protocolVersion >= 42) {
                    this.output.wire.set(0);
                }
                this.writeParameters(this.output.wire);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readMessage(this, 0, 504) == 404) {
                    this.update404();
                }
            }
        } else {
            this.sendDirectUpdateRequest();
        }
        this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectUpdateRequest() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_UPDATE);
            this.output.wire.setSQLText(this.sqlText);
            if (this.connection.protocolVersion >= 45) {
                this.output.wire.append(this.additionalParameterInfo);
            }
            this.output.wire.set(this.autoGeneratedKeyColumn);
            if (this.connection.protocolVersion >= 42) {
                this.output.wire.set(0);
            }
            this.writeParameters(this.output.wire);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readMessage(this, 0, 100);
            }
            catch (SQLException sqlEx) {
                try {
                    this.parameterInfo(this.input.wire);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sqlEx;
            }
            this.parameterInfo(this.input.wire);
        }
        if (this.connection.connectionInfo.protocolVersion > 50) {
            if (this.addToServerCache) {
                this.connection.addCachedPrepare(this, false);
            } else if (this.connection.protocolVersion >= 44) {
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
            }
        } else if (this.statementType != 8 && this.statementType != 9) {
            this.connection.addCachedPrepare(this, false);
        } else if (this.connection.protocolVersion >= 44) {
            this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object object;
        if (this.closed) {
            return;
        }
        if (this.connection.protocolVersion >= 40 && this.statementType != 0 && (this.connection.noOwner(this.serverCursorNumber) || this.connection.isOwner(this.serverCursorNumber, this))) {
            object = this.connection.messageCount;
            synchronized (object) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.CLOSE_STATEMENT);
                this.output.send(this.connection.messageCount.getCount());
            }
            if (this.connection.protocolVersion >= 44) {
                this.connection.cachedPrepares.remove(this.serverCursorNumber);
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
            }
        }
        object = this;
        synchronized (object) {
            while (this.outstandingReads > 0) {
                this.input.readMessage(this, 3, -1);
                --this.outstandingReads;
            }
            this.fetchDone = false;
            this.genericExecuteCalled = false;
            this.maxRows = 0;
            this.fetchSize = 0;
            this.parameterSets = 0;
            this.batchCount = 0;
            this.batch = null;
            this.batchException = BATCH_EXCEPTION_NONE;
            if (this.parameters != null) {
                this.parameters.clear();
            }
            this.hasStreamParameters = false;
            if (this.columns != null) {
                this.columns.clear();
            }
            if (this.myResultSet != null) {
                this.myResultSet.close();
                this.myResultSet = null;
            }
            if (!this.connection.isClosed()) {
                this.connection.markAsBeingClosed(this.serverCursorNumber, this);
                this.connection.poolStatement(this);
            }
            this.updateCnt = 0;
            this.autoGeneratedKeyColumn = null;
            this.updatableRSTableName = null;
            this.updatableRSColumnNames = null;
            this.multipleResultSets = false;
            this.sqlText = null;
            this.serverCursorNumber = 0;
            this.statementType = 0;
            this.namedParameters = false;
            this.parameterListMismatchException = false;
            if (this.outputParameterList != null) {
                this.outputParameterList.clearList();
            }
            this.execParams = null;
            this.closed = true;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
        OutStream outStream = this.output;
        synchronized (outStream) {
            this.output.wire.setMaxFieldSize(max);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Invalid number of rows specified: " + max, "S1000");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.connection.protocolVersion <= 50) {
            throw new SQLFeatureNotSupportedException();
        }
        this.canceled = true;
        this.connection.cancelStatement(this);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    private synchronized boolean executeStoredProcedure() throws SQLException {
        if (this.getCachedInfo(this.sqlText)) {
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.storedProcedureUpdate();
                return false;
            }
            this.storedProcedureQuery();
            return true;
        }
        return this.directExecuteStoredProcedure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean directExecuteStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            if (this.connection.protocolVersion >= 42) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion < 42) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 100);
            try {
                this.processStoredProcedureMetaData(this.input.wire, true);
            }
            catch (SQLException ex) {
                if (this.parameterListMismatchException && (this.statementType == 1 || this.statementType == 10 || this.statementType == 12)) {
                    this.input.readMessage(this, 0, 100);
                }
                throw ex;
            }
            this.connection.addCachedPrepareNoUpdate(this, true);
            if (error == 100) {
                this.handleError100(100);
                return true;
            }
            if (this.multipleResultSets) {
                return this.executeMultipleResultSets(false);
            }
            this.getOutputParameters(this.input.wire);
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
                return false;
            }
            if (this.resultSetType == 1003) {
                this.handleError100(this.input.readMessage(this, 2, 100));
            }
            return true;
        }
    }

    void handleError100(int err) throws SQLException {
        if (err == 100) {
            this.fetchDone = true;
            if (this.hasStreamColumns()) {
                this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.cleanUp();
        this.updateCnt = 0;
        this.preparse(sql);
        this.genericExecuteCalled = true;
        if (this.statementType == 1 || this.statementType == 14) {
            this.Query(sql);
            this.updateCnt = -1;
            return true;
        }
        if (this.statementType == 7) {
            throw new SQLException("No output parameters allowed.");
        }
        if (this.statementType == 2) {
            if (this.executeStoredProcedure()) {
                return true;
            }
            if (this.parameterSets == 0) {
                this.updateCnt = this.input.wire.getInt();
            }
            return false;
        }
        this.Update(sql);
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == 15) {
            this.connection.cachedPrepares.clear();
        }
        return false;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (!this.genericExecuteCalled || this.statementType != 1 && this.statementType != 10 && this.statementType != 12 && this.statementType != 14) {
            return null;
        }
        if (this.multipleResultSets) {
            if (this.myResultSet == null && this.updateCnt == -1 && this.statementType != 14) {
                return null;
            }
            this.columnInfo(this.input.wire);
        } else {
            this.genericExecuteCalled = false;
        }
        if (this.myResultSet == null) {
            this.createResultSet();
        }
        return this.myResultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.statementType == 1 || this.statementType == 10 || this.statementType == 12) {
            return -1;
        }
        if (!this.multipleResultSets) {
            this.genericExecuteCalled = false;
        }
        int uc = this.updateCnt;
        this.updateCnt = -1;
        return uc;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    int getColumnType(int column) {
        return this.columns.get((int)(column - 1)).type;
    }

    String getColumnName(int column) {
        return this.columns.get((int)(column - 1)).name;
    }

    String getColumnLabel(int column) {
        return this.columns.get((int)(column - 1)).label;
    }

    String getColumnTableName(int column) {
        return this.columns.get((int)(column - 1)).tableName;
    }

    String getColumnSchemaName(int column) {
        return this.columns.get((int)(column - 1)).schema;
    }

    String getColumnCatalogName(int column) {
        return this.columns.get((int)(column - 1)).catalog;
    }

    int getColumnPrecision(int column) {
        return this.columns.get((int)(column - 1)).precision;
    }

    int getColumnScale(int column) {
        return this.columns.get((int)(column - 1)).scale;
    }

    int getColumnNullable(int column) {
        return this.columns.get((int)(column - 1)).nullable;
    }

    boolean isReadOnly(int column) {
        return this.columns.get((int)(column - 1)).isReadOnly;
    }

    boolean isAutoIncrement(int column) {
        return this.columns.get((int)(column - 1)).isAutoIncrement;
    }

    boolean isRowId(int column) {
        return this.columns.get((int)(column - 1)).isRowId;
    }

    boolean isCaseSensitive(int column) {
        return this.columns.get((int)(column - 1)).isCaseSensitive;
    }

    boolean isCurrency(int column) {
        return this.columns.get((int)(column - 1)).isCurrency;
    }

    int getParameterScale(int parameter) {
        return this.parameters.get((int)parameter).scale;
    }

    int getParameterPrecision(int parameter) {
        return this.parameters.get((int)parameter).precision;
    }

    int getParameterMode(int parameter) {
        return this.parameters.get((int)parameter).mode;
    }

    Parameter getParameter(int i) throws SQLException {
        return this.parameters.get(this.getAbsolutePosition(i));
    }

    boolean isOutParameter(int parameter) {
        int mode = this.parameters.get((int)parameter).mode;
        return mode == 2 || mode == 4;
    }

    private void isNotDefaultOrReplaced(int parameter) throws SQLException {
        int mode = this.parameters.get((int)parameter).mode;
        if (mode != 5 && mode != 6) {
            throw new SQLException("Parameters not allowed in Statement class.", "07001", 7001);
        }
    }

    private int getAbsolutePosition(int parameter) throws SQLException {
        --parameter;
        int k = 0;
        int j = 0;
        if (this.hasReturnValue == 1) {
            j = 1;
        }
        while (j < this.parameters.size()) {
            if (this.parameters.get((int)j).mode != 5) {
                if (parameter == k) {
                    return j;
                }
                ++k;
            }
            ++j;
        }
        throw new SQLException("Invalid parameter number: " + parameter, "S1093", 466);
    }

    int getParameterTypeAbsolute(int i) throws SQLException {
        return this.parameters.get((int)this.getAbsolutePosition((int)i)).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterModeAndScale(int parameter, int scale) {
        this.setParameterMode(parameter);
        List<Parameter> list = this.parameters;
        synchronized (list) {
            this.parameters.get((int)parameter).scale = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterMode(int parameter) {
        List<Parameter> list = this.parameters;
        synchronized (list) {
            Parameter par = this.parameters.get(parameter);
            par.mode = par.mode == 1 || par.mode == 2 ? 2 : 4;
            par.bound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindParameter(int i) throws SQLException {
        List<Parameter> list = this.parameters;
        synchronized (list) {
            Parameter par = this.parameters.get(i);
            if (par.mode != 5 && par.mode != 6) {
                par.bound = false;
                par.mode = 0;
                par.values.clear();
                par.whatever.clear();
            }
        }
    }

    synchronized void multipleResultSetsMetaData(CacheBufferRO wire, boolean serverHasReturn, boolean directExecute) throws SQLException {
        this.multipleResultSets = true;
        if (!this.storedProcedureParameterInfo(wire, serverHasReturn, directExecute)) {
            throw new SQLException("Parameter list mismatch.", "07001", 7001);
        }
        this.statementType = this instanceof CacheCallableStatement ? 1 : (this instanceof CachePreparedStatement ? 12 : 10);
    }

    synchronized void processStoredProcedureMetaData(CacheBufferRO wire, boolean directExecute) throws SQLException {
        this.statementType = wire.getInt();
        if (this.statementType < 0) {
            if (this.statementType == -1) {
                this.multipleResultSetsMetaData(wire, false, directExecute);
            } else {
                this.multipleResultSetsMetaData(wire, true, directExecute);
            }
            return;
        }
        if (this.statementType % 2 == 1) {
            this.columnInfo(wire);
        }
        if (!this.storedProcedureParameterInfo(wire, this.statementType > 1, directExecute)) {
            if (directExecute && this.statementType % 2 == 1) {
                if (this.resultSetType == 1003) {
                    this.handleError100(this.input.readMessage(this, 2, 100));
                }
                this.input.wire.moveToEnd();
            }
            if (directExecute) {
                throw new SQLException("Parameter list mismatch.", "07001", 7001);
            }
        }
        if (directExecute && this.parameterListMismatchException) {
            throw new SQLException("Parameter list mismatch.", "07001", 7001);
        }
        if (this instanceof CacheCallableStatement) {
            this.statementType %= 2;
            return;
        }
        if (this instanceof CachePreparedStatement) {
            this.statementType = this.statementType % 2 == 1 ? 12 : 13;
            return;
        }
        this.statementType = this.statementType % 2 == 1 ? 10 : 11;
    }

    void columnInfo(CacheBufferRO wire) throws SQLException {
        int cnt = wire.getInt();
        this.columns = new ArrayList<Column>(cnt);
        if (cnt <= 0) {
            return;
        }
        this.columnsOnWire = this.connection.protocolVersion > 152 ? wire.getInt() : cnt;
        for (int i = 1; i <= cnt; ++i) {
            Column temp = new Column();
            temp.name = wire.getString();
            temp.type = wire.getInt();
            switch (temp.type) {
                case 9: {
                    temp.type = 91;
                    break;
                }
                case 10: {
                    temp.type = 92;
                    break;
                }
                case 11: {
                    temp.type = 93;
                    break;
                }
            }
            temp.precision = wire.getInt();
            temp.scale = wire.getInt();
            temp.nullable = wire.getInt();
            temp.label = wire.getString();
            temp.tableName = wire.getString();
            temp.schema = wire.getString();
            temp.catalog = wire.getString();
            temp.listOrder = this.connection.protocolVersion > 152 ? wire.getInt() : i;
            if (this.connection.protocolVersion > 40) {
                String additionalMD = wire.getString();
                temp.isAutoIncrement = additionalMD.charAt(0) == '\u0001';
                temp.isCaseSensitive = additionalMD.charAt(1) == '\u0001';
                temp.isCurrency = additionalMD.charAt(2) == '\u0001';
                boolean bl = temp.isReadOnly = additionalMD.charAt(3) == '\u0001';
                if (additionalMD.length() >= 12) {
                    temp.isRowId = additionalMD.charAt(11) == '\u0001';
                }
            }
            this.columns.add(temp);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean storedProcedureParameterInfo(CacheBufferRO wire, boolean serverHasReturn, boolean directExecute) throws SQLException {
        int count;
        block17: {
            int size;
            block21: {
                block23: {
                    block22: {
                        block19: {
                            block20: {
                                block18: {
                                    count = wire.getInt();
                                    if (!(this instanceof CacheCallableStatement) && this.hasReturnValue == 1) {
                                        wire.moveToEnd();
                                        return false;
                                    }
                                    if (this.execParams == null) break block18;
                                    for (size = this.parameters.size(); size < count; ++size) {
                                        this.parameters.add(0, new Parameter());
                                    }
                                    if (serverHasReturn) {
                                        this.hasReturnValue = 1;
                                    }
                                    break block17;
                                }
                                if (size != count) break block19;
                                if (!serverHasReturn || this.hasReturnValue != 2) break block20;
                                this.hasReturnValue = 2;
                                break block17;
                            }
                            if (!serverHasReturn && this.hasReturnValue == 0) {
                                this.hasReturnValue = 0;
                                break block17;
                            } else if (size == 1 && count == 1 && this.getParameterMode(0) == 6 && this.hasReturnValue == 0 && serverHasReturn || this.getParameterMode(0) == 0 && this.hasReturnValue == 1 && serverHasReturn) {
                                this.parameters.remove(0);
                                this.parameters.add(0, new Parameter());
                                this.hasReturnValue = 1;
                                break block17;
                            } else {
                                wire.moveToEnd();
                                return false;
                            }
                        }
                        if (size != count + 1) break block21;
                        if (serverHasReturn || this.hasReturnValue != 2) break block22;
                        this.hasReturnValue = 3;
                        break block17;
                    }
                    if ((size != 2 || count != 1) && (size != 1 || count != 0)) break block23;
                    if (this.getParameterMode(size - 1) != 6) {
                        wire.moveToEnd();
                        return false;
                    }
                    if (serverHasReturn && this.hasReturnValue == 2) {
                        this.parameters.remove(size - 1);
                        this.hasReturnValue = 2;
                        break block17;
                    } else if (!serverHasReturn && this.hasReturnValue == 0) {
                        this.parameters.remove(size - 1);
                        this.hasReturnValue = 0;
                        break block17;
                    } else {
                        wire.moveToEnd();
                        return false;
                    }
                }
                wire.moveToEnd();
                return false;
            }
            if (size == count - 1) {
                if (serverHasReturn && this.hasReturnValue == 0) {
                    this.parameters.add(0, new Parameter());
                    this.hasReturnValue = 1;
                    break block17;
                } else {
                    wire.moveToEnd();
                    return false;
                }
            }
            this.parameterListMismatchException = true;
            if (serverHasReturn && this.hasReturnValue == 0) {
                this.hasReturnValue = 1;
                Parameter par = new Parameter();
                par.mode = 4;
                this.parameters.add(0, par);
                ++size;
            }
            while (size < count) {
                this.parameters.add(new Parameter(1));
                ++size;
            }
        }
        this.readParameterData(wire, count, true);
        return true;
    }

    void parameterInfo(CacheBufferRO wire) throws SQLException {
        int cnt = wire.getInt();
        if (cnt != this.parameters.size()) {
            throw new SQLException("Invalid number of parameters.", "07001", 7001);
        }
        this.readParameterData(wire, cnt, false);
        if (this.connection.connectionInfo.protocolVersion > 50) {
            int flag = wire.getInt();
            this.addToServerCache = (flag & 1) == 1;
            this.shardedInsert = (flag & 2) == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readParameterData(CacheBufferRO wire, int cnt, boolean isStoredProcedure) throws SQLException {
        List<Parameter> list = this.parameters;
        synchronized (list) {
            int r = 0;
            if (this.hasReturnValue == 3) {
                ++r;
            }
            for (int i = 0; i < cnt; ++i) {
                Parameter par = this.parameters.get(i + r);
                par.type = wire.getInt();
                switch (par.type) {
                    case 9: {
                        par.type = 91;
                        break;
                    }
                    case 10: {
                        par.type = 92;
                        break;
                    }
                    case 11: {
                        par.type = 93;
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.hasStreamParameters = true;
                        break;
                    }
                }
                par.precision = wire.getInt();
                par.scale = wire.getInt();
                par.nullable = wire.getInt();
                if (!isStoredProcedure) continue;
                par.name = wire.getString();
                wire.getInt();
            }
        }
    }

    synchronized boolean getCachedInfo(String sql) throws SQLException {
        if (this.resultSetType != 1003) {
            return false;
        }
        boolean found = false;
        CacheConnection.CachedPrepare cp = null;
        for (Integer key : this.connection.cachedPrepares.keySet()) {
            cp = this.connection.cachedPrepares.get(key);
            if (cp == null || !cp.matches(this) || cp.ownedBy != null && cp.ownedBy != this) continue;
            found = true;
            break;
        }
        if (!found) {
            if (this.connection.cachedPrepares.size() >= 500) {
                this.connection.updateCache();
            }
            return false;
        }
        this.serverCursorNumber = cp.serverCursorNumber;
        if (this.serverCursorNumber == this.connection.recycledServerCursorNumber) {
            this.connection.recycledServerCursorNumber = -1;
        }
        if (this.statementType == 2 || this.statementType == 7) {
            if (this.parameters.size() != cp.parameters.size()) {
                if (this.statementType == 2 && this.hasReturnValue == 0 && cp.hasReturnValue == 1 && this.parameters.size() + 1 == cp.parameters.size()) {
                    this.parameters.add(0, new Parameter());
                } else {
                    return false;
                }
            }
            this.statementType = cp.statementType;
            this.hasReturnValue = cp.hasReturnValue;
            this.multipleResultSets = cp.multipleResultSets;
            if (!(this.multipleResultSets || this.statementType != 1 && this.statementType != 12 && this.statementType != 10)) {
                this.columns = new ArrayList<Column>(cp.columns);
                this.createResultSet();
            }
        } else if (this.statementType == 1) {
            this.columns = new ArrayList<Column>(cp.columns);
            this.createResultSet();
        }
        this.updateParameterInfo(cp.parameters);
        cp.ownedBy = this;
        return true;
    }

    PreparserInterface preparseAddID(String sql) throws SQLException {
        Parser preparser = this.connection.protocolVersion < 45 ? PreparserInterface.createPreparser(sql, this.connection.delimitedIds == 1, 1) : PreparserInterface.createPreparser(sql, this.connection.delimitedIds == 1, 2);
        try {
            ((PreparserInterface)preparser).preparse();
        }
        catch (Throwable th) {
            throw new SQLException("SQL preparser error:\n" + th.getMessage());
        }
        if (((PreparserInterface)preparser).getStatementType() != 1) {
            this.originalSqlText = sql;
            return preparser;
        }
        this.statementType = 1;
        this.updateParameters(preparser);
        this.sqlText = ((PreparserInterface)preparser).getPreparsedSQL();
        this.additionalParameterInfo = ((PreparserInterface)preparser).getParamInfo();
        this.originalSqlText = sql;
        return null;
    }

    void preparse(String sql, int stmtType, long paramCount) throws SQLException {
        this.statementType = stmtType;
        this.sqlText = sql;
        int k = 1;
        while ((long)k < paramCount) {
            this.parameters.add(new Parameter());
            ++k;
        }
    }

    private String stripSemiColon(String sql) {
        if (sql.contains(";")) {
            String tmpSql = sql.substring(0, sql.lastIndexOf(";"));
            if (sql.toUpperCase().contains("CREATE")) {
                if (sql.trim().endsWith(";")) {
                    return tmpSql;
                }
                return sql;
            }
            int len = tmpSql.length();
            if ((len - tmpSql.replace("\"", "").length()) % 2 != 0 || (len - tmpSql.replace("'", "").length()) % 2 != 0) {
                return sql;
            }
            String[] singleQuote = tmpSql.split("'", -1);
            StringBuilder tmpString = new StringBuilder();
            for (int s = 0; s < singleQuote.length; ++s) {
                if (s % 2 != 0) continue;
                tmpString.append(singleQuote[s]);
            }
            String[] doubleQuote = tmpString.toString().split("\"", -1);
            tmpString = new StringBuilder();
            for (int d = 0; d < doubleQuote.length; ++d) {
                if (d % 2 != 0) continue;
                tmpString.append(doubleQuote[d]);
            }
            if (tmpString.toString().replace("(", "").length() != tmpString.toString().replace(")", "").length()) {
                return sql;
            }
            return tmpSql;
        }
        return sql;
    }

    void preparse(String sql) throws SQLException {
        sql = this.stripSemiColon(sql);
        PreparserInterface preparser = null;
        CacheConnection.CachedSQL csql = this.connection.prePreparseCache.get(sql);
        if (csql != null && csql.resultSetConcurrency == this.resultSetConcurrency) {
            this.hasReturnValue = csql.hasReturnValue;
            this.createParameterInfo(csql.parameters);
            this.sqlText = csql.sqlText;
            this.statementType = csql.statementType;
            this.additionalParameterInfo = csql.additionalParameterInfo;
            return;
        }
        if (this.getSQLDialect() != 0) {
            this.statementType = 14;
            this.sqlText = sql;
            this.execParams = null;
            this.additionalParameterInfo = new CacheListBuilder(6, null);
            this.additionalParameterInfo.set(0);
            return;
        }
        if (this.resultSetConcurrency == 1008) {
            preparser = this.preparseAddID(sql);
            if (preparser == null) {
                return;
            }
            this.additionalParameterInfo = preparser.getParamInfo();
        }
        try {
            if (preparser == null) {
                preparser = PreparserInterface.createPreparser(sql, this.connection.delimitedIds == 1, 0);
                preparser.preparse();
                this.execParams = preparser.getExecParams();
                this.additionalParameterInfo = preparser.getParamInfo();
            }
            this.statementType = 0;
            switch (preparser.getStatementType()) {
                case 0: {
                    this.statementType = 0;
                    this.sqlText = sql;
                    return;
                }
                case 1: {
                    this.statementType = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.statementType = 0;
                    break;
                }
                case 5: {
                    this.statementType = 2;
                    this.hasReturnValue = 0;
                    break;
                }
                case 6: {
                    this.statementType = 7;
                    this.hasReturnValue = 2;
                    break;
                }
                case 12: {
                    this.statementType = 4;
                    break;
                }
                case 11: {
                    this.statementType = 3;
                    break;
                }
                case 13: {
                    this.statementType = 5;
                    break;
                }
                case 14: {
                    this.statementType = 6;
                    break;
                }
                case 9: {
                    this.statementType = 8;
                    this.sqlText = sql;
                    return;
                }
                case 10: {
                    this.statementType = 9;
                    this.sqlText = sql;
                    return;
                }
                case 15: {
                    this.statementType = 15;
                    this.sqlText = sql;
                    return;
                }
            }
            this.updateParameters(preparser);
            this.sqlText = preparser.getPreparsedSQL();
            this.connection.addPrePreparseCache(sql, this);
        }
        catch (Throwable th) {
            throw new SQLException("SQL preparser error:\n" + th.getMessage(), "42000", 51);
        }
    }

    void updateParameters(PreparserInterface preparser) {
        if (preparser.getParametersCount() == 0) {
            return;
        }
        block5: for (StatementTypes.Parameter parameter : preparser.getParameters()) {
            switch (parameter.type) {
                case '?': {
                    this.parameters.add(new Parameter());
                    continue block5;
                }
                case 'd': {
                    this.parameters.add(new Parameter(6));
                    continue block5;
                }
                case 'c': {
                    this.parameters.add(new Parameter(parameter.value));
                    continue block5;
                }
            }
            throw new Error("Should not have gotten here...");
        }
    }

    void validateParameters() throws SQLException {
        if (this.parameterListMismatchException && !this.namedParameters) {
            throw new SQLException("Parameter list mismatch.", "07001", 7001);
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.isNotDefaultOrReplaced(i);
        }
    }

    synchronized void writeParameters(CacheBufferWrite wire) throws SQLException {
        int sets = this.parameterSets;
        if (this.parameterSets == 0) {
            sets = 1;
        }
        wire.set(sets);
        wire.set(this.parameters.size());
        for (int j = 0; j < sets; ++j) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter par = this.parameters.get(i);
                if (par.mode == 5) {
                    wire.setParameter(par.values.get(0), par.type);
                    continue;
                }
                if (par.mode == 6) {
                    wire.setUndefined();
                    continue;
                }
                if (par.whatever != null && j < par.whatever.size() && par.whatever.get(j) != null) {
                    wire.setParameter(par.values.get(j), par.whatever.get(j), par.type);
                    continue;
                }
                if (par.values.get(j) instanceof StreamWrapper) {
                    wire.setParameter(this.sendStream(i, (StreamWrapper)par.values.get(j)), par.type);
                    continue;
                }
                wire.setParameter(par.values.get(j), par.type);
            }
        }
    }

    synchronized Object sendStream(int parameterIndex, StreamWrapper s) throws SQLException {
        int length = s.length;
        int jdbcType = this.parameters.get((int)parameterIndex).type;
        try {
            int maxFieldSize;
            int available;
            if (s.type != 4 && (available = ((InputStream)s.data).available()) > 0 && (length < 0 || length > available)) {
                length = available;
            }
            if ((maxFieldSize = this.output.wire.getMaxFieldSize()) != 0 && length > maxFieldSize) {
                length = maxFieldSize;
            }
            if (length == 0) {
                return "";
            }
            if (jdbcType != -1 && jdbcType != -4) {
                return FakeStream.sendStream(s.data, length, s.type);
            }
            return RealStream.sendStream(this.connection, s.data, length, s.type, jdbcType, this.serverCursorNumber);
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    synchronized void cleanUp() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.namedParameters = false;
        this.hasStreamParameters = false;
        this.parameterListMismatchException = false;
        this.multipleResultSets = false;
        this.fetchDone = false;
        this.genericExecuteCalled = false;
        this.parameterSets = 0;
        this.updateCnt = 0;
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
        this.execParams = null;
        this.statementType = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void query404() throws SQLException {
        this.connection.cachedPrepares.remove(this.serverCursorNumber);
        CacheStatement cacheStatement = this;
        synchronized (cacheStatement) {
            this.validateParameters();
            if (this instanceof CacheCallableStatement || this.statementType == 12 || this.statementType == 10) {
                this.directExecuteStoredProcedure();
            } else {
                this.sendDirectQueryRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update404() throws SQLException {
        this.connection.cachedPrepares.remove(this.serverCursorNumber);
        CacheStatement cacheStatement = this;
        synchronized (cacheStatement) {
            this.validateParameters();
            this.resetStreams();
            if (this instanceof CacheCallableStatement || this.statementType == 13 || this.statementType == 11) {
                this.directExecuteStoredProcedure();
            } else {
                this.sendDirectUpdateRequest();
            }
        }
    }

    synchronized void resetStreams() throws SQLException {
        try {
            int sets = this.parameterSets;
            if (this.parameterSets == 0) {
                sets = 1;
            }
            for (int j = 0; j < sets; ++j) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter par = this.parameters.get(i);
                    if (par.whatever == null || j >= par.whatever.size() || par.whatever.get(j) != null || !(par.values.get(j) instanceof StreamWrapper)) continue;
                    StreamWrapper stream = (StreamWrapper)par.values.get(j);
                    if (stream.type == 0 || stream.type == 1) {
                        ((InputStream)stream.data).reset();
                        continue;
                    }
                    if (stream.type != 4) continue;
                    ((Reader)stream.data).reset();
                }
            }
        }
        catch (IOException e) {
            throw new SQLException("Unable to complete a 404-logic request as the statement includes stream data");
        }
    }

    synchronized void getOutputParameters(CacheBufferRO roList) throws SQLException {
        int beg = roList.getOffset();
        int i = 0;
        if (this.hasReturnValue == 3) {
            ++i;
        }
        while (i < this.parameters.size()) {
            block8: {
                try {
                    if (this.isOutParameter(i)) {
                        roList.nextUnlessUndefined();
                    } else {
                        roList.next();
                    }
                }
                catch (SQLException e) {
                    if (e instanceof CacheBufferRO.NoMoreDataException) break block8;
                    throw e;
                }
            }
            ++i;
        }
        if (this.hasReturnValue == 3) {
            this.outputParameterList = roList.getOutputParameterList(beg, true);
            this.hasReturnValue = 2;
        } else {
            this.outputParameterList = roList.getOutputParameterList(beg, false);
        }
        this.paramRow = new CacheResultSetRow(this.parameters.size(), this.outputParameterList);
    }

    synchronized void updateResultSet() throws SQLException {
        this.Query(this.originalSqlText);
        this.resultSetConcurrency = 1008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureUpdate() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_UPDATE_EXECUTE);
            if (this.connection.protocolVersion >= 42) {
                this.output.wire.set(0);
                this.output.wire.set(0);
                this.output.wire.set(this.maxRows);
                this.writeStoredProcedureParameters();
            } else {
                this.writeStoredProcedureParameters();
                this.output.wire.set(0);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readMessage(this, 0, 504) == 404) {
                this.update404();
            } else {
                this.getOutputParameters(this.input.wire);
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureQuery() throws SQLException {
        if (this.multipleResultSets) {
            this.executeMultipleResultSets(false);
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_QUERY_EXECUTE);
            if (this.connection.protocolVersion >= 42) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion < 42) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 504);
            if (error == 404) {
                this.handleError504(404);
                return;
            }
            if (error == 100) {
                this.handleError100(100);
                return;
            }
            this.getOutputParameters(this.input.wire);
            this.handleError100(this.input.readMessage(this, 2, 100));
        }
    }

    synchronized void writeStoredProcedureParameters() throws SQLException {
        int i = 0;
        if (this.parameterSets != 0) {
            if (this.connection.protocolVersion > 52) {
                this.output.wire.set(this.parameterSets);
                this.output.wire.set(this.parameters.size());
                for (int j = 0; j < this.parameterSets; ++j) {
                    for (i = 0; i < this.parameters.size(); ++i) {
                        Parameter par = this.parameters.get(i);
                        if (par.values.get(j) instanceof StreamWrapper) {
                            this.output.wire.setParameter(this.sendStream(i, (StreamWrapper)par.values.get(j)), par.type);
                            continue;
                        }
                        this.output.wire.setParameter(par.values.get(j), par.type);
                    }
                }
            } else {
                this.output.wire.set(this.parameterSets);
                for (int j = 0; j < this.parameterSets; ++j) {
                    this.output.wire.set(this.parameters.size());
                    for (i = 0; i < this.parameters.size(); ++i) {
                        Parameter par = this.parameters.get(i);
                        if (par.values.get(j) instanceof StreamWrapper) {
                            this.output.wire.setParameter(this.sendStream(i, (StreamWrapper)par.values.get(j)), par.type);
                            continue;
                        }
                        this.output.wire.setParameter(par.values.get(j), par.type);
                    }
                }
            }
            return;
        }
        this.output.wire.set(1);
        if (this.hasReturnValue != 0) {
            i = 1;
        }
        this.output.wire.set(this.parameters.size() - i);
        while (i < this.parameters.size()) {
            Parameter par = this.parameters.get(i);
            if (par.mode == 4 || par.mode == 6) {
                this.output.wire.setUndefined();
            } else if (par.values.get(0) instanceof StreamWrapper) {
                this.output.wire.setParameter(this.sendStream(i, (StreamWrapper)par.values.get(0)), par.type);
            } else {
                this.output.wire.setParameter(par.values.get(0), par.type);
            }
            ++i;
        }
    }

    int getAbsoluteParameterIndex(int parameter) throws SQLException {
        if (parameter > this.parameters.size()) {
            throw new SQLException("Invalid parameter number: " + parameter, "S1093", 466);
        }
        int k = 0;
        int j = 0;
        int parIndex = parameter;
        if (this.hasReturnValue == 1) {
            j = 1;
            k = 1;
        } else {
            --parIndex;
        }
        while (j < this.parameters.size()) {
            if (this.parameters.get((int)j).mode != 5) {
                if (k == parIndex) {
                    return j;
                }
                ++k;
            }
            ++j;
        }
        throw new SQLException("Invalid parameter number: " + parameter, "S1093", 466);
    }

    private int[] computeUpdateCount(List<Integer> v) {
        int[] updateCount = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            updateCount[i] = v.get(i);
        }
        return updateCount;
    }

    static void debug(String x) {
        System.out.println(x);
    }

    List<Parameter> saveParameterInfo() {
        ArrayList<Parameter> toParams = new ArrayList<Parameter>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter p = this.parameters.get(i);
            Object value = null;
            if (p.mode == 5) {
                value = p.values.get(0);
            }
            toParams.add(new Parameter(p.type, p.precision, p.scale, p.nullable, p.name, p.mode, value));
        }
        return toParams;
    }

    void createParameterInfo(List<Parameter> fromParams) throws SQLException {
        this.parameters = new ArrayList<Parameter>();
        for (int i = 0; i < fromParams.size(); ++i) {
            Parameter parameter = new Parameter();
            parameter.copyCachedInfo(fromParams.get(i), true);
            this.parameters.add(parameter);
        }
    }

    void updateParameterInfo(List<Parameter> fromParams) throws SQLException {
        if (fromParams.size() != this.parameters.size()) {
            throw new SQLException("Parameter mismatch.");
        }
        for (int i = 0; i < fromParams.size(); ++i) {
            this.parameters.get(i).copyCachedInfo(fromParams.get(i), false);
        }
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Unsupported fetch direction.", "IM001");
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        int max = this.getMaxRows();
        if (rows < 0 || max != 0 && rows > max) {
            throw new SQLException("Invalid number of rows specified: " + rows, "S1000");
        }
        this.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            return;
        }
        this.cleanUp();
        this.preparse(sql);
        if (this.statementType == 1) {
            this.batchException = BATCH_EXCEPTION_QUERY;
            return;
        }
        if (this.statementType == 2 || this.statementType == 7) {
            this.batchException = BATCH_EXCEPTION_SP;
            return;
        }
        ++this.batchCount;
        this.validateParameters();
        if (this.batchCount == 1) {
            this.batch = new CacheBufferWrite(null);
            this.batch.setConnectionInfo(this.connection.connectionInfo);
            this.batch.writeHeader(0, CacheConnection.EXECUTE_STATEMENT_BATCH);
            this.batch.writeBatchCount(-1);
            if (this.connection.protocolVersion >= 42) {
                this.batch.set(0);
            }
        }
        this.batch.setSQLText(this.sqlText);
        this.writeParameters(this.batch);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this instanceof CachePreparedStatement) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
            return;
        }
        this.batchCount = 0;
        this.batch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (this.batchCount == 0) {
            if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
                throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, new int[0]);
            }
            return new int[0];
        }
        ArrayList<Integer> updateCount = new ArrayList<Integer>();
        SQLException ex = null;
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            CacheBufferWrite oldWire = this.output.setWire(this.batch);
            this.output.wire.writeBatchCount(this.batchCount);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readMessage(0, 0, 100);
            }
            catch (SQLException e) {
                ex = e;
            }
            this.output.setWire(oldWire);
            int sets = this.batchCount;
            this.batchCount = 0;
            for (int i = 0; i < sets; ++i) {
                int x = this.input.wire.getInt();
                if (x == -3) {
                    if (ex != null) {
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.computeUpdateCount(updateCount));
                    }
                    throw new BatchUpdateException("Not all rows updated", this.computeUpdateCount(updateCount));
                }
                updateCount.add(x);
            }
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, this.computeUpdateCount(updateCount));
        }
        if (ex != null) {
            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.computeUpdateCount(updateCount));
        }
        this.batch = null;
        return this.computeUpdateCount(updateCount);
    }

    ExecParameter getExecParam(int index) throws SQLException {
        ExecParameter parameter = this.execParams.get(index - 1);
        if (parameter == null) {
            throw new SQLException("Parameter list mismatch.");
        }
        return parameter;
    }

    ExecParameter getExecParamByName(String parameterName) throws SQLException {
        for (int i = 0; i < this.execParams.size(); ++i) {
            ExecParameter parameter = this.execParams.get(i);
            if (!parameter.name.equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void prepareStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this, 0, 0);
            this.processStoredProcedureMetaData(this.input.wire, false);
            if (this.multipleResultSets) {
                return;
            }
        }
        if (this.statementType == 1) {
            if (this.resultSetType == 1003) {
                this.connection.addCachedPrepare(this, true);
            }
        } else {
            this.connection.addCachedPrepare(this, false);
        }
    }

    public void setSQLDialect(int dialect) {
        this.sqlDialect = dialect;
    }

    public int getSQLDialect() {
        return this.sqlDialect;
    }

    private synchronized boolean directExecuteDialect() throws SQLException {
        this.multipleResultSets = true;
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int results;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_EXECUTE_DIALECT);
            this.output.wire.set(this.sqlDialect);
            this.output.wire.set(this.sqlText);
            if (this.resultSetType == 1004) {
                this.output.wire.set(1);
            } else {
                this.output.wire.set(0);
            }
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.output.send(this.connection.messageCount.getCount());
            this.createResultSet();
            int error = this.input.readMessage(this, 2, 100);
            int parameterCount = this.input.wire.getInt();
            for (int i = 0; i < parameterCount; ++i) {
                this.parameters.add(new Parameter());
            }
            this.readParameterData(this.input.wire, parameterCount, false);
            if (error == 100) {
                this.handleError100(100);
            }
            if ((results = this.input.wire.getInt()) >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                return true;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (!(this.statementType == 12 || this.statementType == 10 || this.statementType == 2 || this.statementType == 7 || this.statementType == 14 || this.statementType == 1 && this instanceof CacheCallableStatement)) {
            return false;
        }
        if (current < 1 || current > 3) {
            throw new SQLException("Invalid flag value: " + current, "S1000");
        }
        if (current == 2) {
            throw new SQLException("KEEP_CURRENT_RESULT not supported.", "IM001");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_MORE_RESULTS);
            this.output.wire.set(current);
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 100);
            int results = this.input.wire.getInt();
            if (results >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                this.createResultSet();
                if (error == 100) {
                    this.fetchDone = true;
                } else {
                    this.fetchDone = false;
                    this.myResultSet.requestFetch(this.connection.messageCount.getCount());
                }
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                this.genericExecuteCalled = true;
                return false;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (this.autoGeneratedKeyColumn == null) {
            this.columns = new ArrayList<Column>();
            this.fetchDone = true;
            return this.createNewResultSet();
        }
        if (this.statementType != 0) {
            throw new SQLException("Not an INSERT statement.", "S1000");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_AUTO_GENERATED_KEYS);
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readMessage(this, 0, 100) != 100) {
                throw new SQLException("Error retrieving auto-generated keys.", "S1000");
            }
            this.fetchDone = true;
        }
        if (this.input.wire.isEnd()) {
            this.columns = new ArrayList<Column>();
            this.fetchDone = true;
            return this.createNewResultSet();
        }
        this.columns = new ArrayList<Column>(1);
        this.columnInfo(this.input.wire);
        return this.createNewResultSet();
    }

    @Override
    public int executeUpdate(String sql, int generatedKeys) throws SQLException {
        this.autoGeneratedKeyColumn = generatedKeys == 1 ? "-1" : null;
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int generatedKeys) throws SQLException {
        this.autoGeneratedKeyColumn = generatedKeys == 1 ? "-1" : null;
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(columnIndexes[0]);
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(columnIndexes[0]);
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = columnNames[0];
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = columnNames[0];
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    synchronized boolean executeMultipleResultSets(boolean validate) throws SQLException {
        this.fetchDone = false;
        if (validate) {
            this.validateParameters();
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int results;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_MULTIPLE_RESULT_SETS);
            if (this.connection.protocolVersion > 41) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
            }
            if (this.statementType == 14) {
                this.writeParameters(this.output.wire);
            } else {
                this.writeStoredProcedureParameters();
            }
            this.output.send(this.connection.messageCount.getCount());
            this.createResultSet();
            this.handleError100(this.input.readMessage(this, 2, 100));
            if (this.statementType != 14) {
                this.getOutputParameters(this.input.wire);
            }
            if ((results = this.input.wire.getInt()) >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                return true;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    boolean hasStreamColumns() {
        if (this.columns == null) {
            return false;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            int type = this.columns.get((int)i).type;
            if (type != -1 && type != -4) continue;
            return true;
        }
        return false;
    }

    static boolean compareParInfoString(CacheListBuilder s1, CacheListBuilder s2) {
        return Arrays.equals(s1.getBuffer(), s2.getBuffer());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean p) throws SQLException {
        this.poolable = p;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        return this.closeOnCompletion;
    }

    static final class Parameter
    extends Descriptor {
        static final int UNKNOWN = 0;
        static final int INPUT = 1;
        static final int INPUT_OUTPUT = 2;
        static final int OUTPUT = 4;
        static final int REPLACED_LITERAL = 5;
        static final int DEFAULT_PARAMETER = 6;
        List<Object> values;
        int mode;
        boolean bound;
        List<Object> whatever;

        Parameter() {
            this.mode = 0;
            this.values = new ArrayList<Object>();
            this.whatever = new ArrayList<Object>();
            this.bound = false;
        }

        Parameter(Object x) {
            this.mode = 5;
            this.values = new ArrayList<Object>();
            this.whatever = new ArrayList<Object>();
            this.values.add(x);
            this.whatever.add(null);
        }

        Parameter(int x) {
            this.mode = 6;
            this.values = new ArrayList<Object>();
            this.whatever = new ArrayList<Object>();
        }

        Parameter(int t, int p, int s, int n, String nm, int m, Object v) {
            this.type = t;
            this.precision = p;
            this.scale = s;
            this.nullable = n;
            this.name = nm;
            this.mode = m;
            if (this.mode == 5) {
                this.values = new ArrayList<Object>();
                this.values.add(v);
            }
        }

        void copyCachedInfo(Parameter desc, boolean copyReplaced) {
            this.type = desc.type;
            this.precision = desc.precision;
            this.scale = desc.scale;
            this.nullable = desc.nullable;
            this.name = desc.name;
            if (this.mode != 5 && desc.mode != 5 && desc.mode != 0) {
                this.mode = desc.mode;
            }
            if (!copyReplaced) {
                return;
            }
            if (desc.mode == 5) {
                this.mode = 5;
                this.values = new ArrayList<Object>();
                this.whatever = new ArrayList<Object>();
                this.values.add(desc.values.get(0));
                this.whatever.add(null);
            }
        }

        void bind(Object val, Object what, int parameterSets) throws SQLException {
            int size;
            if (parameterSets == 0) {
                this.values.clear();
                this.whatever.clear();
            }
            if (parameterSets + 1 < (size = this.values.size()) || size < parameterSets) {
                throw new SQLException("Not all parameters bound for this set.", "S1000");
            }
            if (parameterSets == size) {
                this.values.add(val);
                this.whatever.add(what);
            } else {
                this.values.set(size - 1, val);
                this.whatever.set(size - 1, what);
            }
            this.bound = true;
            this.mode = this.mode == 4 || this.mode == 2 ? 2 : 1;
        }
    }

    static final class Column
    extends Descriptor
    implements Cloneable {
        String label;
        String tableName;
        String schema = "";
        String catalog = "";
        boolean isAutoIncrement = false;
        boolean isCaseSensitive = false;
        boolean isCurrency;
        boolean isReadOnly = false;
        boolean isRowId = false;
        int listOrder;

        Column() {
        }

        protected Object clone() {
            Column clone = new Column();
            clone.cloneMe(this);
            clone.label = this.label;
            clone.tableName = this.tableName;
            clone.schema = this.schema;
            clone.catalog = this.catalog;
            clone.isAutoIncrement = this.isAutoIncrement;
            clone.isCaseSensitive = this.isCaseSensitive;
            clone.isCurrency = this.isCurrency;
            clone.isReadOnly = this.isReadOnly;
            clone.isRowId = this.isRowId;
            clone.listOrder = this.listOrder;
            return clone;
        }
    }

    static final class StreamWrapper {
        Object data;
        int type;
        int length;

        StreamWrapper(Object d, int t, int l) {
            this.data = d;
            this.type = t;
            this.length = l;
        }
    }
}

