/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheListReader;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;

class CacheResultSetRow {
    int[] rowIndex;
    Object[] items;
    boolean newBuffer;
    boolean partialIndex;
    private int m_colCount;
    private int m_firstOffset;
    private AtomicReference<int[]> aRef;

    CacheResultSetRow(int count, int offset) {
        this.aRef = new AtomicReference<int[]>(this.rowIndex);
        this.m_colCount = count;
        this.m_firstOffset = offset;
        this.newBuffer = true;
        this.partialIndex = false;
    }

    public CacheResultSetRow(int count, CacheListReader outParamList) throws SQLException {
        this.aRef = new AtomicReference<int[]>(this.rowIndex);
        this.m_colCount = count;
        this.m_firstOffset = outParamList.getOffset();
        this.newBuffer = true;
        this.partialIndex = false;
        this.indexRow(outParamList.getTCPBuffer(), outParamList.getEndLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Update(int[] index) {
        this.newBuffer = false;
        this.items = new Object[this.m_colCount];
        CacheResultSetRow cacheResultSetRow = this;
        synchronized (cacheResultSetRow) {
            this.rowIndex = index;
        }
    }

    boolean indexRow(byte[] buffer, int Length, int offset) throws SQLException {
        this.m_firstOffset = offset;
        this.newBuffer = true;
        return this.indexRow(buffer, Length);
    }

    boolean indexRow(byte[] buffer, int Length) throws SQLException {
        int i = 0;
        int j = 0;
        int[] index = new int[this.m_colCount + 1];
        if (this.newBuffer) {
            i = this.m_firstOffset;
            this.m_firstOffset = 0;
        } else {
            i = this.rowIndex[this.m_colCount];
        }
        this.partialIndex = false;
        while (j <= this.m_colCount) {
            if (i > Length) {
                throw new SQLException("CacheResultSetRow::createIndexRowCursor offset out of range.");
            }
            if (i == Length) {
                if (j != 0) {
                    this.partialIndex = true;
                    if (this.newBuffer && this.rowIndex != null) {
                        this.rowIndex[this.m_colCount] = 0;
                    }
                } else if (this.rowIndex != null) {
                    this.rowIndex[this.m_colCount] = 0;
                }
                return false;
            }
            if (j == 0) {
                index[0] = i;
            } else {
                if (buffer[i] != 0) {
                    i += buffer[i] & 0xFF;
                } else if (buffer[i + 1] == 0 && buffer[i + 2] == 0) {
                    if (i + 6 < Length) {
                        i += (buffer[i + 3] & 0xFF | (buffer[i + 4] & 0xFF) << 8 | (buffer[i + 5] & 0xFF) << 16) + 7;
                    }
                } else if (i + 2 < Length) {
                    i += (buffer[i + 1] & 0xFF | (buffer[i + 2] & 0xFF) << 8) + 3;
                }
                index[j] = i;
            }
            ++j;
        }
        this.Update(index);
        return true;
    }

    int getOffset(int Index) {
        return this.rowIndex[Index];
    }

    int getLastOffset() {
        return this.rowIndex[this.m_colCount];
    }
}

