/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionPoolManager;
import com.intersys.util.VersionInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class CacheDriver
implements Driver {
    static ConnectionPoolManager CPManager;
    private static DriverPropertyInfo[] driverPropertyInfo;
    private String host;
    private String logFile;
    private int port;
    private String database;
    private String username = null;
    private String password = null;
    private String eventClass = "";
    private boolean nodelay = true;
    private int connectionSecurityLevel = 0;

    @Override
    public synchronized boolean acceptsURL(String url) throws SQLException {
        int pos;
        if (!url.startsWith("jdbc:Cache://")) {
            return false;
        }
        String temp = url.substring(13);
        if ((temp = this.parseCredentials(temp)).startsWith("[")) {
            pos = temp.indexOf("]");
            if (pos == -1) {
                return false;
            }
            this.host = temp.substring(1, pos);
            if (!(temp = temp.substring(pos + 1)).startsWith(":")) {
                return false;
            }
            pos = (temp = temp.substring(1)).indexOf("/");
            if (pos == -1) {
                return false;
            }
        } else {
            pos = temp.indexOf(":");
            if (pos == -1) {
                return false;
            }
            this.host = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf("/")) == -1) {
                return false;
            }
        }
        this.port = Integer.parseInt(temp.substring(0, pos));
        if ((pos = (temp = temp.substring(pos + 1)).indexOf("/")) == -1) {
            this.database = temp;
            this.logFile = null;
            return true;
        }
        this.database = temp.substring(0, pos);
        if ((pos = (temp = temp.substring(pos + 1)).indexOf(":")) == -1) {
            this.logFile = temp;
            if (this.logFile.equals("")) {
                this.logFile = null;
            }
            return true;
        }
        this.logFile = temp.substring(0, pos);
        if (this.logFile.equals("")) {
            this.logFile = null;
        }
        temp = temp.substring(pos + 1);
        this.parseExtension(temp);
        return true;
    }

    private void parseExtension(String ext) {
        int pos = ext.indexOf(":");
        if (pos == -1) {
            this.eventClass = ext;
        } else {
            this.eventClass = ext.substring(0, pos);
            if ((pos = (ext = ext.substring(pos + 1)).indexOf(":")) == -1) {
                if (ext.equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
            } else {
                if (ext.substring(0, pos).equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
                if ((ext = ext.substring(pos + 1)).equalsIgnoreCase("true")) {
                    this.connectionSecurityLevel = 10;
                }
            }
        }
    }

    private String parseCredentials(String str) {
        int pos1 = str.indexOf("?");
        if (pos1 == -1) {
            return str;
        }
        String cred = str.substring(pos1 + 1);
        int pos = cred.indexOf("username=");
        if (pos != -1) {
            if ((pos = (cred = cred.substring(pos + 9)).indexOf("&password=")) != -1) {
                this.username = cred.substring(0, pos);
                this.password = cred.substring(pos + 10);
            } else {
                this.username = cred;
            }
        }
        return str.substring(0, pos1);
    }

    @Override
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            if (this.connectionSecurityLevel == 10) {
                if (info == null) {
                    info = new Properties();
                }
                info.setProperty("connection security level", "10");
            }
            return new CacheConnection(url, this.host, this.port, this.database, this.logFile, this.eventClass, this.nodelay, info, this.username, this.password);
        }
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties Info) throws SQLException {
        return driverPropertyInfo;
    }

    @Override
    public int getMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported.");
    }

    static {
        try {
            CacheDriver d = new CacheDriver();
            CPManager = new ConnectionPoolManager();
            driverPropertyInfo = new DriverPropertyInfo[11];
            CacheDriver.driverPropertyInfo[0] = new DriverPropertyInfo("user", null);
            CacheDriver.driverPropertyInfo[0].description = "Username";
            CacheDriver.driverPropertyInfo[0].required = true;
            CacheDriver.driverPropertyInfo[1] = new DriverPropertyInfo("password", null);
            CacheDriver.driverPropertyInfo[1].description = "Password";
            CacheDriver.driverPropertyInfo[1].required = true;
            CacheDriver.driverPropertyInfo[2] = new DriverPropertyInfo("TCP_NODELAY", null);
            CacheDriver.driverPropertyInfo[2].description = "TCP/IP NoDelay Flag";
            CacheDriver.driverPropertyInfo[2].required = false;
            CacheDriver.driverPropertyInfo[2].choices = new String[]{"true", "false"};
            CacheDriver.driverPropertyInfo[3] = new DriverPropertyInfo("SO_SNDBUF", null);
            CacheDriver.driverPropertyInfo[3].description = "TCP/IP SO_SNDBUF value";
            CacheDriver.driverPropertyInfo[3].required = false;
            CacheDriver.driverPropertyInfo[4] = new DriverPropertyInfo("SO_RCVBUF", null);
            CacheDriver.driverPropertyInfo[4].description = "TCP/IP SO_RCVBUF value";
            CacheDriver.driverPropertyInfo[4].required = false;
            CacheDriver.driverPropertyInfo[5] = new DriverPropertyInfo("TransactionIsolationLevel", null);
            CacheDriver.driverPropertyInfo[5].description = "Transaction Isolation Level";
            CacheDriver.driverPropertyInfo[5].required = false;
            CacheDriver.driverPropertyInfo[5].choices = new String[]{"TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED"};
            CacheDriver.driverPropertyInfo[6] = new DriverPropertyInfo("service principal name", null);
            CacheDriver.driverPropertyInfo[6].description = "Service Principal Name";
            CacheDriver.driverPropertyInfo[6].required = false;
            CacheDriver.driverPropertyInfo[7] = new DriverPropertyInfo("connection security level", null);
            CacheDriver.driverPropertyInfo[7].description = "Connection Security Level";
            CacheDriver.driverPropertyInfo[7].required = false;
            CacheDriver.driverPropertyInfo[7].choices = new String[]{"1", "2", "3", "10"};
            CacheDriver.driverPropertyInfo[8] = new DriverPropertyInfo("SSL configuration name", null);
            CacheDriver.driverPropertyInfo[8].description = "SSL Configuration Name";
            CacheDriver.driverPropertyInfo[8].required = false;
            CacheDriver.driverPropertyInfo[9] = new DriverPropertyInfo("key recovery password", null);
            CacheDriver.driverPropertyInfo[9].description = "Key Recovery Password";
            CacheDriver.driverPropertyInfo[9].required = false;
            CacheDriver.driverPropertyInfo[10] = new DriverPropertyInfo("dialect", null);
            CacheDriver.driverPropertyInfo[10].description = "SQL Dialect";
            CacheDriver.driverPropertyInfo[10].required = false;
            CacheDriver.driverPropertyInfo[10].choices = new String[]{"default", "mssql", "sybase"};
            DriverManager.registerDriver(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

