/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheDataSource;
import com.intersys.jdbc.CacheDatabaseMetaData;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheListReader;
import com.intersys.jdbc.CachePooledConnection;
import com.intersys.jdbc.CachePreparedShardedStatement;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheSavepoint;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheWrapper;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.RegisteredDatabases;
import com.intersys.jgss.GSSSocket;
import com.intersys.jsse.SSLSocketFactory;
import com.intersys.sqf.Master;
import com.intersys.util.MachineInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;

public class CacheConnection
extends CacheWrapper
implements Connection {
    private static final int PRE_PREPARSE_CACHE_MAX_SIZE = 50;
    public LogFileStream logFile = null;
    Map<Integer, CachedPrepare> cachedPrepares = null;
    int nextServerCursorNumber = 0;
    int recycledServerCursorNumber = -1;
    InStream inMessage = null;
    OutStream outMessage = null;
    CacheStatement activeFetchStatement;
    String serverVersion;
    int delimitedIds = 0;
    String url = null;
    String user = null;
    protected MessageCount messageCount;
    InputStream inputStream;
    OutputStream outputStream;
    int protocolVersion;
    int isolationLevel = 1;
    int supportedIsolationLevels;
    ConnectionInfo connectionInfo;
    Properties moreConnectionInfo;
    CachePooledConnection pooled = null;
    Map<String, CachedSQL> prePreparseCache;
    private String cacheJobNumber = "-1";
    private Socket socket = null;
    private String password = null;
    private boolean closed = true;
    private boolean autoCommit = true;
    private boolean isReadOnly = false;
    private List<CacheStatement> statementPool;
    private List<CacheStatement> preparedStatementPool;
    private List<CacheStatement> callableStatementPool;
    private SQLWarning warnings = null;
    private int securityLevel;
    private String principalName;
    private String sSLConfigName;
    private String keyRecoveryPassword;
    private RegisteredDatabases registeredDatabases = null;
    private Map<String, Savepoint> savepoints;
    private int savepointId = 0;
    private Properties clientInfo;
    private int sqlDialect = 0;
    private int streamPrefetchSize = 0;
    private int queryPrefetchSize = 32768;
    private Master master = null;
    protected SocketChannel socketChannel;
    ByteBuffer byteBuffer;
    final ByteBuffer headerBuffer = ByteBuffer.allocate(14);
    private final ConcurrentLinkedQueue<CacheListBuilder> vListQueue = new ConcurrentLinkedQueue();
    static final int PROTOCOL_VERSION = 53;
    static final byte[] HANDSHAKE = new byte[]{72, 83};
    static final byte[] CONNECT = new byte[]{67, 78};
    static final byte[] DISCONNECT = new byte[]{68, 67};
    static final byte[] PREPARE = new byte[]{80, 80};
    static final byte[] DIRECT_UPDATE = new byte[]{68, 85};
    static final byte[] DIRECT_QUERY = new byte[]{68, 81};
    static final byte[] DIRECT_STORED_PROCEDURE = new byte[]{68, 83};
    static final byte[] PREPARE_DIALECT = new byte[]{80, 68};
    static final byte[] DIRECT_EXECUTE_DIALECT = new byte[]{68, 68};
    static final byte[] PREPARED_UPDATE_EXECUTE = new byte[]{80, 85};
    static final byte[] PREPARED_QUERY_EXECUTE = new byte[]{80, 81};
    static final byte[] FETCH_DATA = new byte[]{70, 68};
    static final byte[] CLOSE_CURSOR = new byte[]{67, 67};
    static final byte[] PREPARE_STORED_PROCEDURE = new byte[]{83, 80};
    static final byte[] STORED_PROCEDURE_UPDATE_EXECUTE = new byte[]{83, 85};
    static final byte[] STORED_PROCEDURE_QUERY_EXECUTE = new byte[]{83, 81};
    static final byte[] STORED_PROCEDURE_FETCH_DATA = new byte[]{83, 70};
    static final byte[] EXECUTE_MULTIPLE_RESULT_SETS = new byte[]{77, 83};
    static final byte[] MULTIPLE_RESULT_SETS_FETCH_DATA = new byte[]{77, 68};
    static final byte[] GET_MORE_RESULTS = new byte[]{77, 82};
    static final byte[] GET_STREAM_SIZE = new byte[]{83, 83};
    static final byte[] OPEN_STREAM = new byte[]{79, 83};
    static final byte[] READ_STREAM = new byte[]{74, 83};
    static final byte[] STORE_BINARY_STREAM = new byte[]{83, 66};
    static final byte[] STORE_CHARACTER_STREAM = new byte[]{83, 77};
    static final byte[] STREAM_GET_BYTES = new byte[]{71, 66};
    static final byte[] STREAM_SET_BYTES = new byte[]{83, 90};
    static final byte[] STREAM_TRUNCATE = new byte[]{83, 88};
    static final byte[] STREAM_GET_POSITION = new byte[]{71, 80};
    static final byte[] CLOSE_STREAM = new byte[]{67, 83};
    static final byte[] STREAM_RELEASE_READ_LOCK = new byte[]{83, 82};
    static final byte[] STREAM_SET_PREFETCH_SIZE = new byte[]{83, 78};
    static final byte[] GET_CACHE_RESULT_SET_OBJECT = new byte[]{70, 82};
    static final byte[] GET_STRUCT_OBJECT = new byte[]{70, 83};
    static final byte[] COMMIT = new byte[]{84, 67};
    static final byte[] ROLLBACK = new byte[]{84, 82};
    static final byte[] READ_COMMITTED = new byte[]{82, 67};
    static final byte[] READ_UNCOMMITTED = new byte[]{82, 85};
    static final byte[] ISOLATION_LEVEL = new byte[]{73, 76};
    static final byte[] AUTOCOMMIT_OFF = new byte[]{65, 70};
    static final byte[] AUTOCOMMIT_ON = new byte[]{65, 78};
    static final byte[] TOGGLE_SYNCHRONOUS_COMMIT = new byte[]{84, 83};
    static final byte[] GET_AUTO_GENERATED_KEYS = new byte[]{71, 71};
    static final byte[] IN_TRANSACTION = new byte[]{73, 84};
    static final byte[] JDBC_BESTROWID = new byte[]{66, 82};
    static final byte[] JDBC_CATALOGS = new byte[]{67, 65};
    static final byte[] JDBC_COLUMNPRIV = new byte[]{67, 80};
    static final byte[] JDBC_COLUMNS = new byte[]{67, 79};
    static final byte[] JDBC_CROSSREFERENCE = new byte[]{67, 82};
    static final byte[] JDBC_EXPORTEDKEYS = new byte[]{69, 75};
    static final byte[] JDBC_IMPORTEDKEYS = new byte[]{73, 75};
    static final byte[] JDBC_INDEXINFO = new byte[]{73, 73};
    static final byte[] JDBC_PRIMARYKEYS = new byte[]{80, 75};
    static final byte[] JDBC_PROCEDURECOL = new byte[]{80, 67};
    static final byte[] JDBC_PROCEDURES = new byte[]{80, 82};
    static final byte[] JDBC_SCHEMAS = new byte[]{83, 67};
    static final byte[] JDBC_TABLEPRIV = new byte[]{84, 80};
    static final byte[] JDBC_TABLES = new byte[]{84, 65};
    static final byte[] JDBC_TABLETYPES = new byte[]{84, 84};
    static final byte[] JDBC_TYPEINFO = new byte[]{84, 73};
    static final byte[] JDBC_VERSIONCOL = new byte[]{86, 67};
    static final byte[] JDBC_UDTS = new byte[]{85, 84};
    static final byte[] JDBC_SUPER_TYPES = new byte[]{83, 89};
    static final byte[] JDBC_SUPER_TABLES = new byte[]{83, 76};
    static final byte[] JDBC_GET_ATTRIBUTES = new byte[]{65, 84};
    static final byte[] JDBC_GET_FUNCTION_COLUMNS = new byte[]{70, 67};
    static final byte[] JDBC_GET_FUNCTIONS = new byte[]{70, 78};
    static final byte[] JDBC_CLIENT_INFO_PROPERTIES = new byte[]{67, 70};
    static final byte[] SET_CLIENT_INFO_PROPERTIES = new byte[]{67, 71};
    static final byte[] JDBC_PSEUDO_COLUMNS = new byte[]{67, 72};
    static final byte[] GET_SCHEMA = new byte[]{71, 83};
    static final byte[] EXECUTE_STATIC_CURSOR = new byte[]{69, 88};
    static final byte[] DIRECT_STATIC_CURSOR = new byte[]{68, 88};
    static final byte[] FETCH_STATIC_CURSOR = new byte[]{70, 88};
    static final byte[] UPDATE_CACHE = new byte[]{85, 67};
    static final byte[] RESET_CONNECTION = new byte[]{82, 78};
    static final byte[] GET_SERVER_ERROR = new byte[]{79, 69};
    static final byte[] EXECUTE_STATEMENT_BATCH = new byte[]{69, 66};
    static final byte[] CLOSE_STATEMENT = new byte[]{67, 85};
    static final byte[] SET_QUERY_PREFETCH_SIZE = new byte[]{80, 66};
    static final byte[] EXTERNAL_INTERUPT = new byte[]{69, 73};
    static final byte[] QUICK_LOAD = new byte[]{81, 76};
    static final byte[] QUICK_CHILD_TABLE_LOAD = new byte[]{81, 90};
    static final byte[] QUICK_CHILD_TABLE_CREATE = new byte[]{81, 88};
    static final byte[] QUICK_CHILD_TABLE_REMOVE = new byte[]{81, 75};
    static final byte[] QUICK_STORE = new byte[]{81, 83};
    static final byte[] QUICK_CREATE = new byte[]{81, 67};
    static final byte[] QUICK_REMOVE = new byte[]{81, 82};
    static final byte[] QUICK_FIND_ROWID_BY_PK = new byte[]{81, 49};
    static final byte[] QUICK_FIND_ROWID_BY_CONSTRAINT = new byte[]{81, 50};
    static final byte[] QUICK_FIND_PK_BY_CONSTRAINT = new byte[]{81, 51};
    static final byte[] QUICK_REMOVE_BY_PK = new byte[]{81, 52};
    static final byte[] QUICK_CREATE_BY_PK = new byte[]{81, 53};
    static final byte[] QUICK_STORE_BY_PK = new byte[]{81, 54};
    static final byte[] QUICK_LOAD_BY_PK = new byte[]{81, 55};
    static final byte[] QUICK_GET_CHILDREN_PKS = new byte[]{81, 66};
    static final byte[] QUICK_FIND_PK_BY_ROWID = new byte[]{81, 69};
    static final byte[] QUICK_BULK_LOAD = new byte[]{81, 77};
    static final byte[] QUICK_BULK_CREATE = new byte[]{81, 78};
    static final byte[] QUICK_BULK_STORE = new byte[]{81, 79};
    static final byte[] QUICK_BULK_SAVE_BY_PK = new byte[]{81, 87};
    static final byte[] QUICK_QUERY = new byte[]{81, 81};
    static final byte[] QUICK_JPA_FLUSH = new byte[]{81, 70};
    static final byte[] QUICK_CHILD_TABLE_REMOVE_BY_PK = new byte[]{81, 56};
    static final byte[] QUICK_CHILD_TABLE_CREATE_BY_PK = new byte[]{81, 57};
    static final byte[] QUICK_CHILD_TABLE_LOAD_BY_PK = new byte[]{81, 65};
    static final byte[] QUICK_GET_CHILDREN_PKS_BY_PK = new byte[]{81, 68};
    static final byte[] GET_CACHE_INFO = new byte[]{67, 73};
    static final byte[] PING = new byte[]{80, 71};
    static final byte[] PING_TWO = new byte[]{80, 50};
    static final byte[] COMPARE_TIMESTAMP = new byte[]{67, 86};
    static final byte[] SEND_TWO_FACTOR_TOKEN = new byte[]{50, 70};
    static final byte[] IS_TWO_FACTOR_ENABLED = new byte[]{50, 69};
    static final byte[] XEP_STORE = new byte[]{88, 83};
    static final byte[] XEP_FUNCTION = new byte[]{88, 70};
    static final byte[] XEP_GET_OBJECT = new byte[]{88, 79};
    static final byte[] XEP_EXISTS = new byte[]{88, 69};
    static final byte[] XEP_METHOD = new byte[]{88, 77};
    static final int MAX_CACHE_SIZE = 500;
    static final int ITEMS_TO_REMOVE = 100;
    static final int MAX_STATEMENT_POOL_SIZE = 40;
    static final int ALLOW_ERROR_0 = 0;
    static final int ALLOW_ERROR_100 = 100;
    static final int ALLOW_ERROR_403 = 403;
    static final int ALLOW_ERROR_404 = 404;
    static final int ALLOW_ERROR_417 = 417;
    static final int ALLOW_ERRORS_100_AND_404 = 504;
    static final int SQL_DIALECT_DEFAULT = 0;
    static final int SQL_DIALECT_MSSQL = 1;
    static final int SQL_DIALECT_SYBASE = 2;
    public static final int TRANSACTION_READ_VERIFIED = 32;

    CacheConnection(String u, String h, int p, String d, String l, String e, boolean n, Properties i, String us, String pwd) throws SQLException {
        this.init();
        this.url = u;
        String sec = i.getProperty("connection security level");
        if (sec != null) {
            this.securityLevel = Integer.parseInt(sec);
            if (this.securityLevel > 0 && this.securityLevel < 4) {
                this.principalName = i.getProperty("service principal name");
                if (this.principalName == null) {
                    throw new SQLException("No Service Principal Name: Connection Security Level is: " + this.securityLevel);
                }
            } else if (this.securityLevel == 10) {
                this.sSLConfigName = i.getProperty("SSL configuration name");
                this.keyRecoveryPassword = i.getProperty("key recovery password");
            }
        }
        this.user = us != null ? us : i.getProperty("user");
        this.password = pwd != null ? pwd : i.getProperty("password");
        if (l != null) {
            try {
                this.logFile = new LogFileStream(l);
            }
            catch (IOException ex) {
                this.logFile = null;
            }
        }
        if (!this.closed) {
            return;
        }
        this.isolationLevel = 1;
        this.connect(h, p, d, e, DriverManager.getLoginTimeout(), n, i);
    }

    protected CacheConnection() {
        this.init();
        this.isolationLevel = 1;
    }

    protected CacheConnection(CacheDataSource ds, String usr, String psw, CachePooledConnection pc) throws SQLException {
        this.init();
        this.securityLevel = ds.getConnectionSecurityLevel();
        if (this.securityLevel > 0 && this.securityLevel < 4) {
            this.principalName = ds.getServicePrincipalName();
            if (this.principalName == null) {
                throw new SQLException("No Service Principal Name: Connection Security Level is: " + this.securityLevel);
            }
        } else if (this.securityLevel == 10) {
            this.sSLConfigName = ds.getSSLConfigurationName();
            this.keyRecoveryPassword = ds.getKeyRecoveryPassword();
        }
        this.url = ds.getURL();
        this.user = usr;
        this.password = psw;
        this.pooled = pc;
        PrintWriter pw = ds.getLogWriter();
        if (pw != null) {
            try {
                this.logFile = new LogFileStream(pw);
            }
            catch (IOException ex) {
                this.logFile = null;
            }
        }
        this.isolationLevel = ds.getDefaultTransactionIsolation();
        this.connect(ds.getServerName(), ds.getPortNumber(), ds.getDatabaseName(), ds.getEventClass(), ds.getLoginTimeout(), ds.getNodelay(), null);
    }

    public CacheConnection(Object i, Object o, Object s, String d, int p, int prot, Object l) throws Exception {
        this.init();
        if (this.protocolVersion > prot) {
            this.protocolVersion = prot;
        }
        this.closed = false;
        this.isolationLevel = 1;
        this.socket = (Socket)s;
        InetAddress inetAddress = this.socket.getLocalAddress();
        String ip = inetAddress.getHostAddress();
        this.url = inetAddress instanceof Inet6Address ? "jdbc:Cache://[" + ip + "]:" + p + "/" + d : "jdbc:Cache://" + ip + ":" + p + "/" + d;
        this.logFile = (LogFileStream)l;
        this.user = "_SYSTEM";
        this.password = "SYS";
        this.inputStream = ((InStream)i).inputStream;
        this.outputStream = ((OutStream)o).outputStream;
        this.inMessage = (InStream)i;
        this.outMessage = (OutStream)o;
    }

    private CacheConnection(InStream i, OutStream o, LogFileStream l, String u, String p) throws Exception {
        this.messageCount = new MessageCount();
        this.protocolVersion = 53;
        this.connectionInfo = new ConnectionInfo();
        this.closed = false;
        this.logFile = l;
        this.user = u;
        this.password = p;
        this.inputStream = i.inputStream;
        this.outputStream = o.outputStream;
        this.inMessage = i;
        this.outMessage = o;
        this.inMessage.connection = this;
    }

    void addPrePreparseCache(String sql, CacheStatement stmt) {
        if (this.prePreparseCache.size() < 50 && stmt.execParams == null) {
            this.prePreparseCache.put(sql, new CachedSQL(stmt));
        }
    }

    private void init() {
        this.protocolVersion = 53;
        this.securityLevel = 0;
        this.principalName = null;
        this.sSLConfigName = null;
        this.keyRecoveryPassword = null;
        this.statementPool = new ArrayList<CacheStatement>();
        this.preparedStatementPool = new ArrayList<CacheStatement>();
        this.callableStatementPool = new ArrayList<CacheStatement>();
        this.cachedPrepares = new ConcurrentHashMap<Integer, CachedPrepare>();
        this.messageCount = new MessageCount();
        this.prePreparseCache = new ConcurrentHashMap<String, CachedSQL>();
        this.clientInfo = new Properties();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, long paramCount) throws SQLException {
        CachePreparedStatement ps = (CachePreparedStatement)this.prepareStatement(sql, 2, paramCount);
        ps.statementType = 2;
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int statementType, long paramCount) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        CachePreparedStatement stmt = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, 1003, 1007);
        if (stmt == null) {
            return new CachePreparedStatement(this, 1003, sql, statementType, paramCount);
        }
        stmt.prepare(sql, statementType, paramCount);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int statementType, long paramCount) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheCallableStatement stmt = (CacheCallableStatement)this.getStatement(this.callableStatementPool, 1003, 1007);
        if (stmt == null) {
            return new CacheCallableStatement(this, sql, statementType, paramCount);
        }
        stmt.prepare(sql, statementType, paramCount);
        return stmt;
    }

    @Override
    public String nativeSQL(String query) throws SQLException {
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean enableAutoCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.autoCommit = enableAutoCommit;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (this.autoCommit) {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_ON);
            } else {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_OFF);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(COMMIT);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ROLLBACK);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.pooled != null) {
            this.closePooledConnection();
            return;
        }
        if (this.registeredDatabases != null) {
            this.registeredDatabases.onClose();
            if (this.closed) {
                return;
            }
        }
        this.closed = true;
        this.cachedPrepares = null;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(DISCONNECT);
            this.outMessage.send(this.messageCount.getCount());
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        if (this.logFile != null) {
            this.logFile.close();
            this.logFile = null;
        }
        this.outMessage = null;
        this.inMessage = null;
        this.clientInfo = null;
        this.moreConnectionInfo = null;
        this.master = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return new CacheDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.isReadOnly = readOnly;
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String Catalog) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.protocolVersion > 51) {
            if ((this.supportedIsolationLevels & level) != level) {
                throw new SQLException("Unsupported isolation level " + level, "S1000", 460);
            }
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(ISOLATION_LEVEL);
                this.outMessage.wire.set(level);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                if (level != this.inMessage.wire.getInt()) {
                    throw new SQLException("Server Rejected isolation level: " + level, "S1000", 460);
                }
            }
            this.isolationLevel = level;
            return;
        }
        if (this.isolationLevel == level) {
            return;
        }
        if (0 == level || 4 == level || 8 == level) {
            throw new SQLException("Unsupported isolation level " + level, "S1000", 460);
        }
        if (this.supportedIsolationLevels == 1 && 2 == level) {
            throw new SQLException("Unsupported isolation level " + level, "S1000", 460);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (level == 1) {
                this.outMessage.wire.writeHeader(READ_UNCOMMITTED);
                this.isolationLevel = 1;
            } else {
                this.outMessage.wire.writeHeader(READ_COMMITTED);
                this.isolationLevel = 2;
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.protocolVersion > 51) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(ISOLATION_LEVEL);
                this.outMessage.wire.set(0);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                return this.inMessage.wire.getInt();
            }
        }
        return this.isolationLevel;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.warnings = null;
    }

    private byte[] encode(int len, byte[] inp) {
        int i = 0;
        byte[] out = new byte[len];
        while (len > 0) {
            int tint = ((inp[i] ^ 0xA7) & 0xFF) + --len & 0xFF;
            out[len] = (byte)(tint << 5 | tint >> 3);
            ++i;
        }
        return out;
    }

    private String encodew(String s) {
        int len = s.length();
        int i = 0;
        char[] inChar = s.toCharArray();
        char[] outChar = new char[len];
        while (len > 0) {
            char tint2 = inChar[i];
            int tint = ((inChar[i] ^ 0xA7) & 0xFF) + --len & 0xFF;
            outChar[len] = (char)(tint2 & 0xFF00 | (tint << 5 | tint >> 3) & 0xFF);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return new String(outChar);
    }

    private void configureSocket(Properties p) throws SQLException {
        if (p == null) {
            return;
        }
        try {
            String option = p.getProperty("TCP_NODELAY");
            if (option != null) {
                this.socket.setTcpNoDelay(Boolean.valueOf(option));
            }
            if ((option = p.getProperty("SO_SNDBUF")) != null) {
                this.socket.setSendBufferSize(Integer.parseInt(option));
            }
            if ((option = p.getProperty("SO_RCVBUF")) != null) {
                this.socket.setReceiveBufferSize(Integer.parseInt(option));
            }
        }
        catch (Exception ex) {
            throw new SQLException("Bad socket option: " + ex.getMessage(), "08S01", 461);
        }
    }

    private Socket constructNewLCBJNISocket(String host, Integer port, String namespace, String user, String password, String exeName) throws SQLException {
        try {
            Class<?> lcbjniSocket = Class.forName("com.intersys.internal.lcbjni.LCBJNISocket");
            Method m = lcbjniSocket.getMethod("getLCBJNISocket", String.class, Integer.class, String.class, String.class, String.class, String.class);
            return (Socket)m.invoke(null, host, port, namespace, user, password, exeName);
        }
        catch (ClassNotFoundException x) {
            throw new SQLException("No LCBJNI Socket Factory class is available in your classpath");
        }
        catch (NoSuchMethodException x) {
            throw new SQLException(x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new SQLException(x.getMessage());
        }
        catch (InvocationTargetException x) {
            throw new SQLException(x.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connect(String host, int port, String database, String eventClass, int timeout, boolean nodelay, Properties prop) throws SQLException {
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        SSLContext sslctx = null;
        if (prop != null) {
            this.moreConnectionInfo = prop;
            String option = prop.getProperty("TransactionIsolationLevel");
            if (option != null) {
                if (option.equals("TRANSACTION_READ_COMMITTED")) {
                    this.isolationLevel = 2;
                } else if (option.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.isolationLevel = 1;
                } else if (option.equals("TRANSACTION_READ_VERIFIED")) {
                    this.isolationLevel = 32;
                }
            }
            if ((option = prop.getProperty("dialect")) != null) {
                if (option.equals("sybase")) {
                    this.sqlDialect = 2;
                } else if (option.equals("mssql")) {
                    this.sqlDialect = 1;
                }
            }
            if ((sslctx = (SSLContext)prop.get("SSLContext")) != null) {
                this.securityLevel = 10;
            }
        }
        try {
            Object sf;
            if (this.securityLevel == 0) {
                if (host.equals("SPCHOST")) {
                    Integer portInteger = port;
                    this.socket = this.constructNewLCBJNISocket(host, portInteger, database, this.user, this.password, MachineInfo.getExeName());
                } else if (this.getClass().getName().equals("com.intersys.omnidb.Connection")) {
                    this.byteBuffer = ByteBuffer.allocate(50000000);
                    this.socketChannel = SocketChannel.open(new InetSocketAddress(host, port));
                    this.socket = this.socketChannel.socket();
                } else {
                    this.socket = new Socket();
                    this.socket.setSoTimeout(timeout * 1000);
                    this.socket.setTcpNoDelay(nodelay);
                    this.socket.setSendBufferSize(32768);
                    this.socket.setReceiveBufferSize(32768);
                    this.socket.setKeepAlive(true);
                    this.configureSocket(prop);
                    InetSocketAddress sa = new InetSocketAddress(host, port);
                    this.socket.connect(sa);
                }
            } else if (this.securityLevel > 0 && this.securityLevel < 4) {
                this.socket = new GSSSocket(host, port, this.principalName, this.securityLevel, this.user, this.password);
            } else if (this.securityLevel == 10) {
                if (sslctx != null) {
                    this.socket = sslctx.getSocketFactory().createSocket(host, port);
                } else {
                    sf = new SSLSocketFactory(this.sSLConfigName, this.keyRecoveryPassword);
                    this.socket = ((SSLSocketFactory)sf).createSocket(host, port);
                }
            }
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
            this.outMessage = new OutStream(this);
            this.inMessage = new InStream(this);
            sf = this.messageCount;
            synchronized (sf) {
                this.outMessage.wire.writeHeader(HANDSHAKE);
                this.outMessage.wire.set2ByteInt(this.protocolVersion);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readMessage(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.protocolVersion = this.inMessage.wire.getRaw2ByteInt();
                if (this.protocolVersion < 39) {
                    throw new SQLException("Protocol mismatch; only protocols >= 39 supported", "08S01", 461);
                }
                boolean isUnicode = this.inMessage.wire.getRaw2ByteInt() == 1;
                String serverLocale = this.inMessage.wire.readServerEncoding();
                this.connectionInfo = new ConnectionInfo(this.protocolVersion, serverLocale, isUnicode);
                this.inMessage.setLocale(this);
                this.outMessage.wire.setConnectionInfo(this.connectionInfo);
                this.outMessage.wire.writeHeader(CONNECT);
                this.outMessage.wire.set(database);
                if (this.user == null || this.user.length() == 0) {
                    this.outMessage.wire.setNull();
                } else if (isUnicode) {
                    this.outMessage.wire.set(this.encodew(this.user));
                } else {
                    byte[] userBytes = this.user.getBytes(serverLocale);
                    this.outMessage.wire.set(this.encode(userBytes.length, userBytes));
                }
                if (this.password == null || this.password.length() == 0) {
                    this.outMessage.wire.setNull();
                } else if (isUnicode) {
                    this.outMessage.wire.set(this.encodew(this.password));
                } else {
                    byte[] passwordBytes = this.password.getBytes(serverLocale);
                    this.outMessage.wire.set(this.encode(passwordBytes.length, passwordBytes));
                }
                String userName = MachineInfo.getUserName();
                String machineName = MachineInfo.getMachineName();
                String applicationName = MachineInfo.getExeName();
                String hostIP = this.socket.getLocalAddress().getHostAddress();
                this.clientInfo.put("ApplicationName", applicationName);
                this.clientInfo.put("ClientHostname", hostIP);
                this.clientInfo.put("ClientUser", userName);
                this.clientInfo.put("MachineName", machineName);
                this.outMessage.wire.set(userName);
                this.outMessage.wire.set(machineName);
                this.outMessage.wire.set(applicationName);
                this.outMessage.wire.set(MachineInfo.getOSInfo());
                this.outMessage.wire.set(hostIP);
                this.outMessage.wire.set(eventClass);
                if (this.autoCommit) {
                    this.outMessage.wire.set(1);
                } else {
                    this.outMessage.wire.set(2);
                }
                if (this.protocolVersion < 52 && this.isolationLevel > 3) {
                    this.isolationLevel = 2;
                }
                this.outMessage.wire.set(this.isolationLevel);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readMessage(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.serverVersion = this.inMessage.wire.getString();
                this.delimitedIds = this.inMessage.wire.getInt();
                this.inMessage.wire.getInt();
                this.supportedIsolationLevels = this.inMessage.wire.getInt();
                this.cacheJobNumber = this.inMessage.wire.getString();
                if (this.logFile != null) {
                    this.logFile.setJobID(this.cacheJobNumber);
                }
                if (this.protocolVersion > 41) {
                    this.connectionInfo.sqlEmptyString = this.inMessage.wire.getInt();
                }
            }
            this.closed = false;
            this.socket.setSoTimeout(0);
            this.master = new Master(this, host, port, database, this.user, this.password);
        }
        catch (Exception e) {
            try {
                this.socket.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw new SQLException("[Cache JDBC] Communication link failure: " + e.getMessage(), "08S01", 461, e);
        }
    }

    public boolean isServerUnicode() {
        return this.connectionInfo.isUnicodeServer;
    }

    public String getServerLocale() {
        return this.connectionInfo.serverLocale;
    }

    public ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.connectionInfo.clone();
    }

    public void setConnectionInfo(ConnectionInfo info) {
        this.connectionInfo = info;
    }

    void addCachedPrepare(CacheStatement stmt, boolean setOwner) throws SQLException {
        if (!stmt.poolable || stmt.execParams != null) {
            return;
        }
        for (Integer key : this.cachedPrepares.keySet()) {
            if (!this.cachedPrepares.get(key).match(stmt)) continue;
            return;
        }
        if (this.cachedPrepares.size() >= 500) {
            this.updateCache();
        }
        this.cachedPrepares.put(stmt.serverCursorNumber, new CachedPrepare(stmt, setOwner));
    }

    void addCachedPrepareNoUpdate(CacheStatement stmt, boolean setOwner) throws SQLException {
        if (!stmt.poolable) {
            return;
        }
        for (Integer key : this.cachedPrepares.keySet()) {
            if (!this.cachedPrepares.get(key).matches(stmt)) continue;
            return;
        }
        this.cachedPrepares.put(stmt.serverCursorNumber, new CachedPrepare(stmt, setOwner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCache() throws SQLException {
        Iterator<Integer> iter = this.cachedPrepares.keySet().iterator();
        if (!iter.hasNext()) {
            return;
        }
        int[] x = new int[100];
        int n = 0;
        while (iter.hasNext()) {
            Integer key = iter.next();
            CachedPrepare element = this.cachedPrepares.get(key);
            if (element.ownedBy != null) continue;
            x[n] = element.serverCursorNumber;
            iter.remove();
            if (++n != 100) continue;
        }
        if (n == 0) {
            return;
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(UPDATE_CACHE);
            this.outMessage.wire.set(n);
            for (int j = 0; j < n; ++j) {
                this.outMessage.wire.set(x[j]);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStatement(CacheStatement cs) throws SQLException {
        try (CacheConnection newConn = (CacheConnection)DriverManager.getConnection(this.url, this.user, this.password);){
            MessageCount messageCount = newConn.messageCount;
            synchronized (messageCount) {
                newConn.outMessage.wire.writeHeader(0, EXTERNAL_INTERUPT);
                newConn.outMessage.wire.set(Integer.parseInt(cs.connection.cacheJobNumber));
                newConn.outMessage.wire.set(cs.serverCursorNumber);
                newConn.outMessage.send(newConn.messageCount.getCount());
                int err = newConn.inMessage.readMessage(0, 0, 0);
                if (err != 0) {
                    throw new SQLException("Cache Cancel failure", "HY018");
                }
            }
        }
    }

    void checkOutStandingFetches() throws SQLException {
        if (this.activeFetchStatement != null && this.activeFetchStatement.outstandingReads > 0 && this.activeFetchStatement.weakResultSetReference != null && !this.activeFetchStatement.fetchDone) {
            ((CacheResultSet)this.activeFetchStatement.weakResultSetReference.get()).readOOBFetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(boolean send) throws SQLException {
        int size = this.cachedPrepares.size();
        if (size == 0) {
            return;
        }
        Iterator<Integer> iter = this.cachedPrepares.keySet().iterator();
        if (send) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(UPDATE_CACHE);
                if (this.protocolVersion > 50) {
                    this.cachedPrepares.clear();
                    this.outMessage.wire.set(0);
                    this.outMessage.send(this.messageCount.getCount());
                    return;
                }
                this.outMessage.wire.set(size);
                while (iter.hasNext()) {
                    Integer key = iter.next();
                    CachedPrepare element = this.cachedPrepares.get(key);
                    this.outMessage.wire.set(element.serverCursorNumber);
                    iter.remove();
                }
                this.outMessage.send(this.messageCount.getCount());
            }
            return;
        }
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    void getServerError(int rc) throws SQLException {
        String state = CacheConnection.getSQLState(rc);
        if (this.closed) {
            switch (rc) {
                case 469: {
                    throw new SQLException("Driver not capable", state, rc);
                }
                case 464: {
                    throw new SQLException("Function sequence error", state, rc);
                }
                case 462: {
                    throw new SQLException("Memory allocation failure", state, rc);
                }
                case 461: {
                    throw new SQLException("Communication link failure", state, rc);
                }
                case 460: {
                    throw new SQLException("General error", state, rc);
                }
                case 453: {
                    throw new SQLException("Error in User Initialization Code", state, rc);
                }
                case 452: {
                    throw new SQLException("Message sequencing error", state, rc);
                }
                case 451: {
                    throw new SQLException("Unable to receive server message", state, rc);
                }
                case 450: {
                    throw new SQLException("Unable to send client message", state, rc);
                }
                case 410: {
                    throw new SQLException("Invalid Directory", state, rc);
                }
                case 409: {
                    throw new SQLException("Invalid server function", state, rc);
                }
                case 408: {
                    throw new SQLException("Unable to start server", state, rc);
                }
                case 407: {
                    throw new SQLException("Unable to Write to Server Master", state, rc);
                }
                case 406: {
                    throw new SQLException("Unable to Write to Server", state, rc);
                }
                case 405: {
                    throw new SQLException("Unable to read from communication device", state, rc);
                }
                case 402: {
                    throw new SQLException("Invalid Username/Password", state, rc);
                }
                case 401: {
                    throw new SQLException("Fatal Connection error", state, rc);
                }
                case 400: {
                    throw new SQLException("Fatal error occurred", state, rc);
                }
                case 112: {
                    throw new SQLException("Access violation", state, rc);
                }
                case 99: {
                    throw new SQLException("Privilege Violation", state, rc);
                }
                case 98: {
                    throw new SQLException("License Violation", state, rc);
                }
            }
            throw new SQLException("General error", state, rc);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SERVER_ERROR);
            this.outMessage.wire.set(rc);
            this.outMessage.send(this.messageCount.getCount());
            int err = this.inMessage.readMessage(0, 0, 0);
            if (err != 0) {
                throw new SQLException("General error", state, rc);
            }
            throw new SQLException(this.inMessage.wire.getString(), state, rc);
        }
    }

    private static String getSQLState(int rc) {
        switch (rc) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return "37000";
            }
            case 30: 
            case 33: 
            case 39: {
                return "S0002";
            }
            case 31: {
                return "S0022";
            }
            case 62: {
                return "21S01";
            }
            case 103: {
                return "34000";
            }
            case 104: 
            case 108: {
                return "23000";
            }
            case 1004: {
                return "01004";
            }
            case 1031: {
                return "42000";
            }
            case 7001: {
                return "07001";
            }
            case 7006: {
                return "07006";
            }
            case 22003: {
                return "22003";
            }
            case 22005: {
                return "22005";
            }
            case 22008: {
                return "22008";
            }
            case 24000: {
                return "24000";
            }
            case 402: {
                return "28000";
            }
            case 413: 
            case 452: 
            case 461: {
                return "08S01";
            }
            case 450: {
                return "S1T00";
            }
            case 462: {
                return "S1001";
            }
            case 463: {
                return "S1002";
            }
            case 464: {
                return "S1010";
            }
            case 465: {
                return "S1090";
            }
            case 466: {
                return "S1093";
            }
            case 467: {
                return "S1097";
            }
            case 468: {
                return "S1106";
            }
            case 469: {
                return "S1C00";
            }
            case 470: {
                return "01S02";
            }
            case 471: {
                return "3C000";
            }
        }
        return "S1000";
    }

    public String getCacheJobID() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.cacheJobNumber;
    }

    public void setCacheJobID(String jobNumber) throws SQLException {
        this.cacheJobNumber = jobNumber;
    }

    public byte[] sendCustomMessage(byte[] messageName, byte[] arg) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(messageName);
                this.outMessage.wire.setRawBytes(arg);
                this.outMessage.send(this.messageCount.getCount());
                int err = this.inMessage.readMessage(0, 0, 0);
                if (err != 0) {
                    throw new SQLException("Error fetching raw byte array.", "00000", err);
                }
                return this.inMessage.wire.getTCPBuffer();
            }
            catch (SQLException sqlex) {
                throw sqlex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SQLException("sendCustomeMessage: " + ex.getMessage());
            }
        }
    }

    public RegisteredDatabases registerDatabase() {
        if (this.registeredDatabases == null) {
            this.registeredDatabases = new RegisteredDatabases();
        }
        return this.registeredDatabases;
    }

    boolean isOwner(int scn, Statement stmt) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        CachedPrepare cp = this.cachedPrepares.get(scn);
        return cp != null && stmt == cp.ownedBy;
    }

    boolean noOwner(int scn) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return this.cachedPrepares.get(scn) == null;
    }

    void markAsNotBeingExecuted(int scn, Statement stmt) throws SQLException {
    }

    void markAsBeingExecuted(int scn, Statement stmt) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachedPrepare cp = this.cachedPrepares.get(scn);
        if (cp != null && null == cp.ownedBy) {
            cp.ownedBy = stmt;
        }
    }

    void markAsBeingClosed(int scn, Statement stmt) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachedPrepare cp = this.cachedPrepares.get(scn);
        if (cp != null && null == cp.ownedBy) {
            cp.ownedBy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poolStatement(CacheStatement stmt) {
        List<CacheStatement> pool = this.statementPool;
        if (stmt instanceof CacheCallableStatement) {
            pool = this.callableStatementPool;
        } else {
            if (stmt instanceof CachePreparedShardedStatement) {
                return;
            }
            if (stmt instanceof CachePreparedStatement) {
                pool = this.preparedStatementPool;
            }
        }
        List<CacheStatement> list = pool;
        synchronized (list) {
            if (pool.size() >= 40) {
                stmt.input = null;
                stmt.output = null;
                return;
            }
            pool.add(stmt);
        }
    }

    private synchronized void closePooledConnection() throws SQLException {
        this.pooled.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetConnection(boolean send) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (send) {
                this.outMessage.wire.writeHeader(RESET_CONNECTION);
                this.outMessage.wire.set(1);
                this.outMessage.wire.set(0);
                this.outMessage.send(this.messageCount.getCount());
                this.pooled.release();
            }
            this.messageCount.count = -1;
            this.nextServerCursorNumber = 0;
            this.isolationLevel = 1;
            this.autoCommit = true;
            this.cachedPrepares.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement getStatement(List<CacheStatement> statementPool, int resultSetType, int resultSetConcurrency) {
        List<CacheStatement> list = statementPool;
        synchronized (list) {
            if (statementPool.isEmpty()) {
                return null;
            }
            CacheStatement stmt = statementPool.get(0);
            stmt.resultSetType = resultSetType;
            stmt.closed = false;
            stmt.resultSetConcurrency = resultSetConcurrency;
            stmt.outstandingReads = 0;
            stmt.serverCursorNumber = 0;
            statementPool.remove(stmt);
            return stmt;
        }
    }

    int processError(int error, int allowError) throws SQLException {
        if (error == 100 && (allowError == 100 || allowError == 504)) {
            return 100;
        }
        if (error == 403 && allowError == 403) {
            return 403;
        }
        if (error == 417 && allowError == 417) {
            return 417;
        }
        if (error == 404 && (allowError == 404 || allowError == 504)) {
            return 404;
        }
        if (allowError == -1) {
            return error;
        }
        this.getServerError(error);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            SQLWarning sQLWarning = this.warnings;
            synchronized (sQLWarning) {
                this.warnings.setNextWarning(warning);
            }
        }
    }

    public Object getOutMessage() {
        return this.outMessage;
    }

    public Object getInMessage() {
        return this.inMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() throws SQLException {
        if (this.protocolVersion < 41) {
            throw new SQLException("Not supported for protocol < 41", "IM001");
        }
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IN_TRANSACTION);
            this.outMessage.send(this.messageCount.getCount());
            int error = this.inMessage.readMessage(0, 0, -1);
            return error != 0;
        }
    }

    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, String agkc) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.getOrCreatePossiblyShardedCachePreparedStatement(resultSetType, resultSetConcurrency, sql, agkc);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getCacheResultSet(String oref) throws SQLException {
        CacheStatement statement = new CacheStatement(this, 1003, 1007, null);
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            statement.output.wire.writeHeader(0, GET_CACHE_RESULT_SET_OBJECT);
            statement.output.wire.set(oref);
            statement.output.wire.set(0);
            statement.output.send(this.messageCount.getCount());
            int error = statement.input.readMessage(0, 0, 100);
            if (error == 100) {
                statement.fetchDone = true;
            }
            statement.columnInfo(statement.input.wire);
        }
        return new CacheResultSet(statement, oref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int times) throws SQLException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int flavor, int itemSize, int itemCount, int itemType, int times, boolean nodelay, int reserved) throws SQLException {
        try {
            this.socket.setTcpNoDelay(nodelay);
        }
        catch (Exception e) {
            // empty catch block
        }
        String item = "";
        for (int j = 0; j < itemSize; ++j) {
            item = item + "x";
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING_TWO);
                this.outMessage.wire.set(flavor);
                this.outMessage.wire.set(reserved);
                this.outMessage.wire.set(itemType);
                if (itemType == 0) {
                    this.outMessage.wire.set(itemCount);
                    for (int k = 0; k < itemCount; ++k) {
                        this.outMessage.wire.set(item);
                    }
                } else {
                    this.outMessage.wire.set(itemSize);
                    this.outMessage.wire.set(item);
                }
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                if (flavor == 3) {
                    int resItems = this.inMessage.wire.getInt();
                    if (itemType == 0) {
                        for (int j = 0; j < resItems; ++j) {
                            String x = this.inMessage.wire.getString();
                        }
                    }
                }
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    public static String[] getNamespaces(String host, int port, String username, String password, String logFileName) throws Exception {
        LogFileStream logFile = null;
        Socket socket = new Socket(host, port);
        if (logFileName != null && !logFileName.equals("")) {
            logFile = new LogFileStream(logFileName);
        }
        OutStream output = new OutStream(socket.getOutputStream(), logFile);
        InStream input = new InStream(socket.getInputStream(), logFile);
        return CacheConnection.getNamespaces(input, output, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getNamespaces(InStream input, OutStream output, String username, String password) throws Exception {
        CacheConnection conn = new CacheConnection(input, output, null, username, password);
        MessageCount messageCount = conn.messageCount;
        synchronized (messageCount) {
            conn.outMessage.wire.setConnectionInfo(conn.connectionInfo);
            conn.outMessage.wire.writeHeader(0, GET_CACHE_INFO);
            conn.outMessage.wire.set(conn.user);
            conn.outMessage.wire.set(conn.password);
            conn.outMessage.send(0);
            conn.inMessage.readMessage(0, 0, 100);
        }
        int namespaceCount = conn.inMessage.wire.getInt();
        String[] namespaces = new String[namespaceCount];
        for (int i = 0; i < namespaceCount; ++i) {
            namespaces[i] = conn.inMessage.wire.getString();
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSetClientInfo(Properties info) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SET_CLIENT_INFO_PROPERTIES);
            this.outMessage.wire.set(info.size());
            if (info.containsKey("ApplicationName")) {
                this.outMessage.wire.set(13);
                this.outMessage.wire.set(info.getProperty("ApplicationName"));
            }
            if (info.containsKey("ClientHostname")) {
                this.outMessage.wire.set(12);
                this.outMessage.wire.set(info.getProperty("ClientHostname"));
            }
            if (info.containsKey("ClientUser")) {
                this.outMessage.wire.set(11);
                this.outMessage.wire.set(info.getProperty("ClientUser"));
            }
            if (info.containsKey("UserInfo")) {
                this.outMessage.wire.set(20);
                this.outMessage.wire.set(info.getProperty("UserInfo"));
            }
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    public void setSQLDialect(int dialect) {
        this.sqlDialect = dialect;
    }

    public int getSQLDialect() {
        return this.sqlDialect;
    }

    private void modifyClientInfo(String name, Properties properties, Properties info) {
        if (properties.containsKey(name)) {
            String value = properties.getProperty(name);
            if (value == null) {
                value = "";
            }
            if (!this.clientInfo.getProperty(name).equals(value)) {
                this.clientInfo.put(name, value);
                info.put(name, value);
            }
        }
    }

    int getMaxSendBuffSize() {
        if (this.securityLevel == 2 || this.securityLevel == 3) {
            return 50000;
        }
        return 10000000;
    }

    int getSendStreamImmeadiateSize() {
        if (this.securityLevel == 2 || this.securityLevel == 3) {
            return 50000;
        }
        return 100000;
    }

    synchronized int getServerCursorNumber() {
        if (this.protocolVersion >= 44 && this.recycledServerCursorNumber != -1) {
            int cursorNumber = this.recycledServerCursorNumber;
            this.recycledServerCursorNumber = -1;
            return cursorNumber;
        }
        ++this.nextServerCursorNumber;
        return this.nextServerCursorNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTwoFactorEnabled() throws Exception {
        if (this.protocolVersion < 48) {
            return false;
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IS_TWO_FACTOR_ENABLED);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            return this.inMessage.wire.getBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTwoFactorToken(String tokenName) throws Exception {
        if (this.protocolVersion < 48) {
            throw new Exception("Unsupported for protocol versions < 48");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SEND_TWO_FACTOR_TOKEN);
            this.outMessage.wire.set(tokenName);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        CacheStatement stmt;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (resultSetType == 1005) {
            this.addWarning(new SQLWarning("createStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            resultSetType = 1004;
        }
        if ((stmt = (CacheStatement)this.getStatement(this.statementPool, resultSetType, resultSetConcurrency)) == null) {
            stmt = new CacheStatement(this, resultSetType, resultSetConcurrency, null);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.sqlDialect != 0) {
            throw new SQLException("Non-Cache dialects only supported via Statement interface.");
        }
        if (resultSetType == 1005) {
            this.addWarning(new SQLWarning("prepareStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            resultSetType = 1004;
        }
        return this.getOrCreatePossiblyShardedCachePreparedStatement(resultSetType, resultSetConcurrency, sql, null);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CacheCallableStatement stmt;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.sqlDialect != 0) {
            throw new SQLException("Non-Cache dialects only supported via Statement interface.");
        }
        if (resultSetType != 1003) {
            this.addWarning(new SQLWarning("prepareCall called with unsupported result set type: TYPE_FORWARD_ONLY used instead", "IM001"));
            resultSetType = 1003;
        }
        if (resultSetConcurrency != 1007) {
            this.addWarning(new SQLWarning("prepareCall called with CONCUR_UPDATABLE which is not supported: CONCUR_READ_ONLY used instead", "IM001"));
            resultSetConcurrency = 1007;
        }
        if ((stmt = (CacheCallableStatement)this.getStatement(this.callableStatementPool, resultSetType, resultSetConcurrency)) == null) {
            return new CacheCallableStatement(this, sql);
        }
        stmt.prepare(sql);
        return stmt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int generatedKeys) throws SQLException {
        if (generatedKeys == 1) {
            return this.prepareStatement(sql, 1003, 1007, "-1");
        }
        return this.prepareStatement(sql, 1003, 1007, null);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        return this.prepareStatement(sql, 1003, 1007, Integer.toString(columnIndexes[0]));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        return this.prepareStatement(sql, 1003, 1007, columnNames[0]);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (String name : this.savepoints.keySet()) {
            if (savepoint != this.savepoints.get(name)) continue;
            this.savepoints.remove(name);
            ((CacheSavepoint)savepoint).release();
            return;
        }
        throw new SQLException("Savepoint does not exist/already released.");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot set savepoint when autocommit is on.");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap<String, Savepoint>();
        }
        ++this.savepointId;
        String name = "SAV" + this.savepointId + "PT";
        if (this.savepoints.containsKey(name)) {
            throw new SQLException("Savepoint " + name + " already exists.");
        }
        CacheSavepoint savepoint = new CacheSavepoint(this, name, this.savepointId);
        this.savepoints.put(name, savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot set savepoint when autocommit is on.");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap<String, Savepoint>();
        }
        if (this.savepoints.containsKey(name)) {
            throw new SQLException("Savepoint " + name + " already exists.");
        }
        CacheSavepoint savepoint = new CacheSavepoint(this, name, -1);
        this.savepoints.put(name, savepoint);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot rollback to savepoint when autocommit is on.");
        }
        if (!this.savepoints.containsValue(savepoint)) {
            throw new SQLException("Savepoint does not exist.");
        }
        ((CacheSavepoint)savepoint).rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout cannot be negative.");
        }
        if (this.closed) {
            return false;
        }
        try {
            this.socket.setSoTimeout(timeout * 1000);
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
            }
            this.socket.setSoTimeout(0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return (String)this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        if (!this.clientInfo.containsKey(name)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this.clientInfo.getProperty(name).equals(value)) {
            return;
        }
        Properties info = new Properties();
        info.put(name, value);
        try {
            this.sendSetClientInfo(info);
        }
        catch (Exception e) {
            throw new SQLClientInfoException();
        }
        this.clientInfo.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        if (properties.isEmpty()) {
            return;
        }
        Properties info = new Properties();
        this.modifyClientInfo("ApplicationName", properties, info);
        this.modifyClientInfo("ClientHostname", properties, info);
        this.modifyClientInfo("ClientUser", properties, info);
        this.modifyClientInfo("MachineName", properties, info);
        this.modifyClientInfo("UserInfo", properties, info);
        try {
            this.sendSetClientInfo(info);
        }
        catch (Exception e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int xepCallError(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.logFile != null) {
                this.logFile.dump(data, 0, length, 1, null);
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readHeaderXEP(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CacheListReader xepCallReturn(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.logFile != null) {
                this.logFile.dump(data, 0, length, 1, null);
            }
            this.outMessage.outputStream.flush();
            byte[] array = this.inMessage.readBytesXEP();
            return new CacheListReader(array, array.length, this.connectionInfo.serverLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<byte[]> xepCallReturnListByteArrays(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.logFile != null) {
                this.logFile.dump(data, 0, length, 1, null);
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readListofByteArraysXEP2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] xepSendBytes(byte[] header, int headerLength, byte[] data, int dataLength) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(header, 0, headerLength);
            this.outMessage.outputStream.write(data, 0, dataLength);
            if (this.logFile != null) {
                this.logFile.dump(data, 0, dataLength, 1, header);
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readBytesXEP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xepCall(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.logFile != null) {
                this.logFile.dump(data, 0, length, 1, null);
            }
            this.outMessage.outputStream.flush();
        }
    }

    public final String getHostAddress() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SCHEMA);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            return this.inMessage.wire.getString();
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        try {
            this.socket.setSoTimeout(milliseconds);
        }
        catch (SocketException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamPrefetchSize(int size) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (size < 0) {
            throw new SQLException("Prefetch size cannot be negative.");
        }
        if (size != this.streamPrefetchSize) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(STREAM_SET_PREFETCH_SIZE);
                this.outMessage.wire.set(size);
                this.outMessage.send(this.messageCount.getCount());
            }
            this.inMessage.readMessage(0, 0, 0);
            this.streamPrefetchSize = size;
        }
    }

    public int getStreamPrefetchSize() {
        return this.streamPrefetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryPrefetchSize(int size) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (size < 0) {
            throw new SQLException("Query prefetch size cannot be negative.");
        }
        if (size != this.queryPrefetchSize) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(SET_QUERY_PREFETCH_SIZE);
                this.outMessage.wire.set(size);
                this.outMessage.send(this.messageCount.getCount());
            }
            this.inMessage.readMessage(0, 0, 0);
            this.queryPrefetchSize = size;
        }
    }

    public int getQueryPrefetchSize() {
        return this.queryPrefetchSize;
    }

    private byte[] xepInvoke(int subfunction, String name1, String name2, Object ... args) {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(subfunction, XEP_METHOD);
                this.outMessage.wire.set(name1);
                this.outMessage.wire.set(name2);
                this.xepWriteParameters(args);
                this.outMessage.send(this.messageCount.getCount());
                return this.inMessage.readBytesXEP();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callNoResponseClassMethod(String className, String methodName, Object ... args) {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(6, XEP_METHOD);
                this.outMessage.wire.set(className);
                this.outMessage.wire.set(methodName);
                this.xepWriteParameters(args);
                this.outMessage.send(this.messageCount.getCount());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xepInvokeVoid(int subfunction, String name1, String name2, Object ... args) {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(subfunction, XEP_METHOD);
                this.outMessage.wire.set(name1);
                this.outMessage.wire.set(name2);
                this.xepWriteParameters(args);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readBytesXEP();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public final Object callFunction(String functionName, String routineName, Object ... args) throws RuntimeException {
        return this.asObject(this.xepInvoke(1, functionName, routineName, args));
    }

    public CacheListReader callListClassMethod(String className, String methodName, Object ... args) {
        byte[] buffer = this.xepInvoke(5, className, methodName, args);
        return new CacheListReader(buffer, buffer.length, this.connectionInfo.serverLocale);
    }

    public final void callProcedure(String procedureName, String routineName, Object ... args) {
        this.xepInvoke(0, procedureName, routineName, args);
    }

    public Object callClassMethod(String className, String methodName, Object ... args) {
        return this.asObject(this.xepInvoke(3, className, methodName, args));
    }

    public void callVoidClassMethod(String className, String methodName, Object ... args) {
        this.xepInvokeVoid(2, className, methodName, args);
    }

    public byte[] callBytesClassMethod(String className, String methodName, Object ... args) {
        return this.xepInvoke(5, className, methodName, args);
    }

    public byte[] callBytesFunction(String functionName, String routineName, Object ... args) {
        return this.xepInvoke(4, functionName, routineName, args);
    }

    public CacheListReader callListFunction(String functionName, String routineName, Object ... args) {
        byte[] buffer = this.xepInvoke(4, functionName, routineName, args);
        return new CacheListReader(buffer, buffer.length, this.connectionInfo.serverLocale);
    }

    private Object asObject(byte[] ba) {
        CacheListReader vList = new CacheListReader(ba, ba.length, this.connectionInfo.serverLocale);
        Object obj = null;
        try {
            obj = vList.getObject();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private void xepWriteParameters(Object[] parameters) throws SQLException {
        if (parameters == null) {
            this.outMessage.wire.set(0);
            return;
        }
        this.outMessage.wire.set(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null) {
                this.outMessage.wire.setNull();
                continue;
            }
            if (parameter instanceof String) {
                if (((String)parameter).equals("")) {
                    this.outMessage.wire.setNull();
                    continue;
                }
                this.outMessage.wire.set((String)parameter);
                continue;
            }
            if (parameter instanceof Integer) {
                this.outMessage.wire.set((Integer)parameter);
                continue;
            }
            if (parameter instanceof Long) {
                this.outMessage.wire.set((Long)parameter);
                continue;
            }
            if (parameter instanceof Double) {
                this.outMessage.wire.set((Double)parameter);
                continue;
            }
            if (parameter instanceof byte[]) {
                this.outMessage.wire.set((byte[])parameter);
                continue;
            }
            throw new RuntimeException("Parameter type " + parameter.getClass().getName() + " is not supported in XEP");
        }
    }

    public final CacheListBuilder getVList(byte[] byteArray) {
        CacheListBuilder vList = this.vListQueue.poll();
        if (vList == null) {
            vList = new CacheListBuilder(100000, this.connectionInfo.serverLocale);
            vList.m_isUnicodeServer = this.connectionInfo.isUnicodeServer;
        }
        vList.setList(byteArray);
        return vList;
    }

    public final CacheListBuilder getVList() {
        CacheListBuilder vList = this.vListQueue.poll();
        if (vList == null) {
            vList = new CacheListBuilder(100000, this.connectionInfo.serverLocale);
            vList.m_isUnicodeServer = this.connectionInfo.isUnicodeServer;
        }
        return vList;
    }

    public final void recycleVList(CacheListBuilder idList) {
        idList.clearList();
        this.vListQueue.add(idList);
    }

    public synchronized void xepConnect(String host, int port, String namespace, String username, String password) {
        this.xepConnect(host, port, namespace, username, password, null);
    }

    public synchronized void xepConnect(String host, int port, String namespace, String username, String password, String log) {
        this.user = username;
        this.password = password;
        if (log != null) {
            try {
                this.logFile = new LogFileStream(log);
            }
            catch (IOException ex) {
                this.logFile = null;
            }
        }
        try {
            this.connect(host, port, namespace, null, 0, true, null);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private CachePreparedStatement getOrCreatePossiblyShardedCachePreparedStatement(int rst, int rsc, String sql, String agkc) throws SQLException {
        CachePreparedStatement s = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, rst, rsc);
        if (s != null) {
            s.autoGeneratedKeyColumn = agkc;
            s.prepare(sql);
        } else {
            s = new CachePreparedStatement(this, rst, rsc, sql, agkc);
        }
        return s;
    }

    public Master getMaster() {
        return this.master;
    }

    static final class CachedPrepare {
        int serverCursorNumber;
        Statement ownedBy;
        String sqlText;
        List<CacheStatement.Parameter> parameters;
        List<CacheStatement.Column> columns;
        int statementType;
        int hasReturnValue;
        CacheListBuilder additionalParameterInfo;
        boolean multipleResultSets;

        CachedPrepare(CacheStatement stmt, boolean setOwner) {
            this.sqlText = stmt.sqlText;
            this.serverCursorNumber = stmt.serverCursorNumber;
            this.ownedBy = stmt;
            if (stmt.columns != null) {
                this.columns = new ArrayList<CacheStatement.Column>(stmt.columns);
            }
            this.parameters = stmt.saveParameterInfo();
            this.statementType = stmt.statementType;
            this.hasReturnValue = stmt.hasReturnValue;
            this.additionalParameterInfo = stmt.additionalParameterInfo;
            this.multipleResultSets = stmt.multipleResultSets;
        }

        public boolean matches(CacheStatement stmt) {
            return stmt.sqlText.equals(this.sqlText) && CacheStatement.compareParInfoString(this.additionalParameterInfo, stmt.additionalParameterInfo);
        }

        public boolean match(CacheStatement stmt) {
            if (this.ownedBy != null && this.ownedBy == stmt) {
                this.ownedBy = null;
            }
            return stmt.sqlText.equals(this.sqlText) && CacheStatement.compareParInfoString(this.additionalParameterInfo, stmt.additionalParameterInfo);
        }
    }

    static final class CachedSQL {
        int hasReturnValue;
        int statementType;
        String sqlText;
        List<CacheStatement.Parameter> parameters;
        int resultSetConcurrency;
        CacheListBuilder additionalParameterInfo;

        CachedSQL(CacheStatement stmt) {
            this.hasReturnValue = stmt.hasReturnValue;
            this.statementType = stmt.statementType;
            this.sqlText = stmt.sqlText;
            this.resultSetConcurrency = stmt.resultSetConcurrency;
            this.parameters = stmt.saveParameterInfo();
            this.additionalParameterInfo = stmt.additionalParameterInfo;
        }
    }

    protected static final class MessageCount {
        int count = 0;

        protected MessageCount() {
        }

        public final synchronized int getCount() {
            return ++this.count;
        }
    }
}

