/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.RestorableDroppedDatabaseInner;
import com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public class SqlRestorableDroppedDatabaseImpl
extends RefreshableWrapperImpl<RestorableDroppedDatabaseInner, SqlRestorableDroppedDatabase>
implements SqlRestorableDroppedDatabase {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;

    protected SqlRestorableDroppedDatabaseImpl(String resourceGroupName, String sqlServerName, RestorableDroppedDatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public Region region() {
        return Region.fromName((String)((RestorableDroppedDatabaseInner)((Object)this.innerModel())).location());
    }

    @Override
    public String databaseName() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).databaseName();
    }

    @Override
    public String edition() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).sku().tier();
    }

    @Override
    public String maxSizeBytes() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).maxSizeBytes() == null ? null : ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).maxSizeBytes().toString();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).creationDate();
    }

    @Override
    public OffsetDateTime deletionDate() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).deletionDate();
    }

    @Override
    public OffsetDateTime earliestRestoreDate() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).earliestRestoreDate();
    }

    protected Mono<RestorableDroppedDatabaseInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getRestorableDroppedDatabases().getAsync(this.resourceGroupName, this.sqlServerName, ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).id());
    }

    public String name() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((RestorableDroppedDatabaseInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }
}

