/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImportExportResponseImpl;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.ExportDatabaseDefinition;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseExportRequest;
import com.azure.resourcemanager.sql.models.SqlDatabaseImportExportResponse;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.azure.resourcemanager.storage.models.BlobContainers;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlDatabaseExportRequestImpl
extends ExecutableImpl<SqlDatabaseImportExportResponse>
implements SqlDatabaseExportRequest,
SqlDatabaseExportRequest.SqlDatabaseExportRequestDefinition {
    private final SqlDatabaseImpl sqlDatabase;
    private final SqlServerManager sqlServerManager;
    private ExportDatabaseDefinition inner;

    SqlDatabaseExportRequestImpl(SqlDatabaseImpl sqlDatabase, SqlServerManager sqlServerManager) {
        this.sqlDatabase = sqlDatabase;
        this.sqlServerManager = sqlServerManager;
        this.inner = new ExportDatabaseDefinition();
    }

    public SqlDatabase parent() {
        return this.sqlDatabase;
    }

    public ExportDatabaseDefinition innerModel() {
        return this.inner;
    }

    public Mono<SqlDatabaseImportExportResponse> executeWorkAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().exportAsync(this.sqlDatabase.resourceGroupName, this.sqlDatabase.sqlServerName, this.sqlDatabase.name(), this.innerModel()).map(SqlDatabaseImportExportResponseImpl::new);
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(String storageUri) {
        if (this.inner == null) {
            this.inner = new ExportDatabaseDefinition();
        }
        this.inner.withStorageUri(storageUri);
        return this;
    }

    private Mono<Indexable> getOrCreateStorageAccountContainer(StorageAccount storageAccount, String containerName, String fileName, FunctionalTaskItem.Context context) {
        SqlDatabaseExportRequestImpl self = this;
        return storageAccount.getKeysAsync().flatMap(storageAccountKeys -> Mono.justOrEmpty(storageAccountKeys.stream().findFirst())).flatMap(storageAccountKey -> {
            self.inner.withStorageUri(String.format("%s%s/%s", storageAccount.endPoints().primary().blob(), containerName, fileName));
            self.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
            self.inner.withStorageKey(storageAccountKey.value());
            BlobContainers blobContainers = this.sqlServerManager.storageManager().blobContainers();
            return blobContainers.getAsync(this.parent().resourceGroupName(), storageAccount.name(), containerName).onErrorResume(error -> {
                if (error instanceof ManagementException && ((ManagementException)error).getResponse().getStatusCode() == 404) {
                    return blobContainers.defineContainer(containerName).withExistingStorageAccount(this.parent().resourceGroupName(), storageAccount.name()).withPublicAccess(PublicAccess.NONE).createAsync();
                }
                return Mono.error((Throwable)error);
            });
        });
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(fileName);
        if (this.inner == null) {
            this.inner = new ExportDatabaseDefinition();
        }
        this.addDependency(context -> this.getOrCreateStorageAccountContainer(storageAccount, containerName, fileName, (FunctionalTaskItem.Context)context));
        return this;
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(Creatable<StorageAccount> storageAccountCreatable, String containerName, String fileName) {
        if (this.inner == null) {
            this.inner = new ExportDatabaseDefinition();
        }
        this.addDependency(context -> storageAccountCreatable.createAsync().flatMap(storageAccount -> this.getOrCreateStorageAccountContainer((StorageAccount)storageAccount, containerName, fileName, (FunctionalTaskItem.Context)context)));
        return this;
    }

    SqlDatabaseExportRequestImpl withStorageKeyType(StorageKeyType storageKeyType) {
        this.inner.withStorageKeyType(storageKeyType);
        return this;
    }

    @Override
    public SqlDatabaseExportRequestImpl withStorageAccessKey(String storageAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
        this.inner.withStorageKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseExportRequestImpl withSharedAccessKey(String sharedAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.SHARED_ACCESS_KEY);
        this.inner.withStorageKey(sharedAccessKey);
        return this;
    }

    SqlDatabaseExportRequestImpl withStorageKey(String storageKey) {
        this.inner.withStorageKey(storageKey);
        return this;
    }

    SqlDatabaseExportRequestImpl withAuthenticationType(AuthenticationType authenticationType) {
        this.inner.withAuthenticationType(authenticationType.toString());
        return this;
    }

    @Override
    public SqlDatabaseExportRequestImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.SQL.toString());
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    @Override
    public SqlDatabaseExportRequestImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.ADPASSWORD.toString());
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    SqlDatabaseExportRequestImpl withLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAdministratorLogin(administratorLogin);
        this.inner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }
}

