/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ReplicationLinkInner;
import com.azure.resourcemanager.sql.models.ReplicationLink;
import com.azure.resourcemanager.sql.models.ReplicationRole;
import com.azure.resourcemanager.sql.models.ReplicationState;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

class ReplicationLinkImpl
extends RefreshableWrapperImpl<ReplicationLinkInner, ReplicationLink>
implements ReplicationLink {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected ReplicationLinkImpl(String resourceGroupName, String sqlServerName, ReplicationLinkInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((ReplicationLinkInner)((Object)this.innerModel())).id());
    }

    protected Mono<ReplicationLinkInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public String partnerServer() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).partnerServer();
    }

    @Override
    public String partnerDatabase() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).partnerDatabase();
    }

    @Override
    public String partnerLocation() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).partnerLocation();
    }

    @Override
    public ReplicationRole role() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).role();
    }

    @Override
    public ReplicationRole partnerRole() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).partnerRole();
    }

    @Override
    public OffsetDateTime startTime() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).startTime();
    }

    @Override
    public int percentComplete() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ReplicationLinkInner)((Object)this.innerModel())).percentComplete());
    }

    @Override
    public ReplicationState replicationState() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).replicationState();
    }

    @Override
    public boolean isTerminationAllowed() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).isTerminationAllowed();
    }

    @Override
    public String replicationMode() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).replicationMode();
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().delete(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public void failover() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failover(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Mono<Void> failoverAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).then();
    }

    @Override
    public void forceFailoverAllowDataLoss() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAllowDataLoss(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Mono<Void> forceFailoverAllowDataLossAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAllowDataLossAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).then();
    }

    public String name() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((ReplicationLinkInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }
}

