/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling.engine;

import com.dbeaver.ui.editors.spelling.engine.AbstractSpellDictionary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jkiss.dbeaver.Log;

public class PersistentSpellDictionary
extends AbstractSpellDictionary {
    private static final Log log = Log.getLog(PersistentSpellDictionary.class);
    private final URL fLocation;

    public PersistentSpellDictionary(URL url) {
        this.fLocation = url;
    }

    @Override
    public boolean acceptsWords() {
        return true;
    }

    @Override
    public void addWord(String word) {
        if (this.isCorrect(word)) {
            return;
        }
        FileOutputStream fileStream = null;
        try {
            try {
                byte[] byteArray;
                Charset charset = StandardCharsets.UTF_8;
                ByteBuffer byteBuffer = charset.encode(String.valueOf(word) + "\n");
                int size = byteBuffer.limit();
                if (byteBuffer.hasArray()) {
                    byteArray = byteBuffer.array();
                } else {
                    byteArray = new byte[size];
                    byteBuffer.get(byteArray);
                }
                fileStream = new FileOutputStream(this.fLocation.getPath(), true);
                int bomCutSize = 0;
                if (!this.isEmpty() && "UTF-16".equals(charset.name())) {
                    bomCutSize = 2;
                }
                fileStream.write(byteArray, bomCutSize, size - bomCutSize);
            }
            catch (IOException exception) {
                log.error((Object)exception);
                try {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                return;
            }
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        this.hashWord(word);
    }

    @Override
    protected final URL getURL() {
        return this.fLocation;
    }
}

