/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.DefaultSpellingProblem;
import com.dbeaver.ui.editors.spelling.SpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellEvent;
import com.dbeaver.ui.editors.spelling.engine.ISpellEventListener;
import com.dbeaver.ui.editors.spelling.internal.SpellingActivator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public abstract class SpellingEngine
implements ISpellingEngine {
    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellCheckEngine spellingEngine;
        ISpellChecker checker;
        if (collector != null && (checker = (spellingEngine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
            this.check(document, regions, checker, context, collector, monitor);
        }
    }

    protected abstract void check(IDocument var1, IRegion[] var2, ISpellChecker var3, SpellingContext var4, ISpellingProblemCollector var5, IProgressMonitor var6);

    protected static class SpellEventListener
    implements ISpellEventListener {
        private final ISpellingProblemCollector problemCollector;
        private final IDocument document;
        private final int problemsThreshold;
        private int problemCount;

        public SpellEventListener(ISpellingProblemCollector problemCollector, IDocument document) {
            this.problemCollector = problemCollector;
            this.document = document;
            this.problemsThreshold = SpellingActivator.getDefault().getPreferences().getInt("spelling_problems_threshold");
        }

        @Override
        public void handle(ISpellEvent event) {
            if (this.isProblemsThresholdReached()) {
                return;
            }
            ++this.problemCount;
            this.problemCollector.accept((SpellingProblem)new DefaultSpellingProblem(event, this.document));
        }

        public boolean isProblemsThresholdReached() {
            return this.problemCount >= this.problemsThreshold;
        }
    }
}

