/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AzureEnvironment {
    private final Map<String, String> endpoints;
    public static final AzureEnvironment AZURE = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "https://portal.azure.com");
            this.put("publishingProfileUrl", "http://go.microsoft.com/fwlink/?LinkId=254432");
            this.put("managementEndpointUrl", "https://management.core.windows.net/");
            this.put("resourceManagerEndpointUrl", "https://management.azure.com/");
            this.put("sqlManagementEndpointUrl", "https://management.core.windows.net:8443/");
            this.put("sqlServerHostnameSuffix", ".database.windows.net");
            this.put("galleryEndpointUrl", "https://gallery.azure.com/");
            this.put("activeDirectoryEndpointUrl", "https://login.microsoftonline.com/");
            this.put("activeDirectoryResourceId", "https://management.core.windows.net/");
            this.put("activeDirectoryGraphResourceId", "https://graph.windows.net/");
            this.put("microsoftGraphResourceId", "https://graph.microsoft.com/");
            this.put("dataLakeEndpointResourceId", "https://datalake.azure.net/");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.windows.net");
            this.put("keyVaultDnsSuffix", ".vault.azure.net");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "azuredatalakestore.net");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "azuredatalakeanalytics.net");
            this.put("azureLogAnalyticsResourceId", "https://api.loganalytics.io/");
            this.put("azureApplicationInsightsResourceId", "https://api.applicationinsights.io/");
            this.put("managedHsmDnsSuffix", ".managedhsm.azure.net");
        }
    });
    public static final AzureEnvironment AZURE_CHINA = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "https://portal.azure.cn");
            this.put("publishingProfileUrl", "http://go.microsoft.com/fwlink/?LinkID=301774");
            this.put("managementEndpointUrl", "https://management.core.chinacloudapi.cn/");
            this.put("resourceManagerEndpointUrl", "https://management.chinacloudapi.cn/");
            this.put("sqlManagementEndpointUrl", "https://management.core.chinacloudapi.cn:8443/");
            this.put("sqlServerHostnameSuffix", ".database.chinacloudapi.cn");
            this.put("galleryEndpointUrl", "https://gallery.chinacloudapi.cn/");
            this.put("activeDirectoryEndpointUrl", "https://login.chinacloudapi.cn/");
            this.put("activeDirectoryResourceId", "https://management.core.chinacloudapi.cn/");
            this.put("activeDirectoryGraphResourceId", "https://graph.chinacloudapi.cn/");
            this.put("microsoftGraphResourceId", "https://microsoftgraph.chinacloudapi.cn/");
            this.put("dataLakeEndpointResourceId", "N/A");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.chinacloudapi.cn");
            this.put("keyVaultDnsSuffix", ".vault.azure.cn");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/A");
            this.put("azureLogAnalyticsResourceId", "N/A");
            this.put("azureApplicationInsightsResourceId", "N/A");
            this.put("managedHsmDnsSuffix", ".managedhsm.azure.cn");
        }
    });
    public static final AzureEnvironment AZURE_US_GOVERNMENT = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "https://portal.azure.us");
            this.put("publishingProfileUrl", "https://manage.windowsazure.us/publishsettings/index");
            this.put("managementEndpointUrl", "https://management.core.usgovcloudapi.net/");
            this.put("resourceManagerEndpointUrl", "https://management.usgovcloudapi.net/");
            this.put("sqlManagementEndpointUrl", "https://management.core.usgovcloudapi.net:8443/");
            this.put("sqlServerHostnameSuffix", ".database.usgovcloudapi.net");
            this.put("galleryEndpointUrl", "https://gallery.usgovcloudapi.net/");
            this.put("activeDirectoryEndpointUrl", "https://login.microsoftonline.us/");
            this.put("activeDirectoryResourceId", "https://management.core.usgovcloudapi.net/");
            this.put("activeDirectoryGraphResourceId", "https://graph.windows.net/");
            this.put("microsoftGraphResourceId", "https://graph.microsoft.us/");
            this.put("dataLakeEndpointResourceId", "N/A");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.usgovcloudapi.net");
            this.put("keyVaultDnsSuffix", ".vault.usgovcloudapi.net");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/A");
            this.put("azureLogAnalyticsResourceId", "https://api.loganalytics.us/");
            this.put("azureApplicationInsightsResourceId", "N/A");
            this.put("managedHsmDnsSuffix", ".managedhsm.usgovcloudapi.net");
        }
    });
    @Deprecated
    public static final AzureEnvironment AZURE_GERMANY = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "https://portal.microsoftazure.de");
            this.put("publishingProfileUrl", "https://manage.microsoftazure.de/publishsettings/index");
            this.put("managementEndpointUrl", "https://management.core.cloudapi.de/");
            this.put("resourceManagerEndpointUrl", "https://management.microsoftazure.de/");
            this.put("sqlManagementEndpointUrl", "https://management.core.cloudapi.de:8443/");
            this.put("sqlServerHostnameSuffix", ".database.cloudapi.de");
            this.put("galleryEndpointUrl", "https://gallery.cloudapi.de/");
            this.put("activeDirectoryEndpointUrl", "https://login.microsoftonline.de/");
            this.put("activeDirectoryResourceId", "https://management.core.cloudapi.de/");
            this.put("activeDirectoryGraphResourceId", "https://graph.cloudapi.de/");
            this.put("microsoftGraphResourceId", "https://graph.microsoft.de/");
            this.put("dataLakeEndpointResourceId", "N/A");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.cloudapi.de");
            this.put("keyVaultDnsSuffix", ".vault.microsoftazure.de");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/A");
            this.put("azureLogAnalyticsResourceId", "N/A");
            this.put("azureApplicationInsightsResourceId", "N/A");
            this.put("managedHsmDnsSuffix", "N/A");
        }
    });

    public AzureEnvironment(Map<String, String> endpoints) {
        this.endpoints = endpoints;
    }

    public Map<String, String> getEndpoints() {
        return this.endpoints;
    }

    public static List<AzureEnvironment> knownEnvironments() {
        return Arrays.asList(AZURE, AZURE_CHINA, AZURE_US_GOVERNMENT);
    }

    public String getPortal() {
        return this.endpoints.get("portalUrl");
    }

    public String getPublishingProfile() {
        return this.endpoints.get("publishingProfileUrl");
    }

    public String getManagementEndpoint() {
        return this.endpoints.get("managementEndpointUrl");
    }

    public String getResourceManagerEndpoint() {
        return this.endpoints.get("resourceManagerEndpointUrl");
    }

    public String getSqlManagementEndpoint() {
        return this.endpoints.get("sqlManagementEndpointUrl");
    }

    public String getSqlServerHostnameSuffix() {
        return this.endpoints.get("sqlServerHostnameSuffix");
    }

    public String getActiveDirectoryEndpoint() {
        return this.endpoints.get("activeDirectoryEndpointUrl").replaceAll("/$", "") + "/";
    }

    public String getActiveDirectoryResourceId() {
        return this.endpoints.get("activeDirectoryResourceId");
    }

    public String getGalleryEndpoint() {
        return this.endpoints.get("galleryEndpointUrl");
    }

    public String getGraphEndpoint() {
        return this.endpoints.get("activeDirectoryGraphResourceId");
    }

    public String getMicrosoftGraphEndpoint() {
        return this.endpoints.get("microsoftGraphResourceId");
    }

    public String getDataLakeEndpointResourceId() {
        return this.endpoints.get("dataLakeEndpointResourceId");
    }

    public String getActiveDirectoryGraphApiVersion() {
        return this.endpoints.get("activeDirectoryGraphApiVersion");
    }

    public String getStorageEndpointSuffix() {
        return this.endpoints.get("storageEndpointSuffix");
    }

    public String getKeyVaultDnsSuffix() {
        return this.endpoints.get("keyVaultDnsSuffix");
    }

    public String getAzureDataLakeStoreFileSystemEndpointSuffix() {
        return this.endpoints.get("azureDataLakeStoreFileSystemEndpointSuffix");
    }

    public String getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix() {
        return this.endpoints.get("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix");
    }

    public String getLogAnalyticsEndpoint() {
        return this.endpoints.get("azureLogAnalyticsResourceId");
    }

    public String getApplicationInsightsEndpoint() {
        return this.endpoints.get("azureApplicationInsightsResourceId");
    }

    public String getUrlByEndpoint(Endpoint endpoint) {
        return this.endpoints.get(endpoint.identifier());
    }

    public static enum Endpoint {
        MANAGEMENT("managementEndpointUrl"),
        RESOURCE_MANAGER("resourceManagerEndpointUrl"),
        SQL("sqlManagementEndpointUrl"),
        GALLERY("galleryEndpointUrl"),
        ACTIVE_DIRECTORY("activeDirectoryEndpointUrl"),
        GRAPH("activeDirectoryGraphResourceId"),
        KEYVAULT("keyVaultDnsSuffix"),
        DATA_LAKE_STORE("azureDataLakeStoreFileSystemEndpointSuffix"),
        DATA_LAKE_ANALYTICS("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix"),
        LOG_ANALYTICS("azureLogAnalyticsResourceId"),
        APPLICATION_INSIGHTS("azureApplicationInsightsResourceId"),
        MICROSOFT_GRAPH("microsoftGraphResourceId"),
        MANAGED_HSM("managedHsmDnsSuffix");

        private final String field;

        private Endpoint(String value) {
            this.field = value;
        }

        public String identifier() {
            return this.field;
        }

        public String toString() {
            return this.field;
        }
    }
}

