/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class CovarianceFlux
extends AbstractParametrizedFlux {
    public CovarianceFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "covariance";
    }

    @Nonnull
    public CovarianceFlux withColumns(@Nonnull String[] columns) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        if (columns.length != 2) {
            throw new IllegalArgumentException("Exactly two columns must be provided.");
        }
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public CovarianceFlux withColumns(@Nonnull Collection<String> columns) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        if (columns.size() != 2) {
            throw new IllegalArgumentException("Exactly two columns must be provided.");
        }
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public CovarianceFlux withPearsonr(boolean pearsonr) {
        this.withPropertyValue("pearsonr", pearsonr);
        return this;
    }

    @Nonnull
    public CovarianceFlux withValueDst(@Nonnull String valueDst) {
        Arguments.checkNonEmpty((String)valueDst, (String)"Value destination");
        this.withPropertyValueEscaped("valueDst", valueDst);
        return this;
    }
}

