/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Expression;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.VariableAssignment;
import com.influxdb.query.dsl.functions.AbstractFunctionCallFlux;
import com.influxdb.query.dsl.functions.properties.FunctionsParameters;
import com.influxdb.query.dsl.functions.properties.TimeInterval;
import com.influxdb.query.dsl.utils.ImportUtils;
import com.influxdb.utils.Arguments;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractFunctionFlux<CALL extends AbstractFunctionCallFlux>
extends VariableAssignment {
    @Nonnull
    private final Function<String, CALL> invocationFactory;
    @Nonnull
    private final Parameter[] parameter;

    protected AbstractFunctionFlux(@Nonnull String name, @Nonnull Expression functionDefinition, @Nonnull Function<String, CALL> invocationFactory, Parameter ... parameter) {
        super(name, functionDefinition);
        this.invocationFactory = invocationFactory;
        this.parameter = parameter;
    }

    @Override
    public String toString(@Nonnull Map<String, Object> parameters, boolean prependImports) {
        StringBuilder builder = new StringBuilder();
        if (prependImports) {
            builder.append(ImportUtils.getImportsString(this));
        }
        builder.append(this.name).append(" = ").append(Arrays.stream(this.parameter).map(Parameter::toString).collect(Collectors.joining(", ", "(", ") => "))).append(this.expression.toString(parameters, false));
        return builder.toString();
    }

    @Nonnull
    public CALL invoke() {
        return (CALL)((AbstractFunctionCallFlux)this.invocationFactory.apply(this.getVariableName()));
    }

    @Nonnull
    public CALL invokePiped(@Nonnull Flux flux) {
        Arguments.checkNotNull((Object)flux, (String)"Source is required");
        CALL invoke = this.invoke();
        ((AbstractFunctionCallFlux)invoke).source = flux;
        return invoke;
    }

    @Override
    public Set<String> getImports() {
        return super.getImports();
    }

    public static class Parameter {
        @Nonnull
        private final String name;
        private String defaultValue;
        private boolean pipeForward;
        private boolean optional;

        public Parameter(@Nonnull String name) {
            Arguments.checkNotNull((Object)name, (String)"name");
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Nonnull
        public Parameter withDefaultValue(@Nonnull Number defaultValue) {
            Arguments.checkNotNull((Object)defaultValue, (String)"defaultValue");
            this.defaultValue = String.valueOf(defaultValue);
            return this;
        }

        @Nonnull
        public Parameter withDefaultValue(@Nonnull String defaultValue) {
            Arguments.checkNotNull((Object)defaultValue, (String)"defaultValue");
            this.defaultValue = "\"" + FunctionsParameters.escapeDoubleQuotes(defaultValue) + "\"";
            return this;
        }

        @Nonnull
        public Parameter withDefaultValue(boolean defaultValue) {
            this.defaultValue = String.valueOf(defaultValue);
            return this;
        }

        @Nonnull
        public Parameter withDefaultValue(long amount, @Nonnull ChronoUnit unit) {
            Arguments.checkNotNull((Object)unit, (String)"unit");
            this.defaultValue = new TimeInterval(amount, unit).toString();
            return this;
        }

        @Nonnull
        public Parameter withPipeForward(boolean pipeForward) {
            this.pipeForward = pipeForward;
            return this;
        }

        @Nonnull
        public Parameter withOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.optional) {
                result.append("?");
            }
            result.append(this.name);
            if (this.pipeForward) {
                result.append("=<-");
            } else if (this.defaultValue != null) {
                result.append(" = ").append(this.defaultValue);
            }
            return result.toString();
        }
    }
}

