/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMEvent;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEventEntity;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.filters.QMAdminEventCriteria;
import org.jkiss.dbeaver.model.qm.filters.QMDateRange;
import org.jkiss.dbeaver.model.qm.filters.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.filters.QMSortField;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;
import org.jkiss.dbeaver.model.rm.RMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

class QMDBEventCursor
implements QMEventCursor {
    private static final Log log = Log.getLog(QMDBEventCursor.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final int EVENTS_MAX_SIZE = 2000;
    private final Statement eventStat;
    private final ResultSet eventResults;
    private final Connection dbConnection;
    private QMMetaEventEntity nextEvent;
    private Boolean hasNext;
    private QMEventFilter filter;
    private QMEmbeddedService qmEmbeddedService;
    private final QMAdminEventCriteria adminCriteria;

    public QMDBEventCursor(QMEmbeddedService qmEmbeddedService, @NotNull QMAdminEventCriteria adminCriteria, QMEventFilter filter) throws SQLException {
        this.filter = filter;
        this.qmEmbeddedService = qmEmbeddedService;
        this.dbConnection = QMDBModel.getInstance().getConnection();
        this.eventStat = this.dbConnection.createStatement(1004, 1007);
        this.adminCriteria = adminCriteria;
        QMEventCriteria criteria = adminCriteria.getCriteria();
        try {
            String sql;
            String qmDatasourceJoin;
            this.eventStat.setFetchSize(200);
            this.eventStat.setMaxRows(2000);
            String searchString = criteria.getSearchString();
            if (!CommonUtils.isEmpty((String)searchString)) {
                searchString = searchString.replace("'", "''").toLowerCase();
                log.debug((Object)("Searching event history for '" + searchString + "'"));
            } else {
                log.debug((Object)"Loading event history");
            }
            String sqlFilter = this.buildFilter(criteria);
            StringBuilder whereStatementBuilder = new StringBuilder();
            String orderBy = this.buildOrder(criteria);
            String string = qmDatasourceJoin = criteria.hasDriverIds() || criteria.getSortField() == QMSortField.DRIVER ? "JOIN {table_prefix}QM_DATASOURCE d ON d.DATASOURCE_ID = c.DATASOURCE_ID\n" : "";
            if (CommonUtils.isEmpty((String)searchString)) {
                if (CommonUtils.isNotEmpty((String)sqlFilter)) {
                    whereStatementBuilder.append("WHERE ").append(sqlFilter).append("\n");
                }
                sql = "SELECT \ne.CONNECTION_ID,e.EVENT_ACTION,e.EVENT_TYPE,e.EVENT_TIME,\nc.PROJECT_ID,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT, e.EVENT_ID, u.USER_NAME, u.DOMAIN_NAME, us.APP_SESSION_ID \nFROM {table_prefix}QM_EVENT e\nLEFT JOIN {table_prefix}QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID \nJOIN {table_prefix}QM_DBEAVER_PROJECT p ON p.PROJECT_ID = c.PROJECT_ID \n" + qmDatasourceJoin + "LEFT JOIN {table_prefix}QM_USER_SESSION us ON us.SESSION_ID = c.SESSION_ID\n" + "LEFT JOIN {table_prefix}QM_USER u ON u.USER_ID = us.USER_ID\n" + "LEFT OUTER JOIN {table_prefix}QM_STATEMENT s ON s.STATEMENT_ID = e.EVENT_ID\n" + "LEFT OUTER JOIN {table_prefix}QM_QUERY q ON q.QUERY_ID = s.QUERY_ID\n" + whereStatementBuilder + orderBy;
            } else {
                whereStatementBuilder.append("WHERE q.QUERY_TEXT ILIKE '%").append(searchString).append("%' \n");
                if (CommonUtils.isNotEmpty((String)sqlFilter)) {
                    whereStatementBuilder.append(" AND ").append(sqlFilter).append("\n");
                }
                sql = "SELECT \ne.CONNECTION_ID,e.EVENT_ACTION,EVENT_TYPE,e.EVENT_TIME,\nc.PROJECT_ID,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT, e.EVENT_ID, u.USER_NAME, u.DOMAIN_NAME, us.APP_SESSION_ID \nFROM {table_prefix}QM_QUERY q\nJOIN {table_prefix}QM_STATEMENT s ON s.QUERY_ID = q.QUERY_ID\nJOIN {table_prefix}QM_EVENT e ON e.EVENT_ID = s.STATEMENT_ID \nJOIN {table_prefix}QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID\nJOIN {table_prefix}QM_DBEAVER_PROJECT p ON p.PROJECT_ID = c.PROJECT_ID\n" + qmDatasourceJoin + "LEFT JOIN {table_prefix}QM_USER_SESSION us ON us.SESSION_ID = c.SESSION_ID\n" + "LEFT JOIN {table_prefix}QM_USER u ON u.USER_ID = us.USER_ID\n" + whereStatementBuilder + orderBy;
            }
            this.eventResults = this.eventStat.executeQuery(this.normalizeTableNames(sql));
        }
        catch (SQLException e) {
            this.eventStat.close();
            throw e;
        }
    }

    private String buildOrder(QMEventCriteria criteria) {
        StringBuilder orderByBuilder = new StringBuilder();
        orderByBuilder.append("ORDER BY ");
        String eventTimeColumn = "e.EVENT_TIME";
        String desc = " DESC";
        String descending = criteria.isDesc() ? desc : " ASC";
        String descendingAndOrderByEventTime = String.valueOf(descending) + ", " + eventTimeColumn + desc;
        switch (criteria.getSortField()) {
            case USER: {
                orderByBuilder.append("u.USER_NAME").append(descendingAndOrderByEventTime);
                break;
            }
            case DRIVER: {
                orderByBuilder.append("d.DRIVER").append(descendingAndOrderByEventTime);
                break;
            }
            case QUERY_TEXT: {
                orderByBuilder.append("q.QUERY_TEXT").append(descendingAndOrderByEventTime);
                break;
            }
            default: {
                orderByBuilder.append(eventTimeColumn).append(descending);
            }
        }
        return orderByBuilder.toString();
    }

    private String buildFilter(QMEventCriteria criteria) {
        boolean hasQueryFilter;
        if (ArrayUtils.isEmpty((Object[])criteria.getObjectTypes())) {
            return "FALSE";
        }
        ArrayList<String> andConditions = new ArrayList<String>();
        ArrayList<String> orConditions = new ArrayList<String>();
        boolean bl = hasQueryFilter = criteria.hasObjectType(QMObjectType.query) && !ArrayUtils.isEmpty((Object[])criteria.getQueryTypes());
        if (criteria.hasObjectTypes() || hasQueryFilter) {
            List typeIds = Arrays.stream(criteria.getObjectTypes()).flatMap(t -> t.getTypes().stream().map(QMMetaObjectType::getId)).collect(Collectors.toList());
            if (typeIds.isEmpty() && !hasQueryFilter) {
                return "FALSE";
            }
            if (!typeIds.isEmpty()) {
                orConditions.add("EVENT_TYPE" + QMDBEventCursor.in(typeIds));
            }
        }
        if (hasQueryFilter) {
            List queryTypeIds = Arrays.stream(criteria.getQueryTypes()).map(DBCExecutionPurpose::getId).collect(Collectors.toList());
            orConditions.add("STATEMENT_PURPOSE" + QMDBEventCursor.in(queryTypeIds));
        }
        if (criteria.isSkipEmptyQueries()) {
            andConditions.add("(q.QUERY_TEXT IS NOT NULL or e.EVENT_TYPE = 1)");
        }
        if (this.adminCriteria.hasUsers()) {
            String usersFilterWhere = "u.USER_NAME" + QMDBEventCursor.in(this.adminCriteria.getUsers());
            andConditions.add(usersFilterWhere);
        }
        if (criteria.hasSessionId()) {
            String sessionFilterWhere = "c.SESSION_ID = " + criteria.getSessionId();
            andConditions.add(sessionFilterWhere);
        }
        if (criteria.hasDriverIds()) {
            String driversFilterWhere = "d.DRIVER" + QMDBEventCursor.in(criteria.getDriverIds());
            andConditions.add(driversFilterWhere);
        }
        if (criteria.hasLastEventId()) {
            String eventIdFilterWhere = "e.EVENT_ID > " + criteria.getLastEventId();
            andConditions.add(eventIdFilterWhere);
        }
        if (criteria.hasProjectIds()) {
            HashSet<String> projects = new HashSet<String>(criteria.getProjectIds());
            for (String projectId : criteria.getProjectIds()) {
                try {
                    projects.add(RMUtils.getProjectName((String)projectId));
                }
                catch (DBException dBException) {
                    log.error((Object)("Cannot get project name from " + projectId));
                }
            }
            String projectNames = "p.PROJECT_NAME" + QMDBEventCursor.in(projects);
            andConditions.add(projectNames);
        }
        if (criteria.hasEventStatuses()) {
            Set statuses = criteria.getEventStatuses();
            StringBuilder statusFilterWhere = new StringBuilder();
            statusFilterWhere.append("(");
            String statusCondition = statuses.stream().map(status -> {
                switch (status) {
                    case FAILED: {
                        return "s.ERROR_MESSAGE IS NOT NULL";
                    }
                    case SUCCESS: {
                        return "s.ERROR_MESSAGE IS NULL";
                    }
                }
                return "FALSE";
            }).collect(Collectors.joining(" OR "));
            statusFilterWhere.append(statusCondition);
            statusFilterWhere.append(")");
            andConditions.add(statusFilterWhere.toString());
        }
        if (criteria.getStartDateRange() != null) {
            QMDateRange startDateRange = criteria.getStartDateRange();
            StringBuilder dateRangeFilterWhere = new StringBuilder();
            dateRangeFilterWhere.append("(");
            if (startDateRange.getFrom() != null) {
                dateRangeFilterWhere.append("e.EVENT_TIME > ").append(QMDBEventCursor.escapeString(QMDBEventCursor.convertStringToDateTime(startDateRange.getFrom())));
            }
            if (startDateRange.getTo() != null) {
                if (startDateRange.getFrom() != null) {
                    dateRangeFilterWhere.append(" AND ");
                }
                dateRangeFilterWhere.append("e.EVENT_TIME < ").append(QMDBEventCursor.escapeString(QMDBEventCursor.convertStringToDateTime(startDateRange.getTo())));
            }
            dateRangeFilterWhere.append(")");
            andConditions.add(dateRangeFilterWhere.toString());
        }
        StringBuilder filter = new StringBuilder();
        if (!orConditions.isEmpty()) {
            filter.append("(").append(String.join((CharSequence)" OR ", orConditions)).append(")");
        }
        if (!andConditions.isEmpty()) {
            if (!orConditions.isEmpty()) {
                filter.append(" AND ");
            }
            filter.append("(").append(String.join((CharSequence)" AND ", andConditions)).append(")");
        }
        return filter.toString();
    }

    private static String convertStringToDateTime(String time) {
        return LocalDateTime.ofInstant(ZonedDateTime.parse(time, DateTimeFormatter.ISO_DATE_TIME).toInstant(), ZoneOffset.UTC).format(FORMATTER);
    }

    private static String in(Collection<?> values) {
        List escapedValues = values.stream().map(Object::toString).map(QMDBEventCursor::escapeString).collect(Collectors.toList());
        return " IN (" + String.join((CharSequence)", ", escapedValues) + ")";
    }

    private static String escapeString(String value) {
        return "'" + value + "'";
    }

    public long getTotalSize() {
        return -1L;
    }

    public void scroll(int position, DBRProgressMonitor monitor) throws DBException {
        try {
            this.eventResults.absolute(position + 1);
        }
        catch (SQLException e) {
            throw new DBException("Error scrolling cursor", (Throwable)e);
        }
    }

    public boolean hasNextEvent(DBRProgressMonitor monitor) throws DBException {
        this.fetchNext();
        return this.hasNext != null && this.hasNext != false;
    }

    public QMMetaEventEntity nextEvent(DBRProgressMonitor monitor) throws DBException {
        try {
            if (this.nextEvent != null) {
                QMMetaEventEntity qMMetaEventEntity = this.nextEvent;
                return qMMetaEventEntity;
            }
            this.fetchNext();
            QMMetaEventEntity qMMetaEventEntity = this.nextEvent;
            return qMMetaEventEntity;
        }
        finally {
            this.hasNext = null;
            this.nextEvent = null;
        }
    }

    private void fetchNext() throws DBException {
        if (this.nextEvent != null || this.hasNext != null) {
            return;
        }
        do {
            QMMConnectionInfo object;
            long eventStart;
            try {
                this.hasNext = this.eventResults.next();
            }
            catch (SQLException e) {
                throw new DBException("Error fetching cursor", (Throwable)e);
            }
            if (!this.hasNext.booleanValue()) {
                return;
            }
            int i = 1;
            long connectionId = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)i++);
            int eventAction = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            int eventType = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            Timestamp eventTime = JDBCUtils.safeGetTimestamp((ResultSet)this.eventResults, (int)i++);
            long projectId = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)i++);
            String containerId = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            String instanceId = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            String contextName = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            int statementPurpose = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            long rowCount = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)i++);
            int errorCode = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            String errorMessage = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            int execTime = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            int fetchTime = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)i++);
            String queryText = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            long eventId = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)i++);
            String userName = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            String domainName = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            String appSessionId = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)i++);
            long l = eventStart = eventTime == null ? 0L : ((Date)eventTime).getTime();
            if (instanceId == null) {
                instanceId = "";
            }
            QMMConnectionInfo connectionInfo = this.qmEmbeddedService.getConnectionInfo(this.dbConnection, projectId, connectionId, containerId, instanceId, contextName, eventStart);
            QMEventAction action = QMEventAction.getById((int)eventAction);
            if (eventType == 1) {
                if (action == QMEventAction.BEGIN) {
                    connectionInfo.setOpenTime(eventStart);
                } else if (action == QMEventAction.END) {
                    connectionInfo.setCloseTime(eventStart);
                }
                object = connectionInfo;
            } else {
                QMMStatementInfo stmt = new QMMStatementInfo(eventStart, eventStart + (long)execTime, connectionInfo, DBCExecutionPurpose.getById((int)statementPurpose));
                object = new QMMStatementExecuteInfo(eventStart, eventStart + (long)execTime, stmt, queryText, rowCount, errorCode, errorMessage, eventStart, eventStart + (long)fetchTime, false);
            }
            QMSessionInfo qmSessionInfo = userName == null ? null : new QMSessionInfo(userName, domainName);
            this.nextEvent = new QMMetaEventEntity((QMMObject)object, action, eventId, appSessionId, qmSessionInfo);
        } while (this.filter != null && !this.filter.accept((QMEvent)this.nextEvent));
    }

    public void close() {
        if (this.eventResults != null) {
            IOUtils.close((AutoCloseable)this.eventResults);
        }
        if (this.eventStat != null) {
            IOUtils.close((AutoCloseable)this.eventStat);
        }
    }

    @NotNull
    private String normalizeTableNames(@NotNull String sql) {
        return QMDBModel.getInstance().normalizeTableNames(sql);
    }
}

