/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm;

import com.dbeaver.model.qm.QMEventManager;
import com.dbeaver.model.qm.QMService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class QMEventListener
implements QMMetaListener {
    private static final Log log = Log.getLog(QMEventListener.class);
    private final QMEventManager qmEventManager;

    public QMEventListener(QMService service) throws DBException {
        if (!QMEventManager.class.isAssignableFrom(service.getClass())) {
            throw new DBException("The current qm service cannot be used for sending events");
        }
        this.qmEventManager = (QMEventManager)service;
    }

    public void dispose() {
        if (QMDisposable.class.isAssignableFrom(this.qmEventManager.getClass())) {
            ((QMDisposable)this.qmEventManager).dispose();
        }
    }

    public synchronized void metaInfoChanged(@NotNull DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        events = new ArrayList<QMMetaEvent>(events);
        this.filterEvents(events);
        Collections.reverse(events);
        monitor.beginTask("Persist events", events.size());
        try {
            try {
                monitor.subTask("Persisting QM events");
                this.qmEventManager.saveEvents(events);
                monitor.worked(events.size());
            }
            catch (Exception e) {
                log.debug((Object)"Error saving QM events", (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void filterEvents(@NotNull List<QMMetaEvent> events) {
        Predicate<QMMetaEvent> filter = e -> e.getAction() == QMEventAction.UPDATE || e.getObject() instanceof QMMStatementInfo || e.getObject() instanceof QMMTransactionSavepointInfo || e.getObject() instanceof QMMStatementExecuteInfo && e.getAction() != QMEventAction.END;
        events.removeIf(filter);
    }
}

