/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.azure;

import com.dbeaver.net.auth.azure.AuthModelAzureGroup;
import com.dbeaver.net.auth.azure.AzureAuthType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelAzureConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Label tenantIdLabel;
    private Text tenantIdText;
    private Label clientIdLabel;
    private Text clientIdText;
    private Label clientSecretLabel;
    private Text clientSecretText;
    private Label clientCertificateLabel;
    private TextWithOpen clientCertificateText;
    private Text groupText;
    private Label authTypeLabel;
    private Composite authTypeGroup;
    private Combo authTypeCombo;
    private final List<AzureAuthType> authTypes = new ArrayList<AzureAuthType>();
    private AzureAuthType curAuthType = AzureAuthType.WEB_APPLICATION;
    protected boolean isCloudProvided;
    private boolean staticCredentials;

    public void setStaticCredentials(boolean staticCredentials) {
        this.staticCredentials = staticCredentials;
    }

    protected boolean isForceSaveCredentials() {
        return this.staticCredentials;
    }

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, final @NotNull Runnable propertyChangeListener) {
        this.authTypeLabel = UIUtils.createControlLabel((Composite)authPanel, (String)"Credentials");
        this.authTypeGroup = UIUtils.createComposite((Composite)authPanel, (int)2);
        this.authTypeGroup.setLayoutData((Object)new GridData(32));
        this.authTypeCombo = new Combo(this.authTypeGroup, 12);
        this.authTypeCombo.setLayoutData((Object)new GridData(32));
        this.authTypeCombo.setToolTipText("Type of credentials");
        this.authTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AzureAuthType ct = AuthModelAzureConfigurator.this.authTypes.get(AuthModelAzureConfigurator.this.authTypeCombo.getSelectionIndex());
                AuthModelAzureConfigurator.this.changeAuthType(ct);
                propertyChangeListener.run();
            }
        });
        Link gcpCredDocsLink = new Link(this.authTypeGroup, 0);
        gcpCredDocsLink.setText("<a>Details</a>");
        gcpCredDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Azure-Credentials"));
            }
        });
        gcpCredDocsLink.setLayoutData((Object)new GridData(32));
        this.clientIdLabel = UIUtils.createControlLabel((Composite)authPanel, (String)"Client ID");
        this.clientIdText = new Text(authPanel, 2048);
        this.clientIdText.setLayoutData((Object)new GridData(768));
        this.clientIdText.setMessage("Identifier of the Azure AD Application used for authentication");
        this.clientIdText.addModifyListener(e -> propertyChangeListener.run());
        this.clientSecretLabel = UIUtils.createControlLabel((Composite)authPanel, (String)"Client Secret");
        this.clientSecretText = new Text(authPanel, 0x400800);
        this.clientSecretText.setLayoutData((Object)new GridData(768));
        this.clientSecretText.setMessage("Client secret value");
        this.clientSecretText.addModifyListener(e -> propertyChangeListener.run());
        this.tenantIdLabel = UIUtils.createControlLabel((Composite)authPanel, (String)"Tenant ID");
        this.tenantIdText = new Text(authPanel, 2048);
        this.tenantIdText.setLayoutData((Object)new GridData(768));
        this.tenantIdText.setMessage("Tenant ID, required in single-tenant applications");
        this.tenantIdText.addModifyListener(e -> propertyChangeListener.run());
        this.clientCertificateLabel = UIUtils.createControlLabel((Composite)authPanel, (String)"Client Certificate");
        this.clientCertificateText = new TextWithOpenFile(authPanel, "Client certificate", new String[]{"*", "*.pem", "*.crt"}, false);
        this.clientCertificateText.setLayoutData((Object)new GridData(768));
        this.clientCertificateText.getTextControl().addModifyListener(e -> propertyChangeListener.run());
        if (object instanceof AuthModelAzureGroup) {
            this.groupText = UIUtils.createLabelText((Composite)authPanel, (String)"AD Group name", null, (int)2048);
            this.groupText.setMessage("Group is required if access was granted on a group level");
        }
    }

    private void changeAuthType(AzureAuthType authType) {
        this.curAuthType = authType;
        this.updateSettingsVisibility();
    }

    private void updateSettingsVisibility() {
        UIUtils.setControlVisible((Control)this.authTypeLabel, (!this.isCloudProvided ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.authTypeGroup, (!this.isCloudProvided ? 1 : 0) != 0);
        boolean requiresClientInfo = this.curAuthType.requiresClientInfo();
        UIUtils.setControlVisible((Control)this.clientIdLabel, (boolean)requiresClientInfo);
        UIUtils.setControlVisible((Control)this.clientIdText, (boolean)requiresClientInfo);
        UIUtils.setControlVisible((Control)this.clientSecretLabel, (this.curAuthType == AzureAuthType.CLIENT_SECRET ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.clientSecretText, (this.curAuthType == AzureAuthType.CLIENT_SECRET ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.tenantIdLabel, (boolean)requiresClientInfo);
        UIUtils.setControlVisible((Control)this.tenantIdText, (boolean)requiresClientInfo);
        UIUtils.setControlVisible((Control)this.clientCertificateLabel, (this.curAuthType == AzureAuthType.CLIENT_CERTIFICATE ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.clientCertificateText, (this.curAuthType == AzureAuthType.CLIENT_CERTIFICATE ? 1 : 0) != 0);
        UIUtils.asyncExec(() -> {
            this.authTypeGroup.getShell().layout(true, true);
            UIUtils.resizeShell((Shell)this.authTypeGroup.getShell());
        });
    }

    public void initAuthTypes() {
        this.authTypeCombo.removeAll();
        this.authTypes.clear();
        AzureAuthType[] azureAuthTypeArray = this.getSupportedAuthTypes();
        int n = azureAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AzureAuthType ct = azureAuthTypeArray[n2];
            this.authTypes.add(ct);
            this.authTypeCombo.add(ct.getTitle());
            ++n2;
        }
    }

    private AzureAuthType[] getSupportedAuthTypes() {
        if (this.staticCredentials) {
            return new AzureAuthType[]{AzureAuthType.CLIENT_SECRET, AzureAuthType.CLIENT_CERTIFICATE};
        }
        if (DBWorkbench.isDistributed()) {
            return AzureAuthType.values();
        }
        return (AzureAuthType[])Arrays.stream(AzureAuthType.values()).filter(at -> at != AzureAuthType.SESSION_CREDENTIALS).toArray(AzureAuthType[]::new);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.isCloudProvided = !"local".equals(dataSource.getOrigin().getType());
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        if (configuration.getAuthProperties() != null) {
            authProperties.putAll(configuration.getAuthProperties());
        }
        this.loadGeneralAuthSettings(authProperties);
        if (this.groupText != null) {
            this.groupText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getAuthProperty("azureGroup")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this.saveGeneralAuthSettings(props);
        dataSource.getConnectionConfiguration().setAuthProperties(props);
        if (this.groupText != null) {
            String groupName = this.groupText.getText();
            if (groupName.isEmpty()) {
                groupName = null;
            }
            dataSource.getConnectionConfiguration().setAuthProperty("azureGroup", groupName);
        }
    }

    public void loadGeneralAuthSettings(Map<String, String> authProperties) {
        this.initAuthTypes();
        this.curAuthType = (AzureAuthType)CommonUtils.valueOf(AzureAuthType.class, (String)authProperties.get("azure.auth-type"), (Enum)this.curAuthType);
        this.authTypeCombo.select(this.authTypes.indexOf(this.curAuthType));
        if (this.clientIdText != null) {
            this.clientIdText.setText(CommonUtils.notEmpty((String)authProperties.get("azure.client-id")));
            this.clientSecretText.setText(CommonUtils.notEmpty((String)authProperties.get("azure.client-secret")));
            this.tenantIdText.setText(CommonUtils.notEmpty((String)authProperties.get("azure.tenant-id")));
            if (this.clientCertificateText != null) {
                String certPropName = DBWorkbench.isDistributed() ? "azure.client-certificate-value" : "azure.client-certificate-path";
                this.clientCertificateText.setText(CommonUtils.notEmpty((String)authProperties.get(certPropName)));
            }
        }
        this.changeAuthType(this.curAuthType);
    }

    public void saveGeneralAuthSettings(Map<String, String> props) {
        props.put("azure.auth-type", this.curAuthType.name());
        if (this.clientIdText != null) {
            String clientID = this.clientIdText.getText();
            if (clientID.isEmpty()) {
                clientID = null;
            }
            props.put("azure.client-id", clientID);
        }
        if (this.clientSecretText != null) {
            String clientSecret = this.clientSecretText.getText();
            if (clientSecret.isEmpty()) {
                clientSecret = null;
            }
            props.put("azure.client-secret", clientSecret);
        }
        if (this.tenantIdText != null) {
            String tenantID = this.tenantIdText.getText();
            if (tenantID.isEmpty()) {
                tenantID = null;
            }
            props.put("azure.tenant-id", tenantID);
        }
        if (this.clientCertificateText != null) {
            String clientCertificate = this.clientCertificateText.getText();
            if (clientCertificate.isEmpty()) {
                clientCertificate = null;
            }
            String certPropName = DBWorkbench.isDistributed() ? "azure.client-certificate-value" : "azure.client-certificate-path";
            props.put(certPropName, clientCertificate);
        }
    }

    public void updateControls() {
    }
}

