/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.data;

import com.dbeaver.db.couchdb.CouchDBUtils;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public class CouchDBDocument
extends DBAbstractDocument<CouchDBDataSource, JsonObject>
implements DBDValueCloneable {
    private static final Log log = Log.getLog(CouchDBDocument.class);

    public CouchDBDocument(@NotNull CouchDBDataSource dataSource, @NotNull JsonObject jsonDocument) {
        super((DBPDataSource)dataSource, (Object)jsonDocument);
    }

    @Nullable
    public Object getDocumentId() {
        JsonElement id = ((JsonObject)this.rawValue).get("_id");
        return id == null ? null : id.getAsString();
    }

    public Object getDocumentProperty(String name) {
        if (name.equals("idAttributeName")) {
            return "_id";
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<CouchDBDataSource> makeRawMap() {
        return CouchDBUtils.makeMapValue((CouchDBDataSource)this.dataSource, (Object)this, (JsonObject)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(stream, charset);){
            ((CouchDBDataSource)this.dataSource).serializeDocument((JsonObject)this.getRawValue(), (Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream, charset);){
            String json = IOUtils.readToString((Reader)reader);
            this.rawValue = (JsonObject)((CouchDBDataSource)this.dataSource).getDefaultInstance().getClient().getGson().fromJson(json, JsonObject.class);
            this.rawMap = this.makeRawMap();
            this.markModified();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public CouchDBDocument copy() {
        return new CouchDBDocument((CouchDBDataSource)this.dataSource, (JsonObject)this.rawValue);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return this.copy();
    }

    public String toString() {
        return ((JsonObject)this.rawValue).toString();
    }

    public Map<String, Object> getPlainMap() {
        return CouchDBUtils.unwrapMapValue((DBMapValue<CouchDBDataSource>)this.getRootNode());
    }
}

